/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.interaction;

import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Logger;
import jd.config.ConfigContainer;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.interaction.ExternExecute;
import jd.controlling.interaction.InteractionTrigger;
import jd.controlling.interaction.JDExit;
import jd.controlling.interaction.ResetLink;
import jd.controlling.interaction.SimpleExecute;
import jd.event.ControlEvent;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Interaction
extends Property
implements Serializable {
    public static InteractionTrigger INTERACTION_NO_EVENT;
    public static InteractionTrigger INTERACTION_SINGLE_DOWNLOAD_FINISHED;
    public static InteractionTrigger INTERACTION_ALL_DOWNLOADS_FINISHED;
    public static InteractionTrigger INTERACTION_DOWNLOAD_FAILED;
    public static InteractionTrigger INTERACTION_LINKLIST_STRUCTURE_CHANGED;
    public static InteractionTrigger INTERACTION_APPSTART;
    public static InteractionTrigger INTERACTION_DOWNLOAD_PACKAGE_FINISHED;
    public static InteractionTrigger INTERACTION_BEFORE_RECONNECT;
    public static InteractionTrigger INTERACTION_AFTER_RECONNECT;
    public static InteractionTrigger INTERACTION_AFTER_DOWNLOAD_AND_INTERACTIONS;
    public static InteractionTrigger INTERACTION_CONTAINER_DOWNLOAD;
    public static InteractionTrigger INTERACTION_BEFORE_DOWNLOAD;
    public static InteractionTrigger INTERACTION_EXIT;
    private static Integer interactionsRunning;
    protected static Logger logger;
    private static final transient long serialVersionUID = -5609631258725998799L;
    protected transient ConfigContainer config = null;
    private InteractionTrigger trigger;

    static {
        interactionsRunning = 0;
        logger = JDLogger.getLogger();
    }

    public static Interaction[] getInteractionList() {
        return new Interaction[]{new SimpleExecute(), new ExternExecute(), new JDExit(), new ResetLink()};
    }

    public static void initTriggers() {
        INTERACTION_NO_EVENT = new InteractionTrigger(0, JDL.L((String)"interaction.trigger.no_event", (String)"Kein Event"), JDL.L((String)"interaction.trigger.no_event.desc", (String)"kein Event"));
        INTERACTION_SINGLE_DOWNLOAD_FINISHED = new InteractionTrigger(1, JDL.L((String)"interaction.trigger.download_successfull", (String)"Download erfolgreich beendet"), JDL.L((String)"interaction.trigger.download_successfull.desc", (String)"Wird aufgerufen sobald ein Download erfolgreich beendet wurde"));
        INTERACTION_ALL_DOWNLOADS_FINISHED = new InteractionTrigger(2, JDL.L((String)"interaction.trigger.all_downloads_finished", (String)"Alle Downloads beendet"), JDL.L((String)"interaction.trigger.all_downloads_finished.desc", (String)"Wird aufgerufen sobald alle Downloads beendet oder abgebrochen wurden"));
        INTERACTION_DOWNLOAD_FAILED = new InteractionTrigger(3, JDL.L((String)"interaction.trigger.single_download_failed", (String)"Download fehlgeschlagen"), JDL.L((String)"interaction.trigger.single_download_failed.desc", (String)"Wird aufgerufen wenn ein Download wegen Fehlern abgebrochen wurde"));
        INTERACTION_LINKLIST_STRUCTURE_CHANGED = new InteractionTrigger(4, JDL.L((String)"interaction.trigger.linklist_structure_changed", (String)"Linklisten Struktur ge\u00e4ndert"), JDL.L((String)"interaction.trigger.linklist_structure_changed.desc", (String)"Wird aufgerufen wenn sich die Struktur der Linkliste ge\u00e4ndert hat (Links eingef\u00fcgt, Links fertig, ...)"));
        INTERACTION_APPSTART = new InteractionTrigger(7, JDL.L((String)"interaction.trigger.app_start", (String)"Programmstart"), JDL.L((String)"interaction.trigger.app_start.desc", (String)"Direkt nach dem Initialisieren von jDownloader"));
        INTERACTION_DOWNLOAD_PACKAGE_FINISHED = new InteractionTrigger(12, JDL.L((String)"interaction.trigger.package_finished", (String)"Paket fertig"), JDL.L((String)"interaction.trigger.package_finished.desc", (String)"Wird aufgerufen wenn ein Paket fertig geladen wurde"));
        INTERACTION_BEFORE_RECONNECT = new InteractionTrigger(13, JDL.L((String)"interaction.trigger.before_reconnect", (String)"Vor dem Reconnect"), JDL.L((String)"interaction.trigger.before_reconnect.desc", (String)"Vor dem eigentlichen Reconnect"));
        INTERACTION_AFTER_RECONNECT = new InteractionTrigger(14, JDL.L((String)"interaction.trigger.after_reconnect", (String)"Nach dem Reconnect"), JDL.L((String)"interaction.trigger.after_reconnect.desc", (String)"Nach dem eigentlichen Reconnect"));
        INTERACTION_AFTER_DOWNLOAD_AND_INTERACTIONS = new InteractionTrigger(15, JDL.L((String)"interaction.trigger.downloads_and_interactions_finished", (String)"Downloads & Interactionen abgeschlossen"), JDL.L((String)"interaction.trigger.downloads_and_interactions_finished.desc", (String)"Wird aufgerufen wenn alle Downloads und alle Interactionen beendet sind."));
        INTERACTION_CONTAINER_DOWNLOAD = new InteractionTrigger(16, JDL.L((String)"interaction.trigger.container_download", (String)"Linkcontainer geladen"), JDL.L((String)"interaction.trigger.download_download.desc", (String)"Wird aufgerufen wenn ein LinkContainer(DLC,RSDF,CCF,...) geladen wurde"));
        INTERACTION_BEFORE_DOWNLOAD = new InteractionTrigger(17, JDL.L((String)"interaction.trigger.before_download", (String)"Vor einem Download"), JDL.L((String)"interaction.trigger.before_download.desc", (String)"Wird aufgerufen bevor ein neuer Download gestartet wird"));
        INTERACTION_EXIT = new InteractionTrigger(20, JDL.L((String)"interaction.trigger.exit", (String)"JD wird beendet"), JDL.L((String)"interaction.trigger.exit.desc", (String)"Wird beim Beenden vor dem Schlie\u00dfen des Programms aufgerufen"));
    }

    public static Vector<Interaction> getSavedInteractions() {
        return SubConfiguration.getConfig("EVENTS").getGenericProperty("INTERACTIONS", new Vector());
    }

    public static Interaction[] getInteractions(InteractionTrigger trigger) {
        Vector<Interaction> interactions = Interaction.getSavedInteractions();
        Vector<Interaction> ret = new Vector<Interaction>();
        int i = 0;
        while (i < interactions.size()) {
            if (interactions.get(i).getTrigger().getID() == trigger.getID()) {
                ret.add(interactions.get(i));
            }
            ++i;
        }
        return ret.toArray(new Interaction[0]);
    }

    public static synchronized boolean areInteractionsInProgress() {
        return interactionsRunning == 0;
    }

    public static void handleInteraction(InteractionTrigger trigger, Object param) {
        logger.finer("Interaction start: Trigger: " + trigger.getName());
        JDUtilities.getController().fireControlEvent(new ControlEvent(trigger, 28, param));
        Vector<Interaction> interactions = Interaction.getSavedInteractions();
        for (Interaction interaction : interactions) {
            if (interaction == null || interaction.getTrigger() == null || interaction.getTrigger().getID() != trigger.getID()) continue;
            logger.finer("Aktion start: " + interaction.getInteractionName() + "(" + param + ")");
            if (!interaction.interact(param)) {
                logger.severe("interaction failed: " + interaction);
                continue;
            }
            logger.info("interaction successfull: " + interaction);
        }
        if (trigger.getID() == INTERACTION_ALL_DOWNLOADS_FINISHED.getID() && Interaction.areInteractionsInProgress() && JDUtilities.getController().getFinishedLinks().size() > 0) {
            Interaction.handleInteraction(INTERACTION_AFTER_DOWNLOAD_AND_INTERACTIONS, null);
        }
    }

    public Interaction() {
        this.setTrigger(INTERACTION_NO_EVENT);
    }

    protected abstract boolean doInteraction(Object var1);

    public void fireControlEvent(int controlID, Object param) {
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, controlID, param));
    }

    public final ConfigContainer getConfig() {
        if (this.config == null) {
            this.config = new ConfigContainer();
            this.initConfig();
        }
        return this.config;
    }

    public abstract String getInteractionName();

    public final InteractionTrigger getTrigger() {
        return this.trigger;
    }

    public final String getTriggerName() {
        return this.trigger.toString();
    }

    public abstract void initConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean interact(Object arg) {
        Integer n = interactionsRunning;
        synchronized (n) {
            interactionsRunning = interactionsRunning + 1;
        }
        logger.finer("Interaction start: " + interactionsRunning + " - " + this);
        this.fireControlEvent(5, arg);
        boolean success = this.doInteraction(arg);
        this.fireControlEvent(4, arg);
        Integer n2 = interactionsRunning;
        synchronized (n2) {
            interactionsRunning = interactionsRunning - 1;
        }
        logger.info("Interaction finished: " + interactionsRunning + " - " + this);
        return success;
    }

    public final void setTrigger(InteractionTrigger trigger) {
        this.trigger = trigger;
    }

    @Override
    public abstract String toString();
}

