/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.io.File;
import jd.config.ConfigEntry;
import jd.config.Configuration;
import jd.config.Property;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class ExternReconnect
extends ReconnectMethod {
    private Configuration configuration = JDUtilities.getConfiguration();
    private static final String PROPERTY_IP_WAIT_FOR_RETURN = "WAIT_FOR_RETURN2";
    private static final String PROPERTY_RECONNECT_COMMAND = "InteractionExternReconnect_Command";
    private static final String PROPERTY_RECONNECT_PARAMETER = "EXTERN_RECONNECT__PARAMETER";

    public void initConfig() {
        this.config.addEntry(new ConfigEntry(7, (Property)this.configuration, PROPERTY_RECONNECT_COMMAND, JDL.L((String)"interaction.externreconnect.command", (String)"Befehl (absolute Pfade verwenden)")));
        this.config.addEntry(new ConfigEntry(10, (Property)this.configuration, PROPERTY_RECONNECT_PARAMETER, JDL.L((String)"interaction.externreconnect.parameter", (String)"Parameter (1 Parameter/Zeile)")));
        this.config.addEntry(new ConfigEntry(8, this.configuration, PROPERTY_IP_WAIT_FOR_RETURN, JDL.L((String)"interaction.externreconnect.waitForTermination", (String)"Warten x Sekunden bis Befehl beendet ist [sek]"), -1, 600).setDefaultValue(-1));
    }

    protected boolean runCommands(ProgressController progress) {
        int waitForReturn = this.configuration.getIntegerProperty(PROPERTY_IP_WAIT_FOR_RETURN, -1);
        String command = this.configuration.getStringProperty(PROPERTY_RECONNECT_COMMAND);
        File f = new File(command);
        String t = f.getAbsolutePath();
        String executeIn = t.substring(0, t.indexOf(f.getName()) - 1);
        String parameter = this.configuration.getStringProperty(PROPERTY_RECONNECT_PARAMETER);
        logger.finer("Execute Returns: " + JDUtilities.runCommand(command, Regex.getLines(parameter), executeIn, waitForReturn));
        return true;
    }

    public String toString() {
        return JDL.L((String)"interaction.externreconnect.toString", (String)"Externes Reconnectprogramm aufrufen");
    }
}

