/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import jd.config.Configuration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.http.Browser;
import jd.http.JDProxy;
import jd.http.RequestHeader;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.CLRLoader;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPLiveHeader
extends ReconnectMethod {
    private Configuration configuration = JDUtilities.getConfiguration();
    private HashMap<String, String> headerProperties;
    private HashMap<String, String> variables;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean runCommands(ProgressController progress) {
        String[] ret;
        String script = this.configuration.getIntegerProperty("RECONNECT_TYPE", 0) == 3 ? ((ret = CLRLoader.createLiveHeader(this.configuration.getStringProperty("HTTPSEND_REQUESTS_CLR"))) != null ? ret[1] : null) : this.configuration.getStringProperty("HTTPSEND_REQUESTS");
        String user = this.configuration.getStringProperty("HTTPSEND_USER");
        String pass = this.configuration.getStringProperty("HTTPSEND_PASS");
        String ip = this.configuration.getStringProperty("HTTPSEND_IP");
        if (script == null || script.length() == 0) {
            progress.doFinalize();
            logger.severe("No LiveHeader Script found");
            return false;
        }
        script = script.replaceAll("\\[\\[\\[", "<");
        script = script.replaceAll("\\]\\]\\]", ">");
        script = script.replaceAll("<REQUEST(.*?)>", "<REQUEST$1><![CDATA[");
        script = script.replaceAll("</REQUEST>", "]]></REQUEST>");
        script = script.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
        script = script.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        this.variables = new HashMap();
        this.variables.put("user", user);
        this.variables.put("pass", pass);
        this.variables.put("basicauth", Encoding.Base64Encode(String.valueOf(user) + ":" + pass));
        this.variables.put("routerip", ip);
        this.headerProperties = new HashMap();
        Browser br = new Browser();
        br.setProxy(JDProxy.NO_PROXY);
        if (user != null && pass != null) {
            br.setAuth(ip, user, pass);
        }
        try {
            Document xmlScript = JDUtilities.parseXmlString(script, false);
            if (xmlScript == null) {
                progress.doFinalize();
                logger.severe("Error while parsing the xml string: " + script);
                return false;
            }
            Node root = xmlScript.getChildNodes().item(0);
            if (root == null || !root.getNodeName().equalsIgnoreCase("HSRC")) {
                progress.doFinalize();
                logger.severe("Root Node must be [[[HSRC]]]*[/HSRC]");
                return false;
            }
            NodeList steps = root.getChildNodes();
            progress.addToMax(steps.getLength());
            int step = 0;
            while (step < steps.getLength()) {
                progress.setStatusText(String.valueOf(JDL.L((String)"interaction.liveHeader.progress.3_step", (String)"(STEP)HTTPLiveHeader :")) + step);
                progress.increase(1L);
                Node current = steps.item(step);
                if (current.getNodeType() != 3) {
                    if (!current.getNodeName().equalsIgnoreCase("STEP")) {
                        progress.doFinalize();
                        logger.severe("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
                        return false;
                    }
                    NodeList toDos = current.getChildNodes();
                    int toDoStep = 0;
                    while (toDoStep < toDos.getLength()) {
                        String[] tmp;
                        NamedNodeMap attributes;
                        Node toDo = toDos.item(toDoStep);
                        progress.setStatusText(JDL.LF((String)"interaction.liveHeader.progress.4_step", (String)"(%s)HTTPLiveHeader", (Object[])new Object[]{toDo.getNodeName()}));
                        if (toDo.getNodeName().equalsIgnoreCase("DEFINE")) {
                            attributes = toDo.getAttributes();
                            int attribute = 0;
                            while (attribute < attributes.getLength()) {
                                String key = attributes.item(attribute).getNodeName();
                                String value = attributes.item(attribute).getNodeValue();
                                tmp = value.split("\\%\\%\\%(.*?)\\%\\%\\%");
                                String[] params = new Regex(value, "%%%(.*?)%%%").getColumn(-1);
                                if (params.length > 0) {
                                    int i;
                                    StringBuilder req;
                                    if (value.startsWith(params[0])) {
                                        req = new StringBuilder();
                                        logger.finer("Variables: " + this.variables);
                                        logger.finer("Headerproperties: " + this.headerProperties);
                                        i = 0;
                                        while (i <= tmp.length) {
                                            logger.finer("Replace variable: ********(" + params[i - 1] + ")");
                                            req.append(this.getModifiedVariable(params[i - 1]));
                                            if (i < tmp.length) {
                                                req.append(tmp[i]);
                                            }
                                            ++i;
                                        }
                                    } else {
                                        req = new StringBuilder(tmp[0]);
                                        logger.finer("Variables: " + this.variables);
                                        logger.finer("Headerproperties: " + this.headerProperties);
                                        i = 1;
                                        while (i <= tmp.length) {
                                            if (i <= params.length) {
                                                logger.finer("Replace variable: *********(" + params[i - 1] + ")");
                                                req.append(this.getModifiedVariable(params[i - 1]));
                                                if (i < tmp.length) {
                                                    req.append(tmp[i]);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    value = req.toString();
                                }
                                this.variables.put(key, value);
                                ++attribute;
                            }
                            logger.finer("Variables set: " + this.variables);
                        }
                        if (toDo.getNodeName().equalsIgnoreCase("PARSE")) {
                            String[] parseLines;
                            tmp = parseLines = HTTPLiveHeader.splitLines(toDo.getChildNodes().item(0).getNodeValue().trim());
                            int value = parseLines.length;
                            int key = 0;
                            while (key < value) {
                                String parseLine = tmp[key];
                                String varname = new Regex(parseLine, "(.*?):").getMatch(0);
                                String pattern = new Regex(parseLine, ".*?:(.+)").getMatch(0);
                                if (varname != null && pattern != null) {
                                    varname = varname.trim();
                                    String found = br.getRegex(pattern = pattern.trim()).getMatch(0);
                                    if (found != null) {
                                        found = found.trim();
                                        logger.finer("Parse: Varname=" + varname + " Pattern=" + pattern + "->" + found);
                                        this.variables.put(varname, found);
                                    } else {
                                        logger.finer("Parse: Varname=" + varname + " Pattern=" + pattern + "->NOT FOUND!");
                                    }
                                }
                                ++key;
                            }
                        }
                        if (toDo.getNodeName().equalsIgnoreCase("REQUEST")) {
                            boolean ishttps = false;
                            boolean israw = false;
                            if (toDo.getChildNodes().getLength() != 1) {
                                progress.doFinalize();
                                logger.severe("A REQUEST Tag is not allowed to have childTags.");
                                return false;
                            }
                            NamedNodeMap attributes2 = toDo.getAttributes();
                            if (attributes2.getNamedItem("https") != null) {
                                ishttps = true;
                            }
                            if (attributes2.getNamedItem("raw") != null) {
                                israw = true;
                            }
                            Browser retbr = null;
                            try {
                                retbr = this.doRequest(toDo.getChildNodes().item(0).getNodeValue().trim(), br, ishttps, israw);
                            }
                            catch (Exception e2) {
                                retbr = null;
                            }
                            try {
                                Thread.sleep(150L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (retbr == null || !retbr.getHttpConnection().isOK()) {
                                logger.severe("Request error!");
                            } else {
                                br = retbr;
                            }
                        }
                        if (toDo.getNodeName().equalsIgnoreCase("RESPONSE")) {
                            logger.finer("get Response");
                            if (toDo.getChildNodes().getLength() != 1) {
                                progress.doFinalize();
                                logger.severe("A RESPONSE Tag is not allowed to have childTags.");
                                return false;
                            }
                            attributes = toDo.getAttributes();
                            if (attributes.getNamedItem("keys") == null) {
                                progress.doFinalize();
                                logger.severe("A RESPONSE Node needs a Keys Attribute: " + toDo);
                                return false;
                            }
                            String[] keys = attributes.getNamedItem("keys").getNodeValue().split("\\;");
                            this.getVariables(toDo.getChildNodes().item(0).getNodeValue().trim(), keys, br);
                        }
                        if (toDo.getNodeName().equalsIgnoreCase("WAIT")) {
                            attributes = toDo.getAttributes();
                            Node item = attributes.getNamedItem("seconds");
                            if (item == null) {
                                logger.severe("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                                return false;
                            }
                            logger.finer("Wait " + item.getNodeValue() + " seconds");
                            int seconds = Formatter.filterInt(item.getNodeValue());
                            Thread.sleep(seconds * 1000);
                        }
                        ++toDoStep;
                    }
                }
                ++step;
            }
        }
        catch (Exception e) {
            JDLogger.exception(e);
            progress.doFinalize();
            logger.severe(e.getCause() + " : " + e.getMessage());
            return false;
        }
        return true;
    }

    private Browser doRequest(String request, Browser br, boolean ishttps, boolean israw) {
        block35: {
            String path;
            String requestType;
            HashMap<String, String> requestProperties;
            String http;
            String host;
            StringBuilder post;
            block34: {
                String[] requestLines;
                String[] tmp;
                block33: {
                    block32: {
                        post = new StringBuilder();
                        host = null;
                        http = "http://";
                        if (ishttps) {
                            http = "https://";
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            br.forceDebug(true);
                        } else {
                            br.forceDebug(false);
                        }
                        requestProperties = new HashMap<String, String>();
                        if (israw) {
                            br.setHeaders(new RequestHeader());
                        }
                        tmp = request.split("\\%\\%\\%(.*?)\\%\\%\\%");
                        String[] params = new Regex(request, "%%%(.*?)%%%").getColumn(0);
                        if (params.length > 0) {
                            int i;
                            StringBuilder req;
                            if (request.startsWith(params[0])) {
                                req = new StringBuilder();
                                logger.finer("Variables: " + this.variables);
                                logger.finer("Headerproperties: " + this.headerProperties);
                                i = 0;
                                while (i <= tmp.length) {
                                    logger.finer("Replace variable: " + this.getModifiedVariable(params[i - 1]) + "(" + params[i - 1] + ")");
                                    req.append(this.getModifiedVariable(params[i - 1]));
                                    if (i < tmp.length) {
                                        req.append(tmp[i]);
                                    }
                                    ++i;
                                }
                            } else {
                                req = new StringBuilder(tmp[0]);
                                logger.finer("Variables: " + this.variables);
                                logger.finer("Headerproperties: " + this.headerProperties);
                                i = 1;
                                while (i <= tmp.length) {
                                    if (i <= params.length) {
                                        logger.finer("Replace variable: " + this.getModifiedVariable(params[i - 1]) + "(" + params[i - 1] + ")");
                                        req.append(this.getModifiedVariable(params[i - 1]));
                                        if (i < tmp.length) {
                                            req.append(tmp[i]);
                                        }
                                    }
                                    ++i;
                                }
                            }
                            request = req.toString();
                        }
                        if ((requestLines = HTTPLiveHeader.splitLines(request)).length != 0) break block32;
                        logger.severe("Parse Fehler:" + request);
                        return null;
                    }
                    tmp = requestLines[0].split(" ");
                    if (tmp.length >= 2) break block33;
                    logger.severe("Konnte Requesttyp nicht finden: " + requestLines[0]);
                    return null;
                }
                try {
                    requestType = tmp[0];
                    path = tmp[1];
                    boolean headersEnd = false;
                    int li = 1;
                    while (li < requestLines.length) {
                        if (headersEnd) {
                            post.append(requestLines[li]);
                            post.append(new char[]{'\r', '\n'});
                        } else if (requestLines[li].trim().length() == 0) {
                            headersEnd = true;
                        } else {
                            String[] p = requestLines[li].split("\\:");
                            if (p.length < 2) {
                                logger.warning("Syntax Fehler in: " + requestLines[li] + "\r\n Vermute Post Parameter");
                                headersEnd = true;
                                --li;
                            } else {
                                requestProperties.put(p[0].trim(), requestLines[li].substring(p[0].length() + 1).trim());
                                if (p[0].trim().equalsIgnoreCase("HOST")) {
                                    host = requestLines[li].substring(p[0].length() + 1).trim();
                                }
                            }
                        }
                        ++li;
                    }
                    if (host != null) break block34;
                    logger.severe("Host nicht gefunden: " + request);
                    return null;
                }
                catch (Exception e) {
                    JDLogger.exception(e);
                    return null;
                }
            }
            br.setConnectTimeout(5000);
            br.setReadTimeout(5000);
            if (requestProperties != null) {
                br.getHeaders().putAll(requestProperties);
            }
            if (requestType.equalsIgnoreCase("GET")) {
                br.getPage(String.valueOf(http) + host + path);
                break block35;
            }
            if (requestType.equalsIgnoreCase("POST")) {
                String poster = post.toString().trim();
                br.postPageRaw(String.valueOf(http) + host + path, poster);
                break block35;
            }
            if (requestType.equalsIgnoreCase("AUTH")) {
                logger.finer("Convert AUTH->GET");
                br.getPage(String.valueOf(http) + host + path);
                break block35;
            }
            logger.severe("Unknown requesttyp: " + requestType);
            return null;
        }
        try {
            return br;
        }
        catch (IOException e) {
            logger.severe("IO Error: " + e.getLocalizedMessage());
            JDLogger.exception(e);
            return null;
        }
    }

    public ArrayList<String[]> getLHScripts() {
        File[] list = new File(new File(JDUtilities.getJDHomeDirectoryFromEnvironment(), "jd"), "router").listFiles();
        ArrayList<String[]> ret = new ArrayList<String[]>();
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            if (element.isFile() && element.getName().toLowerCase().matches(".*\\.xml$")) {
                ret.addAll((Collection)JDIO.loadObject(new JFrame(), element, true));
            }
            ++n2;
        }
        return ret;
    }

    private static String[] splitLines(String source) {
        return source.split("\r\n|\r|\n");
    }

    /*
     * Unable to fully structure code
     */
    private String getModifiedVariable(String key) {
        if (key.indexOf(":::") == -1 && this.headerProperties.containsKey(key)) {
            return this.headerProperties.get(key);
        }
        if (key.indexOf(":::") == -1) {
            return this.variables.get(key);
        }
        ret = this.variables.get(key.substring(key.lastIndexOf(":::") + 3));
        if (this.headerProperties.containsKey(key.substring(key.lastIndexOf(":::") + 3))) {
            ret = this.headerProperties.get(key.substring(key.lastIndexOf(":::") + 3));
        }
        if (ret != null) ** GOTO lbl29
        return "";
lbl-1000:
        // 1 sources

        {
            fnc = key.substring(0, id);
            key = key.substring(id + 3);
            if (fnc.equalsIgnoreCase("URLENCODE")) {
                ret = Encoding.urlEncode(ret);
                continue;
            }
            if (fnc.equalsIgnoreCase("URLDECODE")) {
                ret = Encoding.htmlDecode(ret);
                continue;
            }
            if (fnc.equalsIgnoreCase("UTF8DECODE")) {
                ret = Encoding.UTF8Decode(ret);
                continue;
            }
            if (fnc.equalsIgnoreCase("UTF8ENCODE")) {
                ret = Encoding.UTF8Encode(ret);
                continue;
            }
            if (fnc.equalsIgnoreCase("MD5")) {
                ret = JDHash.getMD5(ret);
                continue;
            }
            if (!fnc.equalsIgnoreCase("BASE64")) continue;
            ret = Encoding.Base64Encode(ret);
lbl29:
            // 8 sources

            ** while ((id = key.indexOf((String)":::")) >= 0)
        }
lbl30:
        // 1 sources

        return ret;
    }

    private void getVariables(String patStr, String[] keys, Browser br) {
        logger.info("GetVariables");
        if (br == null) {
            return;
        }
        logger.finer(patStr);
        Pattern pattern = Pattern.compile(patStr, 34);
        Matcher matcher = pattern.matcher("" + br);
        logger.info("Matches: " + matcher.groupCount());
        if (matcher.find() && matcher.groupCount() > 0) {
            int i = 0;
            while (i < keys.length && i < matcher.groupCount()) {
                this.variables.put(keys[i], matcher.group(i + 1));
                logger.info("Set Variable: " + keys[i] + " = " + matcher.group(i + 1));
                ++i;
            }
        } else {
            logger.severe("Regular Expression without matches: " + patStr);
        }
    }

    @Override
    public void initConfig() {
    }

    public String toString() {
        return JDL.L((String)"interaction.liveHeader.name", (String)"HTTP Live Header");
    }
}

