/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.awt.Color;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkCheck;
import jd.controlling.ProgressController;
import jd.controlling.interaction.Interaction;
import jd.controlling.reconnect.BatchReconnect;
import jd.controlling.reconnect.ExternReconnect;
import jd.controlling.reconnect.HTTPLiveHeader;
import jd.gui.UserIF;
import jd.http.IPCheck;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class Reconnecter {
    private static String CURRENT_IP = "";
    private static boolean RECONNECT_IN_PROGRESS = false;
    private static long LAST_UP_UPDATE_TIME = 0L;
    private static Logger logger = JDLogger.getLogger();
    private static boolean RECONNECT_REQUESTED = false;

    public static void toggleReconnect() {
        boolean newState = JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true) == false;
        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", newState);
        JDUtilities.getConfiguration().save();
        if (!newState) {
            UserIF.getInstance().displayMiniWarning(JDL.L((String)"gui.warning.reconnect.hasbeendisabled", (String)"Reconnect deaktiviert!"), JDL.L((String)"gui.warning.reconnect.hasbeendisabled.tooltip", (String)"Um erfolgreich einen Reconnect durchf\u00fchren zu k\u00f6nnen muss diese Funktion wieder aktiviert werden."));
        }
    }

    private static boolean checkExternalIPChange() {
        LAST_UP_UPDATE_TIME = System.currentTimeMillis();
        String tmp = CURRENT_IP;
        CURRENT_IP = IPCheck.getIPAddress(null);
        if (CURRENT_IP != null && tmp.length() > 0 && !tmp.equals(CURRENT_IP)) {
            logger.info("Detected external IP Change.");
            return true;
        }
        return false;
    }

    public static boolean doReconnect() {
        JDController controller = JDUtilities.getController();
        boolean ipChangeSuccess = false;
        if (System.currentTimeMillis() - LAST_UP_UPDATE_TIME > (long)(1000 * SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("EXTERNAL_IP_CHECK_INTERVAL", 600)) && Reconnecter.checkExternalIPChange()) {
            return true;
        }
        Interaction.handleInteraction(Interaction.INTERACTION_BEFORE_RECONNECT, controller);
        int type = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_TYPE", 0);
        logger.info("Try to reconnect...");
        ArrayList<DownloadLink> disabled = DownloadWatchDog.getInstance().getRunningDownloads();
        if (disabled.size() != 0) {
            logger.info("Stopping all running downloads!");
        }
        for (DownloadLink link : disabled) {
            link.setEnabled(false);
        }
        int wait = 0;
        while (wait < 10) {
            if (DownloadWatchDog.getInstance().getActiveDownloads() == 0) break;
            try {
                Thread.sleep(1000L);
                logger.info("Still waiting for all downloads to stop!");
            }
            catch (InterruptedException e) {
                break;
            }
            ++wait;
        }
        if (DownloadWatchDog.getInstance().getActiveDownloads() > 0) {
            logger.severe("Could not stop all running downloads!");
        }
        try {
            switch (type) {
                case 1: {
                    ipChangeSuccess = new ExternReconnect().doReconnect();
                    break;
                }
                case 2: {
                    ipChangeSuccess = new BatchReconnect().doReconnect();
                    break;
                }
                default: {
                    ipChangeSuccess = new HTTPLiveHeader().doReconnect();
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.severe("ReconnectMethod failed!");
        }
        for (DownloadLink link : disabled) {
            link.setEnabled(true);
        }
        LAST_UP_UPDATE_TIME = System.currentTimeMillis();
        CURRENT_IP = IPCheck.getIPAddress(null);
        return ipChangeSuccess;
    }

    public static boolean isReconnecting() {
        return RECONNECT_IN_PROGRESS;
    }

    public static boolean isReconnectPrefered() {
        return Reconnecter.isReconnectRequested() && JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true) != false && SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("PARAM_DOWNLOAD_PREFER_RECONNECT", true) != false && JDUtilities.getConfiguration().getBooleanProperty("LATEST_RECONNECT_RESULT", true) != false;
    }

    public static boolean doReconnectIfRequested(boolean bypassrcvalidation) {
        if (RECONNECT_IN_PROGRESS) {
            return false;
        }
        if (LinkCheck.getLinkChecker().isRunning()) {
            return false;
        }
        if (JDUtilities.getController().getForbiddenReconnectDownloadNum() > 0) {
            return false;
        }
        RECONNECT_IN_PROGRESS = true;
        boolean ret = false;
        try {
            ret = Reconnecter.doReconnectIfRequestedInternal(bypassrcvalidation);
            if (ret) {
                Reconnecter.resetAllLinks();
                Interaction.handleInteraction(Interaction.INTERACTION_AFTER_RECONNECT, JDUtilities.getController());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RECONNECT_IN_PROGRESS = false;
        return ret;
    }

    public static boolean doReconnectIfRequestedInternal(boolean bypassrcvalidation) {
        boolean ret = false;
        if (Reconnecter.isReconnectRequested()) {
            if (!JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true).booleanValue()) {
                if (System.currentTimeMillis() - LAST_UP_UPDATE_TIME > (long)(1000 * SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("EXTERNAL_IP_CHECK_INTERVAL", 600))) {
                    return Reconnecter.checkExternalIPChange();
                }
                return false;
            }
            if (bypassrcvalidation || JDUtilities.getConfiguration().getBooleanProperty("LATEST_RECONNECT_RESULT", true).booleanValue()) {
                try {
                    ret = Reconnecter.doReconnect();
                    if (ret) {
                        logger.info("Reconnect successfully!");
                    } else {
                        logger.info("Reconnect failed!");
                    }
                }
                catch (Exception e) {
                    logger.finest("Reconnect failed.");
                }
                if (!ret) {
                    ProgressController progress = new ProgressController(JDL.L((String)"jd.controlling.reconnect.Reconnector.progress.failed", (String)"Reconnect failed! Please check your reconnect Settings and try a Manual Reconnect!"), 100L);
                    progress.doFinalize(10000L);
                }
                JDUtilities.getConfiguration().setProperty("LATEST_RECONNECT_RESULT", ret);
                JDUtilities.getConfiguration().save();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAllLinks() {
        ArrayList<FilePackage> packages;
        ArrayList<FilePackage> arrayList = packages = JDUtilities.getController().getPackages();
        synchronized (arrayList) {
            for (FilePackage fp : packages) {
                for (DownloadLink nextDownloadLink : fp.getDownloadLinkList()) {
                    if (nextDownloadLink.getPlugin() == null || nextDownloadLink.getPlugin().getRemainingHosterWaittime() <= 0L || !nextDownloadLink.getLinkStatus().hasStatus(16)) continue;
                    nextDownloadLink.getLinkStatus().setStatus(1);
                    nextDownloadLink.getLinkStatus().resetWaitTime();
                    nextDownloadLink.getPlugin().resetHosterWaitTime();
                    logger.finer("Reset GLOBALS: " + nextDownloadLink.getPlugin());
                    nextDownloadLink.getPlugin().resetPluginGlobals();
                }
            }
        }
    }

    public static boolean waitForNewIP(long i) {
        boolean ret;
        Reconnecter.setReconnectRequested(true);
        final ProgressController progress = new ProgressController(JDL.LF((String)"gui.reconnect.progress.status", (String)"Reconnect running: %s m:s", (Object[])new Object[]{"0:00s"}), 2L);
        if (i > 0L) {
            i += System.currentTimeMillis();
        }
        progress.setStatus(1L);
        final long startTime = System.currentTimeMillis();
        Thread timer = new Thread(){

            public void run() {
                while (true) {
                    progress.setStatusText(JDL.LF((String)"gui.reconnect.progress.status2", (String)"Reconnect running: %s", (Object[])new Object[]{Formatter.formatSeconds((System.currentTimeMillis() - startTime) / 1000L)}));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        timer.start();
        while (!((ret = Reconnecter.doReconnectIfRequested(true)) || System.currentTimeMillis() >= i && i > 0L)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                ret = false;
                break;
            }
        }
        timer.interrupt();
        if (!ret) {
            progress.setColor(Color.RED);
            progress.setStatusText(JDL.L((String)"gui.reconnect.progress.status.failed", (String)"Reconnect failed"));
        } else {
            progress.setStatusText(JDL.L((String)"gui.reconnect.progress.status.success", (String)"Reconnect successfull"));
        }
        Reconnecter.setReconnectRequested(false);
        progress.doFinalize(4000L);
        return ret;
    }

    public static boolean doManualReconnect() {
        boolean oldState = JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true);
        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", true);
        boolean restartDownloads = JDUtilities.getController().stopDownloads();
        boolean success = Reconnecter.waitForNewIP(1L);
        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", oldState);
        if (restartDownloads) {
            JDUtilities.getController().startDownloads();
        }
        return success;
    }

    public static void setReconnectRequested(boolean reconnectRequested) {
        RECONNECT_REQUESTED = reconnectRequested;
    }

    public static boolean isReconnectRequested() {
        return RECONNECT_REQUESTED;
    }
}

