/*
 * Decompiled with CFR 0.152.
 */
package jd.event;

import java.util.EventListener;
import java.util.Vector;
import jd.controlling.JDLogger;
import jd.event.JDEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBroadcaster<T extends EventListener, TT extends JDEvent> {
    protected transient Vector<T> callList = new Vector();
    protected transient Vector<T> removeList = new Vector();

    public void addListener(T listener) {
        if (this.removeList.contains(listener)) {
            this.removeList.remove(listener);
        }
        if (!this.callList.contains(listener)) {
            this.callList.add(listener);
        }
    }

    public boolean hasListener() {
        return this.callList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireEvent(TT event) {
        Vector<T> vector = this.removeList;
        synchronized (vector) {
            this.callList.removeAll(this.removeList);
            this.removeList.clear();
        }
        int i = this.callList.size() - 1;
        while (i >= 0) {
            try {
                this.fireEvent((EventListener)this.callList.get(i), event);
            }
            catch (Exception e) {
                JDLogger.exception(e);
            }
            --i;
        }
        return false;
    }

    protected abstract void fireEvent(T var1, TT var2);

    public void removeListener(T listener) {
        if (!this.removeList.contains(listener)) {
            this.removeList.add(listener);
        }
    }

    public Vector<T> getListener() {
        return this.callList;
    }

    public void addAllListener(Vector<T> listener) {
        for (EventListener l : listener) {
            this.addListener(l);
        }
    }
}

