/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jd.http.HTTPConnection;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.parser.Regex;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPsConnection
extends HTTPConnection {
    private HttpsURLConnectionImpl delegate;

    public HTTPsConnection(URLConnection openConnection, Proxy p) {
        super(openConnection.getURL(), p, null);
        this.delegate = (HttpsURLConnectionImpl)openConnection;
        this.requestProperties = new HashMap();
        Map<String, List<String>> tmp = this.delegate.getRequestProperties();
        for (Map.Entry<String, List<String>> next : tmp.entrySet()) {
            this.requestProperties.put(next.getKey(), next.getValue());
        }
    }

    @Override
    public void connect() throws IOException {
        this.connectionnEstabilished = true;
        this.delegate.connect();
    }

    @Override
    public long getLongContentLength() {
        if (this.delegate.getHeaderField("content-length") == null) {
            return -1L;
        }
        return Long.parseLong(this.delegate.getHeaderField("content-length"));
    }

    @Override
    public int getContentLength() {
        if (this.delegate.getHeaderField("content-length") == null) {
            return -1;
        }
        return Integer.parseInt(this.delegate.getHeaderField("content-length"));
    }

    @Override
    public String getContentType() {
        String type = this.delegate.getContentType();
        if (type == null) {
            return "unknown";
        }
        return type;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.delegate.getResponseCode() != 404) {
            return this.delegate.getInputStream();
        }
        return this.delegate.getErrorStream();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.requestProperties;
    }

    @Override
    public void setDoOutput(boolean b) {
        this.delegate.setDoOutput(b);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(value);
        this.requestProperties.put(key, l);
        this.delegate.setRequestProperty(key, value);
    }

    @Override
    public boolean isOK() {
        try {
            return this.delegate.getResponseCode() > -2 && this.delegate.getResponseCode() < 400;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long[] getRange() {
        if (this.ranges != null) {
            return this.ranges;
        }
        String range = this.delegate.getHeaderField("Content-Range");
        if (range == null) {
            return null;
        }
        String[] ranges = new Regex(range, ".*?(\\d+).*?-.*?(\\d+).*?/.*?(\\d+)").getRow(0);
        if (ranges == null) {
            System.err.print("" + this);
            return null;
        }
        this.ranges = new long[]{Long.parseLong(ranges[0]), Long.parseLong(ranges[1]), Long.parseLong(ranges[2])};
        return this.ranges;
    }

    @Override
    public boolean isContentDisposition() {
        return this.delegate.getHeaderField("Content-Disposition") != null;
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            this.delegate.disconnect();
            this.connectionnEstabilished = false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-->" + this.getURL() + "\r\n");
        sb.append("----------------Request------------------\r\n");
        sb.append(String.valueOf(this.getRequestMethod()) + " " + this.getURL().getPath() + (this.getURL().getQuery() != null ? "?" + this.getURL().getQuery() : "") + " HTTP/1.1\r\n");
        for (Map.Entry<String, List<String>> next : this.getRequestProperties().entrySet()) {
            String v2;
            StringBuilder value = new StringBuilder();
            for (String v2 : next.getValue()) {
                value.append(';');
                value.append(v2);
            }
            v2 = value.toString();
            if (v2.length() > 0) {
                v2 = v2.substring(1);
            }
            sb.append(next.getKey());
            sb.append(new char[]{':', ' '});
            sb.append(v2);
            sb.append(new char[]{'\r', '\n'});
        }
        sb.append(new char[]{'\r', '\n'});
        if (this.getRequest() != null) {
            if (this.getRequest() instanceof PostRequest) {
                sb.append(((PostRequest)this.getRequest()).getPostDataString());
                sb.append(new char[]{'\r', '\n'});
            } else if (this.getRequest() instanceof PostFormDataRequest) {
                sb.append(((PostFormDataRequest)this.getRequest()).getPostDataString());
                sb.append(new char[]{'\r', '\n'});
            }
        }
        sb.append("----------------Response------------------\r\n");
        for (Map.Entry<String, List<String>> next : this.delegate.getHeaderFields().entrySet()) {
            int i = next.getValue().size() - 1;
            while (i >= 0) {
                if (next.getKey() == null) {
                    sb.append(next.getValue().get(i));
                    sb.append(new char[]{'\r', '\n'});
                } else {
                    sb.append(next.getKey());
                    sb.append(new char[]{':', ' '});
                    sb.append(next.getValue().get(i));
                    sb.append(new char[]{'\r', '\n'});
                }
                --i;
            }
        }
        sb.append(new char[]{'\r', '\n'});
        return sb.toString();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    @Override
    public String getHeaderField(String name) {
        return this.delegate.getHeaderField(name);
    }

    @Override
    public Map getHeaderFields() {
        return this.delegate.getHeaderFields();
    }

    @Override
    public String getHeaderField(int n) {
        return this.delegate.getHeaderField(n);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.delegate.getHeaderFieldKey(n);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.delegate.addRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.delegate.getRequestProperty(key);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.delegate.setConnectTimeout(timeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.delegate.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.delegate.setReadTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.delegate.getReadTimeout();
    }
}

