/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jd.controlling.JDLogger;
import jd.nutils.OSDetector;
import jd.nutils.jna.Win32.Shell32;

public class FileUtils {
    public static final int DeletePermanently = 0;
    public static final int MoveToRecycleBin = 1;
    private static int DefaultDeleteAction = 0;
    private static boolean CopyOverwriteAllowedByDefault = false;
    private static boolean MoveOverwriteAllowedByDefault = false;

    public static int getDefaultDeleteAction() {
        return DefaultDeleteAction;
    }

    public static void setDefaultDeleteAction(int defaultDeleteAction) {
        DefaultDeleteAction = defaultDeleteAction;
    }

    public static boolean isCopyOverwriteAllowedByDefault() {
        return CopyOverwriteAllowedByDefault;
    }

    public static void setCopyOverwriteAllowedByDefault(boolean copyOverwriteAllowedByDefault) {
        CopyOverwriteAllowedByDefault = copyOverwriteAllowedByDefault;
    }

    public static boolean isMoveOverwriteAllowedByDefault() {
        return MoveOverwriteAllowedByDefault;
    }

    public static void setMoveOverwriteAllowedByDefault(boolean moveOverwriteAllowedByDefault) {
        MoveOverwriteAllowedByDefault = moveOverwriteAllowedByDefault;
    }

    private static boolean deletePermanently(File file) {
        if (!file.isAbsolute()) {
            JDLogger.getLogger().warning("ATTENTION! Deleting file without absolute path (unrecommended): " + file);
        }
        if (!file.delete()) {
            JDLogger.getLogger().warning("Couldn't delete file instantly, deleteOnExit instead.");
            file.deleteOnExit();
        }
        JDLogger.getLogger().fine("File deleted: " + file);
        return true;
    }

    private static boolean movetoRecycleBin(File file) {
        boolean success = false;
        if (OSDetector.isWindows()) {
            Shell32 shell = Shell32.INSTANCE;
            Shell32.SHFILEOPSTRUCT fileop = new Shell32.SHFILEOPSTRUCT();
            File[] files = new File[]{file};
            fileop.wFunc = 3;
            String[] paths = new String[files.length];
            int i = 0;
            while (i < paths.length) {
                paths[i] = files[i].getAbsolutePath();
                ++i;
            }
            fileop.pFrom = fileop.encodePaths(paths);
            fileop.fFlags = (short)1108;
            int ret = shell.SHFileOperation(fileop);
            if (ret != 0 || fileop.fAnyOperationsAborted) {
                JDLogger.getLogger().warning("moving to trash failed with return message: " + ret);
                return false;
            }
            return true;
        }
        if (success) {
            JDLogger.getLogger().fine("File moved to recycle bin: " + file);
            return true;
        }
        return false;
    }

    public static boolean OShasRecycleBinSupport() {
        return OSDetector.isWindows();
    }

    public static boolean delete(File file, int method) {
        if (!file.exists()) {
            JDLogger.getLogger().warning("Trying to delete a nonexisting file: " + file.getAbsolutePath());
            return true;
        }
        if (method == 1 && FileUtils.OShasRecycleBinSupport() && FileUtils.movetoRecycleBin(file)) {
            return true;
        }
        if (method == 1 && !FileUtils.OShasRecycleBinSupport()) {
            JDLogger.getLogger().fine("No RecycleBin support for " + OSDetector.getOSString() + ". Deleting permanently instead.");
        }
        if (method == 1 && FileUtils.OShasRecycleBinSupport()) {
            JDLogger.getLogger().fine("Moving to recycle bin failed. OS[" + OSDetector.getOSString() + "] File[" + file.getAbsolutePath() + "]. Deleting permanently instead.");
        }
        return FileUtils.deletePermanently(file);
    }

    public static boolean delete(File file) {
        return FileUtils.delete(file, DefaultDeleteAction);
    }

    public static boolean delete(String file, int method) {
        if (file != null && file.trim().length() > 0) {
            return FileUtils.delete(new File(file), method);
        }
        return false;
    }

    public static boolean delete(String file) {
        return FileUtils.delete(file, DefaultDeleteAction);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static boolean copy(File src, File dest, boolean allowOverwrite) {
        boolean success;
        block28: {
            if (dest.exists()) {
                if (allowOverwrite) {
                    if (!dest.delete()) {
                        JDLogger.getLogger().warning("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
                        return false;
                    }
                } else {
                    JDLogger.getLogger().warning("Destination file [" + dest.getAbsolutePath() + "] already exists (Overwriting permitted)");
                    return false;
                }
            }
            success = true;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(src);
                    fos = new FileOutputStream(dest);
                    FileUtils.copy(fis, fos);
                }
                catch (IOException e) {
                    success = false;
                    e.printStackTrace();
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e2) {
                            success = false;
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e3) {
                            success = false;
                        }
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        success = false;
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        success = false;
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    success = false;
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    success = false;
                }
            }
        }
        if (success) {
            JDLogger.getLogger().fine(String.valueOf(src.getAbsolutePath()) + " has been copied to " + dest.getAbsolutePath());
            return true;
        }
        JDLogger.getLogger().warning("Couldn't copy file " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        return false;
    }

    public static boolean copy(File src, File dest) {
        return FileUtils.copy(src, dest, CopyOverwriteAllowedByDefault);
    }

    public static boolean move(File src, File dest, boolean allowOverwrite) {
        if (src == null || !src.exists()) {
            throw new IllegalStateException("File [" + src != null ? src.getAbsolutePath() : "] to move doesnt exist.");
        }
        if (dest.exists()) {
            if (allowOverwrite) {
                if (!FileUtils.delete(dest, 0)) {
                    JDLogger.getLogger().warning("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
                    return false;
                }
            } else {
                JDLogger.getLogger().warning("Destination file [" + dest.getAbsolutePath() + "] already exists (Overwriting permitted)");
                return false;
            }
        }
        boolean moved = false;
        if (src != null && !(moved = src.renameTo(dest))) {
            JDLogger.getLogger().fine("renameTo failed, trying to copy file now src[" + src.getAbsolutePath() + "] dest[" + dest.getAbsolutePath() + "]");
            if (FileUtils.copy(src, dest, allowOverwrite)) {
                if (dest.exists() && dest.length() == src.length()) {
                    FileUtils.delete(src, 0);
                    moved = true;
                } else if (dest.exists() && dest.length() != src.length()) {
                    JDLogger.getLogger().warning("Error while copying file: new file has a diffent lenght! src[" + src.getAbsolutePath() + "," + src.length() + "] dest[" + dest.getAbsolutePath() + "," + dest.length() + "]");
                }
            }
        }
        if (moved) {
            JDLogger.getLogger().fine(String.valueOf(src.getAbsolutePath()) + " has been moved to " + dest.getAbsolutePath());
        } else {
            JDLogger.getLogger().warning("Couldn't move file " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        return moved;
    }

    public static boolean move(File src, File dest) {
        return FileUtils.move(src, dest, MoveOverwriteAllowedByDefault);
    }
}

