/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.httpserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import jd.controlling.JDLogger;
import jd.nutils.httpserver.Handler;
import jd.nutils.httpserver.RequestHandler;

public class HttpServer
extends Thread {
    private ServerSocket ssocket;
    private Socket csocket;
    private Handler handler;
    private boolean running = true;
    private Thread run;
    private int port;

    public HttpServer(int port, Handler handler) throws IOException {
        this.handler = handler;
        this.port = port;
    }

    public void sstop() throws IOException {
        this.running = false;
        this.run = null;
    }

    public void start() {
        this.running = true;
        try {
            this.ssocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            JDLogger.exception(e);
        }
        this.run = new Thread(this);
        this.run.start();
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.run == thisThread && this.running) {
            if (this.ssocket == null) {
                return;
            }
            try {
                this.csocket = this.ssocket.accept();
                new RequestHandler(this.csocket, this.handler).run();
            }
            catch (Exception e) {
                JDLogger.exception(e);
            }
        }
        try {
            this.ssocket.close();
        }
        catch (IOException e) {
            JDLogger.exception(e);
        }
    }

    public boolean isStarted() {
        return this.running;
    }
}

