/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import jd.config.SubConfiguration;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.update.FileUpdate;
import jd.update.JDUpdateUtils;
import jd.update.Restarter;
import jd.update.Server;
import jd.update.WebUpdater;
import jd.utils.JDUtilities;

public class Main {
    private static int BOTHRESIZE = 1;
    private static Insets INSETS = new Insets(5, 5, 5, 5);
    private static int NORESIZE = 0;
    private static int NORTHWEST = 18;
    private static int REL = -1;
    private static int REM = 0;
    private static SubConfiguration guiConfig;
    private static StringBuilder log;
    private static JFrame frame;
    private static JTextArea logWindow;
    public static ArrayList<Server> clonePrefix;
    public static boolean clone;
    private static JProgressBar progressload;
    private static JTextPane warnings;
    private static int TICKET_TIME;

    static {
        clonePrefix = new ArrayList();
        clone = false;
        TICKET_TIME = -1;
    }

    private static void log(StringBuilder log, String string) {
        if (log != null) {
            log.append(string);
        }
        System.out.println(string);
    }

    public static void main(String[] args) {
        try {
            ArrayList<FileUpdate> files;
            log = new StringBuilder();
            boolean OSFilter = true;
            File cfg = JDUtilities.getResourceFile("jdownloader.config");
            if (cfg.exists()) {
                JDUtilities.getResourceFile("backup/").mkdirs();
                cfg.renameTo(JDUtilities.getResourceFile("backup/jdownloader.config.outdated"));
            }
            int i = 0;
            while (i < args.length) {
                String p = args[i];
                if (p.trim().equalsIgnoreCase("-noosfilter")) {
                    OSFilter = false;
                } else if (p.trim().equalsIgnoreCase("-full")) {
                    OSFilter = false;
                } else if (p.trim().equalsIgnoreCase("-brdebug")) {
                    Browser.setVerbose(true);
                } else if (p.trim().equalsIgnoreCase("-branch")) {
                    String br;
                    if ((br = args[++i]).equalsIgnoreCase("reset")) {
                        br = null;
                    }
                    WebUpdater.getConfig("WEBUPDATE").setProperty("BRANCH", br);
                    WebUpdater.getConfig("WEBUPDATE").save();
                    System.out.println("Switched branch: " + br);
                } else if (p.trim().equalsIgnoreCase("-clone")) {
                    OSFilter = false;
                    clone = true;
                } else if (clone && clonePrefix.size() == 0) {
                    clonePrefix.add(new Server(100, p.trim()));
                }
                ++i;
            }
            Browser.init();
            guiConfig = WebUpdater.getConfig("WEBUPDATE");
            log.append("Update JDownloader  at " + JDUtilities.getResourceFile(".") + "\r\n");
            log.append(WebUpdater.getConfig("WEBUPDATE").getProperties() + "\r\n");
            System.out.println(WebUpdater.getConfig("WEBUPDATE").getProperties() + "\r\n");
            System.out.println(WebUpdater.getConfig("PACKAGEMANAGER").getProperties() + "\r\n");
            log.append(WebUpdater.getConfig("PACKAGEMANAGER").getProperties() + "\r\n");
            if (!clone) {
                Main.initGUI();
            }
            try {
                Browser br = new Browser();
                TICKET_TIME = Integer.parseInt(br.getPage("http://update0.jdownloader.org/tickettime.txt").trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TICKET_TIME < 0) {
                warnings.setText("There are currently no free update slots. Please try again later!\r\n\r\nYou can close this Programm now.\r\nWe advise you to download the latest version from http://jdownloader.org/download!");
                if (JOptionPane.showConfirmDialog(frame, "There are currently no free update slots. Please try again later!\r\n Start JDownloader now?") != 0) {
                    while (true) {
                        Thread.sleep(10000000L);
                    }
                }
            } else {
                warnings.setText("\r\n\r\n\r\n");
                while (TICKET_TIME > 0) {
                    Thread.sleep(1000L);
                    warnings.setText("Update starts in " + Formatter.formatSeconds(TICKET_TIME / 1000) + ".\r\n\r\n\r\nIf you do not want to wait, we suggest you to download the latest version from http://jdownloader.org/download!");
                    TICKET_TIME -= 1000;
                }
                warnings.setText("Update is too slow and takes too much time?\r\n\r\n\r\nDownload latest Version no at http://jdownloader.org/download");
            }
            i = 0;
            while (i < args.length) {
                Main.log(log, "Parameter " + i + " " + args[i] + " " + System.getProperty("line.separator"));
                if (!clone) {
                    logWindow.setText(log.toString());
                }
                ++i;
            }
            final WebUpdater updater = new WebUpdater();
            updater.setOSFilter(OSFilter);
            updater.getBroadcaster().addListener(new MessageListener(){
                private String msg0 = "";
                private String msg1 = "";
                private String msg2 = "";

                public void onMessage(MessageEvent event) {
                    if (updater.getErrors() > 0) {
                        JOptionPane.showConfirmDialog(frame, "Update Server are too busy.\r\n Please try again later or download update at http://jdownloader.org/download!", "UPDATE WARNINGS", 0, 2);
                        Main.log(log, "Abort due to errors ");
                        Main.log(log, "Local: " + new File("").getAbsolutePath());
                        Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
                        JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                        logWindow.setText(log.toString());
                        JDIO.writeLocalFile(JDUtilities.getResourceFile("updateLog.txt"), log.toString());
                        System.exit(0);
                        return;
                    }
                    if (event.getID() == 40 || event.getID() == 2) {
                        this.msg2 = this.msg1;
                        this.msg1 = this.msg0;
                        this.msg0 = event.getMessage();
                        warnings.setText(String.valueOf(this.msg2) + "\r\n" + this.msg1 + "\r\n" + this.msg0 + "\r\n               Download latest Version no at http://jdownloader.org/download");
                    }
                    if (event.getID() == 43) {
                        warnings.setText("Update is too slow and takes too much time?\r\n\r\n\r\nDownload latest Version at http://jdownloader.org/download");
                    }
                    Main.log(log, String.valueOf(event.getMessage()) + "\r\n");
                }
            });
            Main.log(log, "Current Date:" + new Date() + "\r\n");
            if (!clone) {
                Main.checkBackup();
            }
            updater.ignorePlugins(false);
            if (!clone) {
                Main.checkUpdateMessage();
            }
            updater.setLogger(log);
            updater.setDownloadProgress(progressload);
            Main.trace("Start Webupdate");
            try {
                files = updater.getAvailableFiles();
            }
            catch (Exception e) {
                Main.trace("Update failed");
                Main.log(log, "Update failed");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                files = new ArrayList();
            }
            if (files != null) {
                updater.filterAvailableUpdates(files);
                JDUpdateUtils.backupDataBase();
                updater.updateFiles(files, null);
            }
            Restarter.main(new String[0]);
            Main.trace(updater.getLogger().toString());
            Main.trace("End Webupdate");
            if (!clone) {
                logWindow.setText(log.toString());
            }
            Main.trace(JDUtilities.getResourceFile("updateLog.txt").getAbsoluteFile());
            if (JDUtilities.getResourceFile("webcheck.tmp").exists()) {
                JDUtilities.getResourceFile("webcheck.tmp").delete();
            }
            Main.log(log, "Local: " + JDUtilities.getResourceFile(".").getAbsolutePath());
            Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
            JDUtilities.getDatabaseConnector().shutdownDatabase();
            if (!clone) {
                JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
            }
            if (!clone) {
                logWindow.setText(log.toString());
            }
            JDIO.writeLocalFile(JDUtilities.getResourceFile("updateLog.txt"), log.toString());
            Main.log(log, "Errors: " + updater.getErrors());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.log(log, "ERROR " + e.getLocalizedMessage());
        }
    }

    private static void checkUpdateMessage() throws IOException {
        try {
            if (JDUtilities.getResourceFile("updateLog.txt").exists()) {
                String str;
                String warnHash = JDHash.getMD5(JDUtilities.getResourceFile("updatewarnings.html"));
                Browser.download(JDUtilities.getResourceFile("updatewarnings.html"), "http://update1.jdownloader.org/messages/updatewarning.html");
                String hash2 = JDHash.getMD5(JDUtilities.getResourceFile("updatewarnings.html"));
                if (hash2 != null && !hash2.equals(warnHash) && (str = JDIO.getLocalFile(new File("updatewarnings.html"))).trim().length() > 0 && JOptionPane.showConfirmDialog(frame, str, "UPDATE WARNINGS", 0, 2) == 1) {
                    Main.log(log, "Abort due to warnings " + str);
                    JDUtilities.getResourceFile("updatewarnings.html").delete();
                    JDUtilities.getResourceFile("updatewarnings.html").deleteOnExit();
                    if (JDUtilities.getResourceFile("webcheck.tmp").exists()) {
                        JDUtilities.getResourceFile("webcheck.tmp").delete();
                    }
                    Main.log(log, "Local: " + new File("").getAbsolutePath());
                    Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
                    JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                    logWindow.setText(log.toString());
                    JDIO.writeLocalFile(JDUtilities.getResourceFile("updateLog.txt"), log.toString());
                    System.exit(0);
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkBackup() {
        if (JDUtilities.getResourceFile("updateLog.txt").exists()) {
            if (!JDUtilities.getResourceFile("/backup/").exists()) {
                JDUtilities.getResourceFile("/backup/").mkdirs();
                Main.log(log, "Not found: " + JDUtilities.getResourceFile("/backup/").getAbsolutePath() + "\r\n");
                UserIO.getInstance().requestMessageDialog("JDownloader could not create a backup. Please make sure that\r\n " + JDUtilities.getResourceFile("/backup/").getAbsolutePath() + " exists and is writable before starting the update");
                JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                System.exit(0);
                return;
            }
            File lastBackup = JDUtilities.getResourceFile("/backup/links.linkbackup");
            Main.log(log, "Backup found. date:" + new Date(lastBackup.lastModified()) + "\r\n");
            if (!lastBackup.exists() || System.currentTimeMillis() - lastBackup.lastModified() > 300000L) {
                JDUtilities.getResourceFile("/backup/").mkdirs();
                String msg = "";
                msg = !lastBackup.exists() ? "Do you want to continue without a backup? Your queue may get lost.\r\nLatest backup found: NONE!\r\nNote: You can ignore this message if this is a fresh JD-Installation and your linklist is empty anyway" : "Do you want to continue without a backup? Your queue may get lost.\r\nLatest backup found: " + new Date(lastBackup.lastModified()) + "\r\nin " + lastBackup.getAbsolutePath();
                if (JOptionPane.showConfirmDialog(frame, msg, "There is no backup of your current Downloadqueue", 2) != 0) {
                    JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                    System.exit(0);
                    return;
                }
            }
        }
    }

    private static void initGUI() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String paf = guiConfig.getStringProperty("PLAF", null);
        boolean plafisSet = false;
        if (paf != null) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = info;
            int n = info.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo element = lookAndFeelInfoArray[n2];
                if (element.getName().equals(paf)) {
                    try {
                        UIManager.setLookAndFeel(element.getClassName());
                        plafisSet = true;
                        break;
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        } else {
            int i = 0;
            while (i < info.length) {
                if (!info[i].getName().matches("(?is).*(metal|motif).*")) {
                    try {
                        UIManager.setLookAndFeel(info[i].getClassName());
                        plafisSet = true;
                        break;
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (!plafisSet) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException i) {
                // empty catch block
            }
        }
        frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("JD Update");
        frame.setLayout(new GridBagLayout());
        progressload = new JProgressBar();
        progressload.setMaximum(100);
        progressload.setStringPainted(true);
        warnings = new JTextPane();
        warnings.setForeground(Color.RED);
        warnings.setText("Please wait.. check ticket");
        warnings.setOpaque(false);
        warnings.setBackground(null);
        warnings.setEditable(false);
        warnings.setPreferredSize(new Dimension(500, 80));
        warnings.setMinimumSize(new Dimension(50, 80));
        warnings.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        logWindow = new JTextArea(30, 120);
        JScrollPane scrollPane = new JScrollPane(logWindow);
        scrollPane.setAutoscrolls(true);
        logWindow.setEditable(false);
        logWindow.setAutoscrolls(true);
        JDUtilities.addToGridBag(frame, warnings, REL, REL, REM, 1, 0, 0, INSETS, BOTHRESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, new JLabel("Webupdate is running..."), REL, REL, REM, 1, 0, 0, INSETS, NORESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, new JLabel("Download: "), REL, REL, REL, 1, 0, 0, INSETS, NORESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, progressload, REL, REL, REM, 1, 1, 0, INSETS, BOTHRESIZE, NORTHWEST);
        Main.log(log, "Starting...");
        logWindow.setText(log.toString());
        JDUtilities.addToGridBag(frame, scrollPane, REL, REL, REM, 1, 1, 1, INSETS, BOTHRESIZE, NORTHWEST);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int n = 5;
        ((JComponent)frame.getContentPane()).setBorder(new EmptyBorder(n, n, n, n));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        new Thread(){

            public void run() {
                while (true) {
                    logWindow.setText(log.toString());
                    logWindow.setCaretPosition(logWindow.getText().length());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    public static void trace(Object arg) {
        try {
            System.out.println(arg.toString());
        }
        catch (Exception e) {
            System.out.println(arg);
        }
    }
}

