/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import jd.controlling.JDLogger;

public class BinCode {
    private static String addZero(String bin, int minCount) {
        int j = bin.length();
        while (j < minCount) {
            bin = "0" + bin;
            ++j;
        }
        return bin;
    }

    private static String[] binArrayToCodeArray(String[] binArray) {
        String[] codeArray = new String[binArray.length];
        int i = 0;
        while (i < binArray.length) {
            codeArray[i] = BinCode.prBinToCode(binArray[i]);
            ++i;
        }
        return codeArray;
    }

    public static String binToCode(String bin) {
        try {
            String[] sts = bin.split("\\|");
            String[] codeArray = BinCode.binArrayToCodeArray(sts);
            int minCount = sts[0].length();
            StringBuilder ret = new StringBuilder();
            ret.append(minCount);
            int i = 0;
            while (i < sts.length) {
                ret.append("|" + codeArray[i]);
                ++i;
            }
            return ret.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] codeArrayToBinArray(String[] codeArray) {
        String[] binArray = new String[codeArray.length - 1];
        int minCount = Integer.parseInt(codeArray[0]);
        int i = 1;
        while (i < codeArray.length) {
            binArray[i - 1] = BinCode.addZero(BinCode.prCodeToBin(codeArray[i]), minCount);
            ++i;
        }
        return binArray;
    }

    public static String codeToString(String code) {
        try {
            String[] binArray = BinCode.codeToStringArray(code);
            StringBuilder ret = new StringBuilder();
            boolean last = false;
            String[] stringArray = binArray;
            int n = binArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                ret.append(String.valueOf(last ? "|" : "") + element);
                last = true;
                ++n2;
            }
            return ret.toString();
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String[] codeToStringArray(String code) {
        return BinCode.codeArrayToBinArray(code.split("\\|"));
    }

    private static String prBinToCode(String bin) {
        return Integer.toString(Integer.parseInt(bin, 2), 36);
    }

    private static String prCodeToBin(String Code) {
        return Integer.toBinaryString(Integer.parseInt(Code, 36));
    }
}

