/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

public class EditDistance {
    public static int getLevenshteinDifference(String s, String t) {
        if (s == null) {
            if (t == null) {
                return 0;
            }
            return t.length();
        }
        if (t == null) {
            return s.length();
        }
        if (s.equals(t)) {
            return 0;
        }
        return 100 * EditDistance.getLevenshteinDistance(s, t) / Math.max(s.length(), t.length());
    }

    public static int getLevenshteinDistance(String s, String t) {
        if (s == null) {
            if (t == null) {
                return 0;
            }
            return t.length();
        }
        if (t == null) {
            return s.length();
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n1 = n + 1;
        int[] p = new int[n1];
        int[] d = new int[n1];
        int i = 0;
        while (i <= n) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= m) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            i = 1;
            while (i <= n) {
                int i1 = i - 1;
                d[i] = Math.min(Math.min(d[i1] + 1, p[i] + 1), p[i1] + (s.charAt(i1) == t_j ? 0 : 1));
                ++i;
            }
            int[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return p[n];
    }

    public static int damerauLevenshteinDistance(String src, String dest) {
        int[][] d = new int[src.length() + 1][dest.length() + 1];
        char[] str1 = src.toCharArray();
        char[] str2 = dest.toCharArray();
        int i = 0;
        while (i <= str1.length) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= str2.length) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= str1.length) {
            j = 1;
            while (j <= str2.length) {
                int cost = str1[i - 1] == str2[j - 1] ? 0 : 1;
                d[i][j] = Math.min(d[i - 1][j] + 1, Math.min(d[i][j - 1] + 1, d[i - 1][j - 1] + cost));
                if (i > 1 && j > 1 && str1[i - 1] == str2[j - 2] && str1[i - 2] == str2[j - 1]) {
                    d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
                    System.out.println("d:" + d[i - 2][j - 2]);
                }
                ++j;
            }
            ++i;
        }
        return d[str1.length][str2.length];
    }
}

