/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import de.savemytube.flv.FLV;
import java.io.File;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.gui.swing.components.ConvertDialog;
import jd.plugins.DownloadLink;
import jd.utils.locale.JDL;

public class JDMediaConvert {
    private static Logger logger = JDLogger.getLogger();
    private static String TempExt = ".tmp$";

    public static boolean ConvertFile(DownloadLink downloadlink, ConvertDialog.ConversionMode InType, ConvertDialog.ConversionMode OutType) {
        logger.info("Convert " + downloadlink.getName() + " - " + InType.GetText() + " - " + OutType.GetText());
        if (InType.equals((Object)OutType)) {
            logger.info("No Conversion needed, renaming...");
            File oldone = new File(downloadlink.getFileOutput());
            File newone = new File(downloadlink.getFileOutput().replaceAll(TempExt, OutType.GetExtFirst()));
            oldone.renameTo(newone);
            return true;
        }
        ProgressController progress = new ProgressController(String.valueOf(JDL.L((String)"convert.progress.convertingto", (String)"Konvertiere zu")) + " " + OutType.toString(), 3L);
        downloadlink.getLinkStatus().setStatusText(String.valueOf(JDL.L((String)"convert.progress.convertingto", (String)"Konvertiere zu")) + " " + OutType.toString());
        progress.increase(1L);
        switch (InType) {
            case VIDEOFLV: {
                switch (OutType) {
                    case AUDIOMP3: {
                        logger.info("Convert FLV to mp3...");
                        new FLV(downloadlink.getFileOutput(), true, true);
                        progress.increase(1L);
                        if (!new File(downloadlink.getFileOutput()).delete()) {
                            new File(downloadlink.getFileOutput()).deleteOnExit();
                        }
                        if (!new File(downloadlink.getFileOutput().replaceAll(TempExt, ".avi")).delete()) {
                            new File(downloadlink.getFileOutput().replaceAll(TempExt, ".avi")).deleteOnExit();
                        }
                        progress.doFinalize();
                        return true;
                    }
                    case AUDIOMP3_AND_VIDEOFLV: {
                        logger.info("Convert FLV to mp3 (keep FLV)...");
                        new FLV(downloadlink.getFileOutput(), true, true);
                        progress.increase(1L);
                        if (!new File(downloadlink.getFileOutput().replaceAll(TempExt, ".avi")).delete()) {
                            new File(downloadlink.getFileOutput().replaceAll(TempExt, ".avi")).deleteOnExit();
                        }
                        new File(downloadlink.getFileOutput()).renameTo(new File(downloadlink.getFileOutput().replaceAll(".tmp", ConvertDialog.ConversionMode.VIDEOFLV.GetExtFirst())));
                        progress.doFinalize();
                        return true;
                    }
                }
                logger.warning("Don't know how to convert " + InType.GetText() + " to " + OutType.GetText());
                downloadlink.getLinkStatus().setErrorMessage(JDL.L((String)"convert.progress.unknownintype", (String)"Unbekanntes Format"));
                progress.doFinalize();
                return false;
            }
        }
        logger.warning("Don't know how to convert " + InType.GetText() + " to " + OutType.GetText());
        downloadlink.getLinkStatus().setErrorMessage(JDL.L((String)"convert.progress.unknownintype", (String)"Unbekanntes Format"));
        progress.doFinalize();
        return false;
    }
}

