/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.controlling.JDLogger;
import jd.nutils.JDImage;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDFileFilter;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTheme {
    private static HashMap<String, String> data = new HashMap();
    private static HashMap<String, String> defaultData;
    private static Logger logger;
    public static String THEME_DIR;
    private static String currentTheme;

    static {
        logger = JDLogger.getLogger();
        THEME_DIR = "jd/themes/";
    }

    public static ArrayList<String> getThemeIDs() {
        File dir = JDUtilities.getResourceFile(THEME_DIR);
        if (!dir.exists()) {
            return null;
        }
        File[] files = dir.listFiles(new JDFileFilter(null, ".icl", false));
        ArrayList<String> ret = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            ret.add(element.getName().split("\\.")[0]);
            ++n2;
        }
        return ret;
    }

    public static String getThemeValue(String key, String def) {
        if (data == null || defaultData == null) {
            logger.severe("Use setTheme() first!");
            JDTheme.setTheme("default");
        }
        if (data.containsKey(key)) {
            return Encoding.UTF8Decode(data.get(key));
        }
        logger.warning("Key not found: " + key + " (" + def + ")");
        if (defaultData.containsKey(key)) {
            def = Encoding.UTF8Decode(defaultData.get(key));
            logger.finest("Use default Value: " + def);
        }
        if (def == null) {
            def = key;
        }
        data.put(key, def);
        return def;
    }

    public static Color C(String key, String def) {
        return new Color(Integer.parseInt(JDTheme.V(key, def), 16));
    }

    public static Color C(String key, String def, int alpha) {
        String hex = JDTheme.V(key, def);
        return new Color(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4), 16), alpha);
    }

    public static Image I(String key) {
        return JDImage.getImage(JDTheme.V(key));
    }

    public static Image I(String key, int width, int height) {
        return JDImage.getImage(JDTheme.V(key)).getScaledInstance(width, height, 4);
    }

    public static ImageIcon II(String key) {
        return JDTheme.II(key, 32, 32);
    }

    public static ImageIcon II(String key, int width, int height) {
        try {
            return new ImageIcon(JDTheme.getImage(JDTheme.V(key), width, height));
        }
        catch (Exception e) {
            logger.severe("image not found: " + key + "(" + JDTheme.V(key) + "_" + width + "_" + height);
            JDLogger.exception(e);
            return null;
        }
    }

    public static Image getImage(String string, int width, int height) {
        BufferedImage img = JDImage.getImage(String.valueOf(string) + "_" + width + "_" + height);
        if (img != null) {
            return img;
        }
        try {
            return JDImage.getScaledImage(JDImage.getImage(string), width, height);
        }
        catch (Exception e) {
            logger.severe("Could not find image: " + string);
            return null;
        }
    }

    public static String getTheme() {
        if (currentTheme == null) {
            return "default";
        }
        return currentTheme;
    }

    public static void setTheme(String themeID) {
        String value;
        String key;
        int split;
        String element;
        String[] lines;
        File file = JDUtilities.getResourceFile(String.valueOf(THEME_DIR) + themeID + ".icl");
        if (!file.exists()) {
            logger.severe("Theme " + themeID + " not installed, switch to default theme");
            themeID = "default";
        }
        currentTheme = themeID;
        data = new HashMap();
        String str = JDIO.getLocalFile(file);
        String[] stringArray = lines = Regex.getLines(str);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            split = element.indexOf("=");
            if (split > 0 && !element.startsWith("#")) {
                key = element.substring(0, split).trim();
                value = element.substring(split + 1).trim();
                if (data.containsKey(key)) {
                    logger.severe("Dupe found: " + key);
                } else {
                    data.put(key, value);
                }
            }
            ++n2;
        }
        if (themeID.equals("default")) {
            defaultData = data;
        }
        if (defaultData == null) {
            defaultData = new HashMap();
            file = JDUtilities.getResourceFile(String.valueOf(THEME_DIR) + "default.icl");
            if (!file.exists()) {
                logger.severe("Theme default not installed");
                return;
            }
            data = new HashMap();
            str = JDIO.getLocalFile(file);
            stringArray = lines = Regex.getLines(str);
            n = lines.length;
            n2 = 0;
            while (n2 < n) {
                element = stringArray[n2];
                split = element.indexOf("=");
                if (split > 0 && !element.startsWith("#")) {
                    key = element.substring(0, split).trim();
                    value = element.substring(split + 1).trim();
                    if (data.containsKey(key)) {
                        logger.finer("Dupe found: " + key);
                    } else {
                        data.put(key, value);
                    }
                }
                ++n2;
            }
        }
    }

    public static String V(String key) {
        return JDTheme.getThemeValue(key, null);
    }

    public static String V(String key, String def) {
        return JDTheme.getThemeValue(key, def);
    }
}

