/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.nutils.DiffMatchPatch;
import jd.nutils.JDFlags;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import tests.utils.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceInFiles {
    public static void main(String[] args) {
        TestUtils.mainInit();
        TestUtils.initDecrypter();
        TestUtils.initContainer();
        TestUtils.initHosts();
        TestUtils.finishInit();
        new GuiRunnable<Object>(){

            public Object runSave() {
                File ret;
                JDFileChooser fc = new JDFileChooser();
                UserIO.setInstance((UserIO)UserIOGui.getInstance());
                fc.setFileSelectionMode(1);
                if (fc.showOpenDialog(null) == 0 && (ret = fc.getSelectedFile()) != null) {
                    String pat = UserIO.getInstance().requestInputDialog("Define filepattern");
                    String find = UserIO.getInstance().requestInputDialog("Find pattern");
                    String replace = UserIO.getInstance().requestInputDialog("Replace with pattern");
                    ReplaceInFiles.replaceInFiles(ReplaceInFiles.scanDir(ret, pat), find, replace);
                }
                return null;
            }
        }.waitForEDT();
    }

    private static void replaceInFiles(ArrayList<File> scanDir, String find, String replace) {
        long id = System.currentTimeMillis();
        boolean ok = false;
        for (File f : scanDir) {
            String l = JDIO.getLocalFile(f);
            String newL = Pattern.compile(find, 34).matcher(l).replaceAll(replace);
            DiffMatchPatch diff = new DiffMatchPatch();
            LinkedList<DiffMatchPatch.Diff> diffs = diff.diffMain(l, newL, true);
            String html = ReplaceInFiles.diffPrettyHtml(diffs);
            if (!ok) {
                int ret = UserIO.getInstance().requestConfirmDialog(224, "Diffs found in  " + id, html, null, null, null);
                if (JDFlags.hasSomeFlags(ret, 4)) {
                    return;
                }
                if (JDFlags.hasSomeFlags(ret, 8, 2)) {
                    ok = true;
                }
            }
            System.out.println(html);
            JDIO.writeLocalFile(f, newL);
        }
    }

    public static String diffPrettyHtml(LinkedList<DiffMatchPatch.Diff> diffs) {
        StringBuilder html = new StringBuilder();
        int i = 0;
        for (DiffMatchPatch.Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<span STYLE=\"color:#000000;background:#00FF00;border=1\" TITLE=\"i=").append(i).append("\">").append(text).append("</span>");
                    break;
                }
                case DELETE: {
                    html.append("<span STYLE=\"color:#000000;background:#FF0000;border=1\" TITLE=\"i=").append(i).append("\">").append(text).append("</span>");
                    break;
                }
                case EQUAL: {
                    String[] text2 = aDiff.text.split("[\r\n]{1,2}");
                    if (text2.length > 2) {
                        html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text2[0].replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>")).append("</SPAN>");
                        html.append("<br>[.....]<br>");
                        html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text2[text2.length - 1].replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>")).append("</SPAN>");
                        break;
                    }
                    html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text).append("</SPAN>");
                }
            }
            if (aDiff.operation == DiffMatchPatch.Operation.DELETE) continue;
            i += aDiff.text.length();
        }
        return html.toString();
    }

    private static ArrayList<File> scanDir(File dir, String pat) {
        ArrayList<File> ret = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                ret.addAll(ReplaceInFiles.scanDir(f, pat));
            } else if (!f.getAbsolutePath().contains(".svn") && new Regex(f.getAbsolutePath(), pat).matches()) {
                System.out.println("Find in file: " + f);
                ret.add(f);
            }
            ++n2;
        }
        return ret;
    }
}

