/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.ArrayList;
import java.util.Calendar;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.http.IPCheck;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class Replacer {
    private static ArrayList<String[]> KEYS = null;

    public static String[] getKeyList() {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        String[] keys = new String[KEYS.size()];
        int i = 0;
        while (i < KEYS.size()) {
            keys[i] = "%" + KEYS.get(i)[0] + "%" + "   (" + KEYS.get(i)[1] + ")";
            ++i;
        }
        return keys;
    }

    public static String getKey(int index) {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        if (index >= KEYS.size()) {
            return null;
        }
        return KEYS.get(index)[0];
    }

    private static void initKeys() {
        KEYS = new ArrayList();
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PASSWORD", JDL.L((String)"replacer.password", (String)"Last finished package: Password")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.FILELIST", JDL.L((String)"replacer.filelist", (String)"Last finished package: Filelist")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PACKAGENAME", JDL.L((String)"replacer.packagename", (String)"Last finished package: Packagename")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.COMMENT", JDL.L((String)"replacer.comment", (String)"Last finished package: Comment")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY", JDL.L((String)"replacer.downloaddirectory", (String)"Last finished package: Download Directory")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.DOWNLOAD_PATH", JDL.L((String)"replacer.filepath", (String)"Last finished File: Filepath")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.INFOSTRING", JDL.L((String)"replacer.informationstring", (String)"Last finished File: Plugin given informationstring")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.HOST", JDL.L((String)"replacer.hoster", (String)"Last finished File: Hoster")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.NAME", JDL.L((String)"replacer.filename", (String)"Last finished File: Filename")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.FILESIZE", JDL.L((String)"replacer.filesize", (String)"Last finished File: Filesize")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.AVAILABLE", JDL.L((String)"replacer.available", (String)"Last finished File: is Available (Yes,No)")});
        KEYS.add(new String[]{"SYSTEM.IP", JDL.L((String)"replacer.ipaddress", (String)"Current IP Address")});
        KEYS.add(new String[]{"SYSTEM.DATE", JDL.L((String)"replacer.date", (String)"Current Date")});
        KEYS.add(new String[]{"SYSTEM.TIME", JDL.L((String)"replacer.time", (String)"Current Time")});
        KEYS.add(new String[]{"SYSTEM.JAVA_VERSION", JDL.L((String)"replacer.javaversion", (String)"Used Java Version")});
        KEYS.add(new String[]{"JD.REVISION", JDL.L((String)"replacer.jdversion", (String)"jDownloader: Revision/Version")});
        KEYS.add(new String[]{"JD.HOME_DIR", JDL.L((String)"replacer.jdhomedirectory", (String)"jDownloader: Homedirectory/Installdirectory")});
    }

    public static String getReplacement(String key) {
        JDController controller = JDUtilities.getController();
        DownloadLink dLink = controller.getLastFinishedDownloadLink();
        if (key.equalsIgnoreCase("LAST_FINISHED_PACKAGE.PASSWORD")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getFilePackage().getPassword();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_PACKAGE.FILELIST")) {
            if (dLink == null) {
                return "";
            }
            ArrayList files = dLink.getFilePackage().getDownloadLinkList();
            return files.toString();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_PACKAGE.PACKAGENAME")) {
            if (dLink == null) {
                return "";
            }
            if (dLink.getFilePackage().getName() == null || dLink.getFilePackage().getName().length() == 0) {
                return dLink.getName();
            }
            return dLink.getFilePackage().getName();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_PACKAGE.COMMENT")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getFilePackage().getComment();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getFilePackage().getDownloadDirectory();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.DOWNLOAD_PATH")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getFileOutput();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.INFOSTRING")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getFileInfomationString();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.HOST")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getHost();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.NAME")) {
            if (dLink == null) {
                return "";
            }
            return dLink.getName();
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.FILESIZE")) {
            if (dLink == null) {
                return "";
            }
            return String.valueOf(dLink.getDownloadSize());
        }
        if (key.equalsIgnoreCase("LAST_FINISHED_FILE.AVAILABLE")) {
            if (dLink == null) {
                return "";
            }
            return dLink.isAvailable() ? "YES" : "NO";
        }
        if (key.equalsIgnoreCase("SYSTEM.IP")) {
            return IPCheck.getIPAddress(null);
        }
        if (key.equalsIgnoreCase("SYSTEM.DATE")) {
            Calendar c = Calendar.getInstance();
            return String.valueOf(Formatter.fillInteger(c.get(5), 2, "0")) + "." + Formatter.fillInteger(c.get(2) + 1, 2, "0") + "." + c.get(1);
        }
        if (key.equalsIgnoreCase("SYSTEM.TIME")) {
            Calendar c = Calendar.getInstance();
            return String.valueOf(Formatter.fillInteger(c.get(11), 2, "0")) + ":" + Formatter.fillInteger(c.get(12), 2, "0") + ":" + Formatter.fillInteger(c.get(13), 2, "0");
        }
        if (key.equalsIgnoreCase("JD.REVISION")) {
            return JDUtilities.getRevision();
        }
        if (key.equalsIgnoreCase("SYSTEM.JAVA_VERSION")) {
            return JDUtilities.getJavaVersion().toString();
        }
        if (key.equalsIgnoreCase("JD.HOME_DIR")) {
            return JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath();
        }
        return "";
    }

    public static String insertVariables(String str) {
        if (str == null) {
            return "";
        }
        if (KEYS == null) {
            Replacer.initKeys();
        }
        for (String[] element : KEYS) {
            if (str.indexOf("%" + element[0] + "%") < 0) continue;
            JDLogger.getLogger().finer("%" + element[0] + "%" + " --> *****");
            str = Replacer.replace(str, "%" + element[0] + "%", Replacer.getReplacement(element[0]));
        }
        return str;
    }

    private static String replace(String in, String remove, String replace) {
        if (in == null || remove == null || remove.length() == 0) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        int oldIndex = 0;
        int newIndex = 0;
        int remLength = remove.length();
        while ((newIndex = in.indexOf(remove, oldIndex)) > -1) {
            sb.append(in.substring(oldIndex, newIndex));
            sb.append(replace);
            oldIndex = newIndex + remLength;
        }
        int inLength = in.length();
        if (oldIndex < inLength) {
            sb.append(in.substring(oldIndex, inLength));
        }
        return sb.toString();
    }
}

