/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Color;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.DecryptPluginWrapper;
import jd.HostPluginWrapper;
import jd.PluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.gui.UserIO;
import jd.gui.swing.components.Balloon;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDFlags;
import jd.nutils.JDHash;
import jd.parser.Regex;
import jd.update.FileUpdate;
import jd.update.JDUpdateUtils;
import jd.update.WebUpdater;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUpdate {
    private static Logger logger = JDLogger.getLogger();
    private static boolean DYNAMIC_PLUGINS_FINISHED = false;
    private static boolean UPDATE_IN_PROGRESS = false;

    public static void DynamicPluginsFinished() {
        DYNAMIC_PLUGINS_FINISHED = true;
    }

    private static String getUpdaterMD5(int trycount) {
        return String.valueOf(WebUpdater.UPDATE_MIRROR[trycount % WebUpdater.UPDATE_MIRROR.length]) + "jdupdate.jar.md5";
    }

    private static String getUpdater(int trycount) {
        return String.valueOf(WebUpdater.UPDATE_MIRROR[trycount % WebUpdater.UPDATE_MIRROR.length]) + "jdupdate.jar";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateUpdater() {
        final ProgressController progress = new ProgressController(JDL.L((String)"wrapper.webupdate.updatenewupdater", (String)"Downloading new jdupdate.jar"));
        progress.increase(1L);
        Thread ttmp = new Thread(){

            public void run() {
                while (true) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (progress.getValue() > 95L) {
                        progress.setStatus(10L);
                    }
                    progress.increase(1L);
                }
            }
        };
        WebUpdater.randomizeMirrors();
        ttmp.start();
        Browser br = new Browser();
        br.setReadTimeout(20000);
        br.setConnectTimeout(10000);
        File file = JDUtilities.getResourceFile("jdupdate.jar");
        String localHash = JDHash.getMD5(file);
        String remoteHash = null;
        int trycount = 0;
        while (trycount < 10) {
            block14: {
                if (remoteHash == null) {
                    try {
                        remoteHash = br.getPage(String.valueOf(WebUpdate.getUpdaterMD5(trycount)) + "?t=" + System.currentTimeMillis()).trim();
                    }
                    catch (Exception e) {
                        remoteHash = null;
                        WebUpdate.errorWait();
                        break block14;
                    }
                }
                if (localHash != null && remoteHash != null && remoteHash.equalsIgnoreCase(localHash)) {
                    ttmp.interrupt();
                    progress.doFinalize();
                    logger.info("Updater is still up2date!");
                    return true;
                }
                if (localHash == null || !remoteHash.equalsIgnoreCase(localHash)) {
                    logger.info("Download " + file.getAbsolutePath());
                    URLConnectionAdapter con = null;
                    try {
                        con = br.openGetConnection(String.valueOf(WebUpdate.getUpdater(trycount)) + "?t=" + System.currentTimeMillis());
                        if (con.isOK()) {
                            File tmp = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
                            Browser.download(tmp, con);
                            localHash = JDHash.getMD5(tmp);
                            if (remoteHash.equalsIgnoreCase(localHash)) {
                                if ((!file.exists() || file.delete()) && tmp.renameTo(file)) {
                                    ttmp.interrupt();
                                    progress.doFinalize(2000L);
                                    logger.info("Update of " + file.getAbsolutePath() + " successfull");
                                    return true;
                                }
                                ttmp.interrupt();
                                logger.severe("Rename error: jdupdate.jar");
                                progress.setColor(Color.RED);
                                progress.setStatusText(JDL.LF((String)"wrapper.webupdate.updateUpdater.error_rename", (String)"Could not rename jdupdate.jar.tmp to jdupdate.jar", (Object[])new Object[0]));
                                progress.doFinalize(5000L);
                                return false;
                            }
                            logger.severe("CRC Error while downloading jdupdate.jar");
                        } else {
                            con.disconnect();
                        }
                    }
                    catch (Exception e) {
                        try {
                            con.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    new File(String.valueOf(file.getAbsolutePath()) + ".tmp").delete();
                }
            }
            ++trycount;
        }
        ttmp.interrupt();
        progress.setColor(Color.RED);
        progress.setStatusText(JDL.LF((String)"wrapper.webupdate.updateUpdater.error_reqeust2", (String)"Could not download new jdupdate.jar", (Object[])new Object[0]));
        progress.doFinalize(5000L);
        logger.info("Update of " + file.getAbsolutePath() + " failed");
        return false;
    }

    private static void errorWait() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void doUpdateCheck(final boolean guiCall, final boolean forceguiCall) {
        ArrayList<FileUpdate> files;
        if (UPDATE_IN_PROGRESS) {
            logger.info("UPdate is already running");
            Balloon.show((String)JDL.L((String)"jd.utils.webupdate.ballon.title", (String)"Update"), (ImageIcon)UserIO.getInstance().getIcon(1), (String)JDL.L((String)"jd.utils.webupdate.ballon.message.updateinprogress", (String)"There is already an update in progress."));
            return;
        }
        UPDATE_IN_PROGRESS = true;
        final String id = JDController.requestDelayExit("doUpdateCheck");
        final ProgressController progress = new ProgressController(JDL.L((String)"init.webupdate.progress.0_title", (String)"Webupdate"), 100L);
        final WebUpdater updater = new WebUpdater();
        updater.ignorePlugins(false);
        logger.finer("Checking for available updates");
        try {
            files = updater.getAvailableFiles();
            if (updater.sum.length > 100) {
                SubConfiguration.getConfig("apckage").setProperty(new String(new byte[]{97, 112, 99, 107, 97, 103, 101}), updater.sum);
            }
        }
        catch (Exception e) {
            progress.setColor(Color.RED);
            progress.setStatusText("Update failed");
            progress.doFinalize(15000L);
            UPDATE_IN_PROGRESS = false;
            JDController.releaseDelayExit(id);
            return;
        }
        boolean pluginRestartRequired = false;
        progress.setRange(WebUpdater.getPluginList().size());
        if (!SubConfiguration.getConfig("WEBUPDATE").getBooleanProperty("WEBUPDATE_DISABLE", false).booleanValue()) {
            progress.setStatusText(JDL.L((String)"jd.utils.webupdate.progress.autopluginupdate", (String)"Update plugins"));
            Iterator<Map.Entry<String, FileUpdate>> it = WebUpdater.getPluginList().entrySet().iterator();
            while (it.hasNext()) {
                String clazz;
                FileUpdate f = it.next().getValue();
                if (!f.equals() && (clazz = new Regex((Object)f.getLocalFile().getAbsoluteFile(), "(jd[/\\\\].*?)\\.class").getMatch(0)) != null) {
                    clazz = clazz.replaceAll("[/\\\\]", ".");
                    PluginWrapper wrapper = f.getLocalFile().getAbsolutePath().contains(".decrypt") ? DecryptPluginWrapper.getWrapper((String)clazz) : HostPluginWrapper.getWrapper((String)clazz);
                    if (wrapper != null && wrapper.isLoaded()) {
                        pluginRestartRequired = true;
                        logger.warning("RESTART REQUIRED. PLUGIN UPDATED: " + f.getLocalPath());
                    }
                }
                progress.increase(1L);
            }
        }
        final boolean doPluginRestart = pluginRestartRequired;
        new Thread(){

            public void run() {
                MessageListener messageListener = null;
                if (files != null) {
                    updater.filterAvailableUpdates(files);
                    JDUtilities.getController().setWaitingUpdates(files);
                    messageListener = new MessageListener(){

                        public void onMessage(MessageEvent event) {
                            progress.setStatusText(event.getSource() + ": " + event.getMessage());
                        }
                    };
                    updater.getBroadcaster().addListener(messageListener);
                }
                if (!guiCall) {
                    progress.doFinalize();
                    JDController.releaseDelayExit(id);
                    if (doPluginRestart) {
                        JDUtilities.restartJDandWait();
                    }
                    UPDATE_IN_PROGRESS = false;
                    return;
                }
                if (!forceguiCall && SubConfiguration.getConfig("WEBUPDATE").getBooleanProperty("WEBUPDATE_DISABLE", false).booleanValue()) {
                    logger.severe("Webupdater disabled");
                    progress.doFinalize();
                    JDController.releaseDelayExit(id);
                    if (doPluginRestart) {
                        JDUtilities.restartJDandWait();
                    }
                    UPDATE_IN_PROGRESS = false;
                    return;
                }
                if (files.size() == 0) {
                    int ret;
                    logger.severe("Webupdater offline or nothing to update");
                    File[] updates = JDUtilities.getResourceFile("update").listFiles();
                    if (updates != null && updates.length > 0 && JDFlags.hasAllFlags(ret = UserIO.getInstance().requestConfirmDialog(544, JDL.L((String)"jd.update.Main.error.title.old", (String)"Updates found!"), JDL.L((String)"jd.update.Main.error.message.old", (String)"There are uninstalled updates. Install them now?"), null, null, null), 2)) {
                        JDController.releaseDelayExit(id);
                        JDUtilities.restartJDandWait();
                        return;
                    }
                    progress.doFinalize();
                    JDController.releaseDelayExit(id);
                    if (doPluginRestart) {
                        JDUtilities.restartJDandWait();
                    }
                    UPDATE_IN_PROGRESS = false;
                    return;
                }
                int org = files.size();
                progress.setRange(org);
                progress.setStatusText(JDL.L((String)"init.webupdate.progress.1_title", (String)"Update Check"));
                if (files.size() > 0) {
                    progress.setStatus(org - files.size());
                    logger.finer("Files to update: " + files);
                    if (JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) {
                        UserIO.setCountdownTime((int)5);
                        int answer = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"init.webupdate.auto.countdowndialog2", (String)"Automatic update."), JDL.LF((String)"jd.utils.webupdate.message", (String)"<font size=\"2\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s update(s) available. Install now?</font>", (Object[])new Object[]{files.size()}), JDTheme.II("gui.splash.update", 32, 32), null, null);
                        UserIO.setCountdownTime((int)-1);
                        if (JDFlags.hasSomeFlags(answer, 2, 32)) {
                            WebUpdate.doUpdate(updater, files, doPluginRestart);
                        } else {
                            UPDATE_IN_PROGRESS = false;
                        }
                    } else {
                        try {
                            int answer = UserIO.getInstance().requestConfirmDialog(128, JDL.L((String)"system.dialogs.update", (String)"Updates available"), JDL.LF((String)"jd.utils.webupdate.message2", (String)"<font size=\"4\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s update(s) available. Install now?</font>", (Object[])new Object[]{files.size()}), JDTheme.II("gui.splash.update", 32, 32), null, null);
                            if (JDFlags.hasAllFlags(answer, 2)) {
                                WebUpdate.doUpdate(updater, files, doPluginRestart);
                            } else {
                                UPDATE_IN_PROGRESS = false;
                            }
                        }
                        catch (HeadlessException e) {
                            JDLogger.exception(e);
                            UPDATE_IN_PROGRESS = false;
                        }
                    }
                }
                if (messageListener != null) {
                    updater.getBroadcaster().removeListener(messageListener);
                }
                progress.doFinalize();
                JDController.releaseDelayExit(id);
            }
        }.start();
    }

    private static void doUpdate(final WebUpdater updater, final ArrayList<FileUpdate> files, final boolean doPluginRestart) {
        new Thread(){

            public void run() {
                String id = JDController.requestDelayExit("doUpdate");
                try {
                    int i = 0;
                    while (!DYNAMIC_PLUGINS_FINISHED) {
                        try {
                            Thread.sleep(1000L);
                            logger.severe("Waiting on DynamicPlugins since " + ++i + " secs!");
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DownloadController dlc = DownloadController.getInstance();
                    if (dlc != null) {
                        JDUpdateUtils.backupDataBase();
                    } else {
                        logger.severe("Could not backup. downloadcontroller=null");
                    }
                    if (!WebUpdate.updateUpdater()) {
                        UPDATE_IN_PROGRESS = false;
                        JDController.releaseDelayExit(id);
                        if (doPluginRestart) {
                            JDUtilities.restartJDandWait();
                        }
                        return;
                    }
                    final ProgressController pc = new ProgressController(JDL.L((String)"jd.utils.webupdate.progresscontroller.text", (String)"Update is running"), 10L);
                    try {
                        updater.getBroadcaster().addListener(new MessageListener(){

                            public void onMessage(MessageEvent event) {
                                pc.setStatusText(String.valueOf(event.getSource().toString()) + ": " + event.getMessage());
                            }
                        });
                        pc.increase(10L);
                        System.out.println("UPdate: " + files);
                        updater.updateFiles(files, pc);
                        if (updater.getErrors() > 0) {
                            System.err.println("ERRO");
                            int ret = UserIO.getInstance().requestConfirmDialog(548, JDL.L((String)"jd.update.Main.error.title", (String)"Errors occured"), JDL.LF((String)"jd.update.Main.error.message", (String)"Errors occured!\r\nThere were %s error(s) while updating. Do you want to update anyway?", (Object[])new Object[]{updater.getErrors()}), UserIO.getInstance().getIcon(1), null, null);
                            if (JDFlags.hasAllFlags(ret, 2)) {
                                JDController.releaseDelayExit(id);
                                JDUtilities.restartJDandWait();
                            }
                        } else {
                            System.err.println("OK RESTART");
                            JDController.releaseDelayExit(id);
                            JDUtilities.restartJDandWait();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("EXCEPTION");
                        JDLogger.exception(e);
                        e.printStackTrace();
                    }
                    pc.doFinalize();
                }
                finally {
                    JDController.releaseDelayExit(id);
                    UPDATE_IN_PROGRESS = false;
                }
            }
        }.start();
    }
}

