/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdtrayicon;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.plugins.optional.jdtrayicon.HoverEffect;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class TrayIconPopup
extends JWindow
implements MouseListener,
ChangeListener {
    private static final long serialVersionUID = 2623190748929934409L;
    private SubConfiguration config = SubConfiguration.getConfig((String)"DOWNLOAD");
    private JPanel entryPanel;
    private JPanel bottomPanel;
    private boolean enteredPopup;
    private JSpinner spMaxSpeed;
    private JSpinner spMaxDls;
    private JSpinner spMaxChunks;
    private JPanel exitPanel;
    private ArrayList<JToggleButton> resizecomps = new ArrayList();

    public TrayIconPopup() {
        this.setVisible(false);
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.addMouseListener(this);
        this.initEntryPanel();
        this.initBottomPanel();
        this.initExitPanel();
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 5, wrap 1", "[]", "[]5[]5[]5[]5[]"));
        this.add(content);
        content.add((Component)new JLabel("<html><b>" + JDUtilities.getJDTitle() + "</b></html>"), "align center");
        content.add((Component)new JSeparator(), "growx, spanx");
        content.add(this.entryPanel);
        content.add((Component)new JSeparator(), "growx, spanx");
        content.add(this.bottomPanel);
        content.add((Component)new JSeparator(), "growx, spanx");
        content.add(this.exitPanel);
        content.setBorder(BorderFactory.createLineBorder(content.getBackground().darker()));
        Dimension size = new Dimension(this.getPreferredSize().width, this.resizecomps.get((int)0).getPreferredSize().height);
        for (JToggleButton c : this.resizecomps) {
            c.setPreferredSize(size);
            c.setMinimumSize(size);
            c.setMaximumSize(size);
        }
        this.setAlwaysOnTop(true);
        this.pack();
    }

    public void startAutoHide() {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TrayIconPopup.this.enteredPopup) {
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            TrayIconPopup.this.dispose();
                            return null;
                        }
                    }.start();
                }
            }
        }.start();
    }

    private void initEntryPanel() {
        this.entryPanel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 1", "[]", "[]0[]0[]0[]0[]0[]0[]0[]0[]0[]"));
        switch (DownloadWatchDog.getInstance().getDownloadStatus()) {
            case NOT_RUNNING: {
                this.addMenuEntry("toolbar.control.start");
                this.addMenuEntry("toolbar.control.stop");
                break;
            }
            case RUNNING: {
                this.addMenuEntry("toolbar.control.stop");
                this.addMenuEntry("toolbar.control.pause");
                break;
            }
            default: {
                this.addMenuEntry("toolbar.control.start");
                this.addMenuEntry("toolbar.control.pause");
            }
        }
        this.addMenuEntry("action.addurl");
        this.addMenuEntry("action.load");
        this.addMenuEntry("toolbar.interaction.update");
        this.addMenuEntry("toolbar.interaction.reconnect");
        this.addMenuEntry("premiumMenu.toggle");
        this.addMenuEntry("toolbar.quickconfig.clipboardoberserver");
        this.addMenuEntry("toolbar.quickconfig.reconnecttoggle");
        this.addMenuEntry("action.opendlfolder");
    }

    private void initExitPanel() {
        this.exitPanel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 1", "[]", "[]"));
        this.exitPanel.add((Component)this.getMenuEntry("action.exit"), "growx,pushx");
    }

    private void initBottomPanel() {
        this.spMaxSpeed = new JSpinner();
        this.spMaxSpeed.setModel(new SpinnerNumberModel(this.config.getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0), 0, Integer.MAX_VALUE, 50));
        this.spMaxSpeed.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.speedlimiter", (String)"Geschwindigkeitsbegrenzung festlegen (KB/s) [0:unendlich]"));
        this.spMaxSpeed.addChangeListener(this);
        this.spMaxDls = new JSpinner();
        this.spMaxDls.setModel(new SpinnerNumberModel(this.config.getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2), 1, 20, 1));
        this.spMaxDls.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.simultan_downloads", (String)"Max. gleichzeitige Downloads"));
        this.spMaxDls.addChangeListener(this);
        this.spMaxChunks = new JSpinner();
        this.spMaxChunks.setModel(new SpinnerNumberModel(this.config.getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 2), 1, 20, 1));
        this.spMaxChunks.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.max_chunks", (String)"Max. Connections/File"));
        this.spMaxChunks.addChangeListener(this);
        this.bottomPanel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 2", "[]5[]", "[]2[]2[]"));
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.add(new JLabel(JDL.L((String)"plugins.trayicon.popup.bottom.speed", (String)"Geschwindigkeitsbegrenzung")));
        this.bottomPanel.add((Component)this.spMaxSpeed, "width 60!,h 20!");
        this.bottomPanel.add(new JLabel(JDL.L((String)"plugins.trayicon.popup.bottom.simDls", (String)"Gleichzeitige Downloads")));
        this.bottomPanel.add((Component)this.spMaxDls, "width 60!, h 20!");
        this.bottomPanel.add(new JLabel(JDL.L((String)"plugins.trayicon.popup.bottom.simChunks", (String)"Gleichzeitige Verbindungen")));
        this.bottomPanel.add((Component)this.spMaxChunks, "width 60!,h 20!");
    }

    private void addMenuEntry(String actionId) {
        JToggleButton b = this.getMenuEntry(actionId);
        this.entryPanel.add((Component)b, "growx,pushx");
    }

    private JToggleButton getMenuEntry(String actionId) {
        ToolBarAction action = ActionController.getToolBarAction((String)actionId);
        JToggleButton b = this.createButton(action);
        this.resizecomps.add(b);
        return b;
    }

    private JToggleButton createButton(ToolBarAction action) {
        action.init();
        JToggleButton bt = new JToggleButton((Action)action);
        bt.setContentAreaFilled(false);
        bt.setBorderPainted(false);
        bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrayIconPopup.this.dispose();
            }
        });
        bt.setOpaque(false);
        bt.setIcon((Icon)action.getValue("SmallIcon"));
        bt.setCursor(Cursor.getPredefinedCursor(12));
        bt.setFocusPainted(false);
        bt.setHorizontalAlignment(2);
        bt.setIconTextGap(5);
        bt.addMouseListener((MouseListener)((Object)new HoverEffect(bt)));
        return bt;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.enteredPopup = true;
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this && this.enteredPopup && !this.contains(e.getPoint())) {
            this.dispose();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        int value;
        if (e.getSource() == this.spMaxSpeed) {
            int value2 = (Integer)this.spMaxSpeed.getValue();
            if (value2 != this.config.getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0)) {
                this.config.setProperty("DOWNLOAD_MAX_SPEED_V2", (Object)value2);
                this.config.save();
            }
        } else if (e.getSource() == this.spMaxDls) {
            int value3 = (Integer)this.spMaxDls.getValue();
            if (value3 != this.config.getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2)) {
                this.config.setProperty("DOWNLOAD_MAX_SIMULTAN", (Object)value3);
                this.config.save();
            }
        } else if (e.getSource() == this.spMaxChunks && (value = ((Integer)this.spMaxChunks.getValue()).intValue()) != this.config.getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 2)) {
            this.config.setProperty("DOWNLOAD_MAX_CHUNKS", (Object)value);
            this.config.save();
        }
    }
}

