/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdtrayicon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jd.plugins.optional.jdtrayicon.JDLightTray;

public class TrayMouseAdapter
implements MouseListener,
MouseMotionListener {
    private JDLightTray deligate;
    private boolean mouseover;
    private Thread mouseLocationObserver;
    private Point min;
    private Point max;
    private Dimension size;
    private MouseEvent lastEvent;
    private Component dummy;
    private static int TOOLTIP_DELAY = 1000;

    public TrayMouseAdapter(JDLightTray lightTray, TrayIcon trayIcon) {
        this.deligate = lightTray;
        this.dummy = new Component(){
            private static final long serialVersionUID = 1L;
        };
        this.size = trayIcon.getSize();
    }

    public void mouseClicked(MouseEvent e) {
        this.deligate.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseover = true;
        final long enterTime = System.currentTimeMillis();
        this.mouseLocationObserver = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    boolean mouseStay = false;
                    while (true) {
                        MouseEvent me;
                        Point point;
                        if (!TrayMouseAdapter.this.isOver(point = MouseInfo.getPointerInfo().getLocation())) {
                            me = new MouseEvent(TrayMouseAdapter.this.dummy, 0, System.currentTimeMillis(), 0, point.x, point.y, 0, false);
                            me.setSource(TrayMouseAdapter.this.lastEvent.getSource());
                            TrayMouseAdapter.this.mouseExited(me);
                            return;
                        }
                        if (System.currentTimeMillis() - enterTime >= (long)TOOLTIP_DELAY && !mouseStay) {
                            mouseStay = true;
                            me = new MouseEvent(TrayMouseAdapter.this.dummy, 0, System.currentTimeMillis(), 0, point.x, point.y, 0, false);
                            me.setSource(TrayMouseAdapter.this);
                            TrayMouseAdapter.this.deligate.mouseStay(me);
                        }
                        Thread.sleep(100L);
                        continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    TrayMouseAdapter.this.mouseLocationObserver = null;
                }
            }
        };
        this.mouseLocationObserver.start();
        this.deligate.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseover = false;
        this.max = null;
        this.min = null;
        this.deligate.mouseExited(e);
    }

    public void mousePressed(MouseEvent e) {
        this.deligate.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.deligate.mouseReleased(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.deligate.mouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.lastEvent = e;
        if (this.min == null) {
            this.min = new Point(e.getPoint().x, e.getPoint().y);
            this.max = new Point(e.getPoint().x, e.getPoint().y);
        } else {
            this.min.x = Math.min(e.getPoint().x, this.min.x);
            this.min.y = Math.min(e.getPoint().y, this.min.y);
            this.max.x = Math.max(e.getPoint().x, this.max.x);
            this.max.y = Math.max(e.getPoint().y, this.max.y);
        }
        if (!this.mouseover) {
            this.mouseEntered(e);
        } else {
            this.deligate.mouseMoved(e);
        }
    }

    public Point getEstimatedTopLeft() {
        int midx = (this.max.x + this.min.x) / 2;
        int midy = (this.max.y + this.min.y) / 2;
        return new Point(midx - this.size.width / 2, midy - this.size.height / 2);
    }

    protected boolean isOver(Point point) {
        int midx = (this.max.x + this.min.x) / 2;
        int midy = (this.max.y + this.min.y) / 2;
        int width = Math.min(this.size.width, this.max.x - this.min.x);
        int height = Math.min(this.size.height, this.max.y - this.min.y);
        int minx = midx - width / 2;
        int miny = midy - height / 2;
        int maxx = midx + width / 2;
        int maxy = midy + height / 2;
        return point.x >= minx && point.x <= maxx && point.y >= miny && point.y <= maxy;
    }
}

