/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util.java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Synthetica2DUtils {
    public static BufferedImage createBluredImage(BufferedImage bufferedImage, int n) {
        ConvolveOp convolveOp = Synthetica2DUtils.createBlurOp(n);
        BufferedImage bufferedImage2 = convolveOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        convolveOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static ConvolveOp createBlurOp(int n) {
        float[] fArray = new float[n * n];
        float f = 1.0f / (float)(n * n);
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = f;
            ++n2;
        }
        return new ConvolveOp(new Kernel(n, n, fArray));
    }

    public static BufferedImage createColorizedImage(BufferedImage bufferedImage, Color color, float f) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(bufferedImage, bufferedImage2, color, f);
        return bufferedImage2;
    }

    public static void colorizeImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, Color color, float f) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(10, f));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.dispose();
    }

    public static Image flipHorizontal(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale(-1.0, 1.0);
        graphics2D.translate(-image.getWidth(null), 0);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image flipVertical(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.scale(1.0, -1.0);
        graphics2D.translate(0, -image.getHeight(null));
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

