/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zip {
    private File destinationFile;
    public LinkedList<File> excludeFiles = new LinkedList();
    private Pattern excludeFilter;
    public int fillSize = 0;
    private File[] srcFiles;
    private boolean deleteAfterPack;

    public Zip(File srcFile, File destinationFile) {
        this(new File[]{srcFile}, destinationFile);
    }

    public Zip(File[] srcFiles, File destinationFile) {
        this.srcFiles = srcFiles;
        this.destinationFile = destinationFile;
    }

    private ArrayList<File> addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        if (srcFile.endsWith("Thumbs.db")) {
            return null;
        }
        if (this.excludeFilter != null && Regex.matches((Object)srcFile, (Pattern)this.excludeFilter)) {
            System.out.println("Filtered: " + srcFile);
            return ret;
        }
        File folder = new File(srcFile);
        if (this.excludeFiles != null && this.excludeFiles.contains(folder)) {
            return ret;
        }
        if (folder.isDirectory()) {
            ret.addAll(this.addFolderToZip(path, srcFile, zip));
            if (this.deleteAfterPack) {
                new File(srcFile).delete();
            }
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            if (path == null || path.trim().length() == 0) {
                zip.putNextEntry(new ZipEntry(folder.getName()));
            } else {
                zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
            }
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
            if (this.deleteAfterPack) {
                new File(srcFile).delete();
            }
            ret.add(new File(srcFile));
        }
        return ret;
    }

    private ArrayList<File> addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        File folder = new File(srcFolder);
        if (this.excludeFiles.contains(folder)) {
            return ret;
        }
        String[] stringArray = folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (this.excludeFilter != null && Regex.matches((Object)fileName, (Pattern)this.excludeFilter)) {
                System.out.println("Filtered: " + fileName);
            } else if (path.equals("")) {
                ret.addAll(this.addFileToZip(folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip));
            } else {
                ret.addAll(this.addFileToZip(String.valueOf(path) + "/" + folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip));
            }
            ++n2;
        }
        return ret;
    }

    public void setExcludeFilter(Pattern compile) {
        this.excludeFilter = compile;
    }

    public ArrayList<File> zip() throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(this.destinationFile);
        zip = new ZipOutputStream(fileWriter);
        File[] fileArray = this.srcFiles;
        int n = this.srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            if (element.isDirectory()) {
                ret.addAll(this.addFolderToZip("", element.getAbsolutePath(), zip));
            } else if (element.isFile()) {
                ret.addAll(this.addFileToZip("", element.getAbsolutePath(), zip));
            }
            ++n2;
        }
        zip.flush();
        zip.close();
        int toFill = (int)((long)this.fillSize - this.destinationFile.length());
        if (toFill > 0) {
            int c;
            byte[] byArray = new byte[10];
            byArray[0] = 80;
            byArray[1] = 75;
            byArray[2] = 3;
            byArray[3] = 4;
            byArray[4] = 20;
            byArray[6] = 8;
            byArray[8] = 8;
            byte[] sig = byArray;
            FileInputStream in = new FileInputStream(this.destinationFile);
            File newTarget = new File(String.valueOf(this.destinationFile.getAbsolutePath()) + ".jd");
            FileOutputStream out = new FileOutputStream(newTarget);
            out.write(sig);
            out.write(new byte[toFill -= sig.length]);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            this.destinationFile.delete();
            newTarget.renameTo(this.destinationFile);
        }
        return ret;
    }

    public void setDeleteAfterPack(boolean b) {
        this.deleteAfterPack = b;
    }
}

