/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.appwork.storage.ExtJsonFactory;
import org.appwork.storage.JacksonStorageChest;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.Crypto;
import org.appwork.utils.logging.Log;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSonStorage {
    private static final HashMap<String, Storage> MAP = new HashMap();
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new ExtJsonFactory());
    public static final Object LOCK = new Object();
    public static byte[] KEY;

    static {
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        KEY = new byte[]{1, 2, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JSonStorage.save();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addStorage(Storage storage) {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            block4: {
                Storage ret = MAP.get(storage.getID());
                if (ret != null) break block4;
                MAP.put(storage.getID(), storage);
                return true;
            }
            return false;
        }
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getPlainStorage(File file) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String id = file.getAbsolutePath();
            Storage ret = MAP.get(id);
            if (ret == null) {
                ret = new JacksonStorageChest(file, true);
                MAP.put(ret.getID(), ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getPlainStorage(String name) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String id = Application.getRessource("cfg/" + name + ".json").getAbsolutePath();
            Storage ret = MAP.get(id);
            if (ret == null) {
                ret = new JacksonStorageChest(name, true);
                MAP.put(ret.getID(), ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getStorage(String name) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String id = Application.getRessource("cfg/" + name + ".ejs").getAbsolutePath();
            Storage ret = MAP.get(id);
            if (ret == null) {
                ret = new JacksonStorageChest(name);
                MAP.put(ret.getID(), ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStorage(Storage storage) {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            block4: {
                Storage ret = MAP.remove(storage.getID());
                if (ret != null) break block4;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> E restoreFrom(File file, boolean plain, byte[] key, TypeReference<E> type, E def) {
        Object object = LOCK;
        synchronized (object) {
            String stri = null;
            byte[] str = null;
            try {
                File res;
                File tmpfile = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
                if (tmpfile.exists()) {
                    Log.L.warning("TMP file " + tmpfile.getAbsolutePath() + " found");
                    try {
                        E ret;
                        str = IO.readFile(tmpfile);
                        if (plain) {
                            stri = new String(str, "UTF-8");
                            ret = JSonStorage.restoreFromString(stri, type, def);
                        } else {
                            stri = Crypto.decrypt(str, key);
                            ret = JSonStorage.restoreFromString(stri, type, def);
                        }
                        Log.L.warning("Could restore tmp file");
                        file.delete();
                        tmpfile.renameTo(file);
                        E e = ret;
                        return e;
                    }
                    catch (Exception e) {
                        Log.L.warning("Could not restore tmp file");
                        Log.exception((Level)Level.WARNING, (Throwable)e);
                    }
                    finally {
                        tmpfile.delete();
                    }
                }
                if (!(res = file).exists() || res.length() == 0L) {
                    return def;
                }
                str = IO.readFile(res);
                if (plain) {
                    stri = new String(str, "UTF-8");
                    return JSonStorage.restoreFromString(stri, type, def);
                }
                stri = Crypto.decrypt(str, key);
                return JSonStorage.restoreFromString(stri, type, def);
            }
            catch (Throwable e) {
                Log.L.severe(String.valueOf(file.getAbsolutePath()) + ":read:" + stri);
                try {
                    if (str != null) {
                        Log.L.severe(String.valueOf(file.getAbsolutePath()) + ":original:" + new String(str, "UTF-8"));
                    }
                }
                catch (Throwable e2) {
                    Log.exception((Throwable)e2);
                }
                Log.exception((Throwable)e);
                return def;
            }
        }
    }

    public static <E> E restoreFrom(String string, TypeReference<E> type, E def) {
        boolean plain = new Regex(string, ".+\\.json").matches();
        return JSonStorage.restoreFrom(Application.getRessource(string), plain, KEY, type, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object restoreFromString(String string, Class<?> class1) throws JsonParseException, JsonMappingException, IOException {
        Object object = LOCK;
        synchronized (object) {
            return MAPPER.readValue(string, class1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E restoreFromString(String string, TypeReference<E> type, E def) throws JsonParseException, JsonMappingException, IOException {
        if (string == null) {
            return def;
        }
        Object object = LOCK;
        synchronized (object) {
            if (type != null) {
                return (E)MAPPER.readValue(string, type);
            }
            return (E)MAPPER.readValue(string, def.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            for (Map.Entry<String, Storage> entry : MAP.entrySet()) {
                try {
                    try {
                        entry.getValue().save();
                    }
                    catch (Throwable e) {
                        Log.exception((Throwable)e);
                        try {
                            entry.getValue().close();
                        }
                        catch (Throwable e2) {
                            Log.exception((Throwable)e2);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        entry.getValue().close();
                    }
                    catch (Throwable e2) {
                        Log.exception((Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    entry.getValue().close();
                }
                catch (Throwable e2) {
                    Log.exception((Throwable)e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(File file, boolean plain, byte[] key, String json) throws StorageException {
        Object object = LOCK;
        synchronized (object) {
            try {
                File tmp = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
                tmp.getParentFile().mkdirs();
                tmp.delete();
                if (plain) {
                    IO.writeToFile(tmp, json.getBytes("UTF-8"));
                } else {
                    IO.writeToFile(tmp, Crypto.encrypt(json, key));
                }
                if (file.exists() && !file.delete()) {
                    throw new StorageException("Could not overwrite file: " + file.getAbsolutePath());
                }
                if (!tmp.renameTo(file)) {
                    throw new StorageException("Could not rename file: " + tmp + " to " + file);
                }
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(String pathname, String json) throws StorageException {
        Object object = LOCK;
        synchronized (object) {
            try {
                File file = Application.getRessource(pathname);
                File tmp = new File(file.getParentFile(), String.valueOf(file.getName()) + ".tmp");
                tmp.getParentFile().mkdirs();
                tmp.delete();
                if (new Regex(pathname, ".+\\.json").matches()) {
                    IO.writeToFile(tmp, json.getBytes("UTF-8"));
                } else {
                    IO.writeToFile(tmp, Crypto.encrypt(json, KEY));
                }
                if (file.exists() && !file.delete()) {
                    throw new StorageException("Could not overwrite file: " + file);
                }
                if (!tmp.renameTo(file)) {
                    throw new StorageException("Could not rename file: " + tmp + " to " + file);
                }
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeToJson(Object list) throws JsonGenerationException, JsonMappingException, IOException {
        Object object = LOCK;
        synchronized (object) {
            return MAPPER.writeValueAsString(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeTo(String string, Object list) {
        Object object = LOCK;
        synchronized (object) {
            try {
                JSonStorage.saveTo(string, JSonStorage.serializeToJson(list));
            }
            catch (JsonGenerationException e) {
                Log.exception((Throwable)e);
            }
            catch (JsonMappingException e) {
                Log.exception((Throwable)e);
            }
            catch (StorageException e) {
                Log.exception((Throwable)e);
            }
            catch (IOException e) {
                Log.exception((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object list) {
        Object object = LOCK;
        synchronized (object) {
            try {
                return MAPPER.writeValueAsString(list);
            }
            catch (JsonGenerationException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return list.toString();
        }
    }
}

