/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.appwork.swing.trayicon.TrayMouseListener;

public class ExtTrayIcon
extends TrayIcon
implements MouseListener,
MouseMotionListener {
    private static int TOOLTIP_DELAY = 1000;
    private Component dummy;
    private MouseEvent lastEvent;
    private Point max;
    private Point min;
    private final ArrayList<MouseListener> mouseListeners;
    private Thread mouseLocationObserver;
    private boolean mouseover;
    private Dimension size;
    private final ArrayList<TrayMouseListener> traymouseListeners;

    public ExtTrayIcon(Image icon, String title) {
        super(icon, title);
        this.setImageAutoSize(true);
        this.mouseListeners = new ArrayList();
        this.traymouseListeners = new ArrayList();
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(MouseListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            this.mouseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrayMouseListener(TrayMouseListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<TrayMouseListener> arrayList = this.traymouseListeners;
        synchronized (arrayList) {
            this.traymouseListeners.add(listener);
        }
    }

    public Point getEstimatedTopLeft() {
        int midx = (this.max.x + this.min.x) / 2;
        int midy = (this.max.y + this.min.y) / 2;
        return new Point(midx - this.size.width / 2, midy - this.size.height / 2);
    }

    protected boolean isOver(Point point) {
        int midx = (this.max.x + this.min.x) / 2;
        int midy = (this.max.y + this.min.y) / 2;
        int width = Math.min(this.size.width, this.max.x - this.min.x);
        int height = Math.min(this.size.height, this.max.y - this.min.y);
        int minx = midx - width / 2;
        int miny = midy - height / 2;
        int maxx = midx + width / 2;
        int maxy = midy + height / 2;
        return point.x >= minx && point.x <= maxx && point.y >= miny && point.y <= maxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent e) {
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            for (MouseListener l : this.mouseListeners) {
                l.mouseClicked(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseover = true;
        final long enterTime = System.currentTimeMillis();
        this.mouseLocationObserver = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    boolean mouseStay = false;
                    while (true) {
                        Object l;
                        Iterator iterator;
                        ArrayList arrayList;
                        MouseEvent me;
                        Point point;
                        if (!ExtTrayIcon.this.isOver(point = MouseInfo.getPointerInfo().getLocation())) {
                            me = new MouseEvent(ExtTrayIcon.this.dummy, 0, System.currentTimeMillis(), 0, point.x, point.y, 0, false);
                            me.setSource(ExtTrayIcon.this.lastEvent.getSource());
                            arrayList = ExtTrayIcon.this.mouseListeners;
                            synchronized (arrayList) {
                                iterator = ExtTrayIcon.this.mouseListeners.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        return;
                                    }
                                    l = (MouseListener)iterator.next();
                                    l.mouseExited(me);
                                }
                            }
                        }
                        if (System.currentTimeMillis() - enterTime >= (long)TOOLTIP_DELAY && !mouseStay) {
                            mouseStay = true;
                            me = new MouseEvent(ExtTrayIcon.this.dummy, 0, System.currentTimeMillis(), 0, point.x, point.y, 0, false);
                            arrayList = ExtTrayIcon.this.traymouseListeners;
                            synchronized (arrayList) {
                                iterator = ExtTrayIcon.this.traymouseListeners.iterator();
                                while (iterator.hasNext()) {
                                    l = (TrayMouseListener)iterator.next();
                                    l.mouseMoveOverTray(me);
                                }
                            }
                        }
                        Thread.sleep(100L);
                        continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    ExtTrayIcon.this.mouseLocationObserver = null;
                }
            }
        };
        this.mouseLocationObserver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseExited(MouseEvent e) {
        this.mouseover = false;
        this.max = null;
        this.min = null;
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            for (MouseListener l : this.mouseListeners) {
                l.mouseExited(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent e) {
        this.lastEvent = e;
        if (this.min == null) {
            this.min = new Point(e.getPoint().x, e.getPoint().y);
            this.max = new Point(e.getPoint().x, e.getPoint().y);
        } else {
            this.min.x = Math.min(e.getPoint().x, this.min.x);
            this.min.y = Math.min(e.getPoint().y, this.min.y);
            this.max.x = Math.max(e.getPoint().x, this.max.x);
            this.max.y = Math.max(e.getPoint().y, this.max.y);
        }
        if (!this.mouseover) {
            ArrayList<MouseListener> arrayList = this.mouseListeners;
            synchronized (arrayList) {
                for (MouseListener l : this.mouseListeners) {
                    l.mouseEntered(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            for (MouseListener l : this.mouseListeners) {
                l.mousePressed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            for (MouseListener l : this.mouseListeners) {
                l.mouseReleased(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(MouseListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<MouseListener> arrayList = this.mouseListeners;
        synchronized (arrayList) {
            this.mouseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrayMouseListener(TrayMouseListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<TrayMouseListener> arrayList = this.traymouseListeners;
        synchronized (arrayList) {
            this.traymouseListeners.remove(listener);
        }
    }
}

