/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.HTMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipboardUtils {
    private static ClipboardUtils INSTANCE;
    public static final DataFlavor fileListFlavor;
    public static final DataFlavor stringFlavor;
    private static final byte[] tmpByteArray;
    public static final DataFlavor arrayListFlavor;
    public static final DataFlavor uriListFlavor;

    static {
        DataFlavor tmp;
        INSTANCE = new ClipboardUtils();
        fileListFlavor = DataFlavor.javaFileListFlavor;
        stringFlavor = DataFlavor.stringFlavor;
        tmpByteArray = new byte[0];
        try {
            tmp = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (Throwable e) {
            tmp = null;
        }
        uriListFlavor = tmp;
        try {
            tmp = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.ArrayList");
        }
        catch (Throwable e) {
            tmp = null;
        }
        arrayListFlavor = tmp;
    }

    public static ClipboardUtils getInstance() {
        return INSTANCE;
    }

    private ClipboardUtils() {
    }

    public static boolean hasSupport(DataFlavor flavor) {
        if (flavor != null) {
            if (uriListFlavor != null && flavor.isMimeTypeEqual(uriListFlavor)) {
                return true;
            }
            if (fileListFlavor != null && flavor.isMimeTypeEqual(fileListFlavor)) {
                return true;
            }
            if (arrayListFlavor != null && flavor.isMimeTypeEqual(arrayListFlavor)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasSupport(TransferHandler.TransferSupport info) {
        if (info != null) {
            DataFlavor[] dataFlavorArray = info.getDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flavor = dataFlavorArray[n2];
                if (ClipboardUtils.hasSupport(flavor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ArrayList<String> getLinks(TransferHandler.TransferSupport trans) {
        ArrayList<String> links = new ArrayList<String>();
        String content = null;
        DataFlavor htmlFlavor = null;
        try {
            DataFlavor[] dataFlavorArray = trans.getTransferable().getTransferDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flav = dataFlavorArray[n2];
                if (flav.getMimeType().contains("html") && flav.getRepresentationClass().isInstance(tmpByteArray)) {
                    String charSet;
                    if (htmlFlavor != null) {
                        htmlFlavor = flav;
                    }
                    if ((charSet = new Regex(flav.toString(), "charset=(.*?)]").getMatch(0)) != null && charSet.equalsIgnoreCase("UTF-8")) {
                        htmlFlavor = flav;
                        break;
                    }
                }
                ++n2;
            }
            if (htmlFlavor != null) {
                String charSet = new Regex(htmlFlavor.toString(), "charset=(.*?)]").getMatch(0);
                byte[] html = (byte[])trans.getTransferable().getTransferData(htmlFlavor);
                if (CrossSystem.isLinux()) {
                    int htmlLength = html.length;
                    byte[] html2 = new byte[htmlLength];
                    int o = 0;
                    int i = 6;
                    while (i < htmlLength - 1) {
                        if (html[i] != 0) {
                            html2[o++] = html[i];
                        }
                        ++i;
                    }
                    html = html2;
                    content = new String(html, "UTF-8");
                } else {
                    content = charSet != null ? new String(html, charSet) : new String(html);
                }
            } else if (trans.isDataFlavorSupported(stringFlavor)) {
                content = (String)trans.getTransferable().getTransferData(stringFlavor);
            }
            if (content != null) {
                links.addAll(HTMLParser.findUrls(content));
            }
        }
        catch (Exception e) {
            Log.L.info(e.getMessage());
        }
        return links;
    }

    public static ArrayList<File> getFiles(TransferHandler.TransferSupport info) {
        ArrayList<File> files = new ArrayList<File>();
        String inString = null;
        if (info != null) {
            try {
                if (info.isDataFlavorSupported(fileListFlavor)) {
                    List list = (List)info.getTransferable().getTransferData(fileListFlavor);
                    for (File f : list) {
                        if (!f.exists()) continue;
                        files.add(f);
                    }
                } else if (uriListFlavor != null && info.isDataFlavorSupported(uriListFlavor)) {
                    inString = (String)info.getTransferable().getTransferData(uriListFlavor);
                    StringTokenizer izer = new StringTokenizer(inString, "\r\n");
                    while (izer.hasMoreTokens()) {
                        String token = izer.nextToken().trim();
                        try {
                            URI fi = new URI(token);
                            File f = new File(fi.getPath());
                            if (!f.exists()) continue;
                            files.add(f);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.L.warning(inString);
                Log.L.warning(e.getMessage());
            }
        }
        return files;
    }
}

