/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.appwork.utils.formatter.HexFormatter;

public class Hash {
    public static String HASH_TYPE_MD5 = "md5";
    public static String HASH_TYPE_SHA1 = "SHA-1";

    public static long getCRC32(File arg) throws IOException {
        FileInputStream fis = new FileInputStream(arg);
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(fis, new CRC32());
            byte[] readBuffer = new byte[Short.MAX_VALUE];
            while (cis.read(readBuffer) >= 0) {
            }
            long l = ((CheckedInputStream)cis).getChecksum().getValue();
            return l;
        }
        finally {
            try {
                cis.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String getFileHash(File arg, String type) {
        if (arg == null || !arg.exists() || arg.isDirectory()) {
            return null;
        }
        FileInputStream fis = null;
        MessageDigest md = null;
        try {
            try {
                md = MessageDigest.getInstance(type);
                byte[] b = new byte[Short.MAX_VALUE];
                fis = new FileInputStream(arg);
                int n = 0;
                while ((n = fis.read(b)) > -1) {
                    md.update(b, 0, n);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    fis.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        byte[] digest = md.digest();
        return HexFormatter.byteArrayToHex(digest);
    }

    public static String getMD5(File arg) {
        return Hash.getFileHash(arg, HASH_TYPE_MD5);
    }

    public static String getMD5(String arg) {
        return Hash.getStringHash(arg, HASH_TYPE_MD5);
    }

    public static String getSHA1(File arg) {
        return Hash.getFileHash(arg, HASH_TYPE_SHA1);
    }

    public static String getSHA1(String arg) {
        return Hash.getStringHash(arg, HASH_TYPE_SHA1);
    }

    public static String getStringHash(String arg, String type) {
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] digest = md.digest(arg.getBytes());
            return HexFormatter.byteArrayToHex(digest);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

