/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueAction<T, E extends Throwable> {
    private Throwable exeption;
    private volatile boolean finished = false;
    private volatile boolean killed = false;
    private Queue.QueuePriority prio = Queue.QueuePriority.NORM;
    private Queue queue = null;
    private T result = null;
    private String callerStackTrace = null;
    private volatile boolean started = false;
    private Thread thread = null;

    public QueueAction() {
    }

    public QueueAction(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    protected synchronized boolean callExceptionHandler() {
        if (this.exeption == null) {
            return true;
        }
        if (this.exeption != null && this.handleException(this.exeption)) {
            this.exeption = null;
            return true;
        }
        return false;
    }

    protected String getCallerStackTrace() {
        return this.callerStackTrace;
    }

    protected Thread getCallerThread() {
        return this.thread;
    }

    public Throwable getExeption() {
        return this.exeption;
    }

    protected Queue getQueue() {
        return this.queue;
    }

    public Queue.QueuePriority getQueuePrio() {
        return this.prio;
    }

    public T getResult() {
        return this.result;
    }

    public boolean gotKilled() {
        return this.killed;
    }

    public boolean gotStarted() {
        return this.started;
    }

    public boolean handleException(Throwable e) {
        Log.exception((Throwable)e);
        return false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void kill() {
        if (this.finished) {
            return;
        }
        this.killed = true;
        this.finished = true;
    }

    public void reset() {
        this.exeption = null;
        this.killed = false;
        this.finished = false;
        this.callerStackTrace = null;
        this.thread = null;
        this.queue = null;
    }

    protected abstract T run() throws E;

    public void setCallerThread(Queue queue, Thread thread) {
        this.thread = thread;
        this.queue = queue;
        if (queue != null && queue.isDebug() && thread != null) {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement elem = stackTraceElementArray[n2];
                sb.append(String.valueOf(elem.toString()) + "\r\n");
                ++n2;
            }
            this.callerStackTrace = sb.toString();
            Object var3_3 = null;
        }
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setQueuePrio(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    public final void start(Queue queue) throws E {
        this.queue = queue;
        this.started = true;
        try {
            this.result = this.run();
        }
        catch (Throwable th) {
            if (queue != null && queue.isDebug()) {
                Log.L.severe("QueueActionCallerStackTrace:\r\n" + this.callerStackTrace);
            }
            this.exeption = th;
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw th;
        }
    }
}

