/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.meteredconnection;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredInputStream
extends InputStream
implements SpeedMeterInterface {
    private InputStream in;
    private SpeedMeterInterface speedmeter = null;
    private long transfered = 0L;
    private long transfered2 = 0L;
    private long time = 0L;
    private int readTmp1;
    private long speed = 0L;
    private int offset;
    private int checkStep = 1024;
    public static final int LOWStep = 1024;
    private int todo;
    private int lastRead;
    private int rest;
    private int lastRead2;
    private long lastTime;
    private long lastTrans;
    private long timeForCheckStep = 0L;
    private int timeCheck = 0;

    public MeteredInputStream(InputStream in) {
        this.in = in;
    }

    public MeteredInputStream(InputStream in, SpeedMeterInterface speedmeter) {
        this.in = in;
        this.speedmeter = speedmeter;
    }

    public int read() throws IOException {
        this.readTmp1 = this.in.read();
        if (this.readTmp1 != -1) {
            ++this.transfered;
        }
        return this.readTmp1;
    }

    public int getCheckStepSize() {
        return this.checkStep;
    }

    public void setCheckStepSize(int step) {
        this.checkStep = Math.min(1024, this.checkStep);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.offset = off;
        this.rest = len;
        this.lastRead2 = 0;
        while (this.rest != 0) {
            this.todo = this.rest;
            if (this.todo > this.checkStep) {
                this.todo = this.checkStep;
            }
            this.timeForCheckStep = System.currentTimeMillis();
            this.lastRead = this.in.read(b, this.offset, this.todo);
            this.timeCheck = (int)(System.currentTimeMillis() - this.timeForCheckStep);
            if (this.lastRead == -1) break;
            if (this.timeCheck > 1000) {
                this.checkStep = Math.max(1024, this.todo / this.timeCheck * 500);
            } else if (this.timeCheck == 0) {
                this.checkStep += 1024;
            }
            this.lastRead2 += this.lastRead;
            this.transfered += (long)this.lastRead;
            this.rest -= this.lastRead;
            this.offset += this.lastRead;
        }
        if (this.lastRead == -1 && this.lastRead2 == 0) {
            return -1;
        }
        return this.lastRead2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized long getSpeedMeter() {
        if (this.time == 0L) {
            this.time = System.currentTimeMillis();
            this.transfered2 = this.transfered;
            return 0L;
        }
        if (System.currentTimeMillis() - this.time < 1000L) {
            if (this.speedmeter != null) {
                return this.speedmeter.getSpeedMeter();
            }
            return this.speed;
        }
        this.lastTime = System.currentTimeMillis() - this.time;
        this.time = System.currentTimeMillis();
        this.lastTrans = this.transfered - this.transfered2;
        this.transfered2 = this.transfered;
        if (this.speedmeter != null) {
            this.speedmeter.putSpeedMeter(this.lastTrans, this.lastTime);
            this.speed = this.speedmeter.getSpeedMeter();
            return this.speed;
        }
        this.speed = this.lastTrans / this.lastTime * 1000L;
        return this.speed;
    }

    public void putSpeedMeter(long bytes, long time) {
    }

    public synchronized void resetSpeedMeter() {
        if (this.speedmeter != null) {
            this.speedmeter.resetSpeedMeter();
        }
        this.speed = 0L;
        this.transfered2 = this.transfered;
        this.time = System.currentTimeMillis();
    }
}

