/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottledConnectionManager {
    private ArrayList<ThrottledConnection> managedIn = new ArrayList();
    private ArrayList<ThrottledConnection> managedOut = new ArrayList();
    private final Object LOCK = new Object();
    private static final int updateSpeed = 2000;
    private Thread watchDog = null;
    private long IncommingBandwidthLimit = 0L;
    private long IncommingBandwidthUsage = 0L;
    private long OutgoingBandwidthLimit = 0L;
    private long OutgoingBandwidthUsage = 0L;

    public ThrottledInputStream getManagedThrottledInputStream(InputStream in) {
        ThrottledInputStream ret = new ThrottledInputStream(in, this);
        this.addManagedThrottledInputStream(ret);
        return ret;
    }

    public ThrottledOutputStream getManagedThrottledOutputStream(OutputStream out) {
        ThrottledOutputStream ret = new ThrottledOutputStream(out, this);
        this.addManagedThrottledOutputStream(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedThrottledInputStream(ThrottledInputStream tin) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.managedIn.contains(tin)) {
                return;
            }
            this.managedIn.add(tin);
            tin.setManager(this);
            tin.setManagedLimit(this.IncommingBandwidthLimit / (long)this.managedIn.size());
            this.startWatchDog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedThrottledOutputStream(ThrottledOutputStream tout) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.managedOut.contains(tout)) {
                return;
            }
            this.managedOut.add(tout);
            tout.setManager(this);
            tout.setManagedLimit(this.OutgoingBandwidthLimit / (long)this.managedOut.size());
            this.startWatchDog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeManagedThrottledInputStream(ThrottledInputStream tin) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean ret = this.managedIn.remove(tin);
            if (ret) {
                tin.setManager(null);
                tin.setManagedLimit(0L);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeManagedThrottledOutputStream(ThrottledOutputStream tout) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean ret = this.managedOut.remove(tout);
            if (ret) {
                tout.setManager(null);
                tout.setManagedLimit(0L);
            }
            return ret;
        }
    }

    public void setIncommingBandwidthLimit(long kpsLimit) {
        this.IncommingBandwidthLimit = Math.max(0L, kpsLimit);
    }

    public long geIncommingBandwidthLimit() {
        return this.IncommingBandwidthLimit;
    }

    public void setOutgoingBandwidthLimit(long kpsLimit) {
        this.OutgoingBandwidthLimit = Math.max(0L, kpsLimit);
    }

    public long getOutgoingBandwidthLimit() {
        return this.OutgoingBandwidthLimit;
    }

    public long getOutgoingBandwidthUsage() {
        return this.OutgoingBandwidthUsage;
    }

    public long getIncommingBandwidthUsage() {
        return this.IncommingBandwidthUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long manageConnections(ArrayList<ThrottledConnection> managed, long limit) {
        Object object = this.LOCK;
        synchronized (object) {
            long managedConnections = 0L;
            long currentRealSpeed = 0L;
            for (ThrottledConnection in : managed) {
                long ret = in.transferedSinceLastCall();
                currentRealSpeed += ret;
                if (in.getCustomLimit() != 0L || ret == 0L) continue;
                ++managedConnections;
            }
            currentRealSpeed = currentRealSpeed * 1000L / (long)Math.max(1000, 2000);
            long newLimit = 0L;
            newLimit = managedConnections == 0L ? limit : limit / managedConnections;
            for (ThrottledConnection in : managed) {
                if (newLimit == 0L) {
                    in.setManagedLimit(0L);
                    continue;
                }
                in.setManagedLimit(newLimit);
            }
            return currentRealSpeed;
        }
    }

    private synchronized void startWatchDog() {
        if (this.watchDog != null) {
            return;
        }
        this.watchDog = new Thread(){

            public void run() {
                this.setName("ThrottlecConnectionManager");
                while (true) {
                    try {
                        1.sleep(Math.max(1000, 2000));
                    }
                    catch (InterruptedException e) {
                        Log.exception((Throwable)e);
                    }
                    ThrottledConnectionManager.this.IncommingBandwidthUsage = ThrottledConnectionManager.this.manageConnections(ThrottledConnectionManager.this.managedIn, ThrottledConnectionManager.this.IncommingBandwidthLimit);
                    ThrottledConnectionManager.this.OutgoingBandwidthUsage = ThrottledConnectionManager.this.manageConnections(ThrottledConnectionManager.this.managedOut, ThrottledConnectionManager.this.OutgoingBandwidthLimit);
                }
            }
        };
        this.watchDog.start();
    }
}

