/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionManager;

public class ThrottledInputStream
extends InputStream
implements ThrottledConnection {
    private ThrottledConnectionManager manager;
    private InputStream in;
    protected long transferedCounter = 0L;
    protected long transferedCounter2 = 0L;
    private long limitCurrent = 0L;
    private long limitManaged = 0L;
    private long limitCustom = 0L;
    private long limitCounter = 0L;
    private long lastLimitReached = 0L;
    private int lastRead;
    private int lastRead2;
    public static final int HIGHStep = 524288;
    public static final int LOWStep = 1024;
    private int checkStep = 10240;
    private int offset;
    private int todo;
    private int rest;
    private long ret;
    private long timeForCheckStep = 0L;
    private int timeCheck = 0;

    public ThrottledInputStream(InputStream in) {
        this.in = in;
    }

    public ThrottledInputStream(InputStream in, long kpsLimit) {
        this(in);
        this.setCustomLimit(kpsLimit);
    }

    protected ThrottledInputStream(InputStream in, ThrottledConnectionManager manager) {
        this.manager = manager;
        this.in = in;
    }

    public int getCheckStepSize() {
        return this.checkStep;
    }

    public void setCheckStepSize(int step) {
        this.checkStep = Math.max(524288, step);
        this.checkStep = Math.min(1024, this.checkStep);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.offset = off;
        this.rest = len;
        this.lastRead2 = 0;
        while (this.rest != 0) {
            this.todo = this.rest;
            if (this.todo > this.checkStep) {
                this.todo = this.checkStep;
            }
            if (this.limitCurrent != 0L) {
                this.lastRead = this.in.read(b, this.offset, this.todo);
            } else {
                this.timeForCheckStep = System.currentTimeMillis();
                this.lastRead = this.in.read(b, this.offset, this.todo);
                this.timeCheck = (int)(System.currentTimeMillis() - this.timeForCheckStep);
                if (this.timeCheck > 1000) {
                    this.checkStep = Math.max(1024, this.todo / this.timeCheck * 500);
                } else if (this.timeCheck == 0) {
                    this.checkStep += 1024;
                }
            }
            if (this.lastRead == -1) break;
            this.lastRead2 += this.lastRead;
            this.increase(this.lastRead);
            this.rest -= this.lastRead;
            this.offset += this.lastRead;
        }
        if (this.lastRead == -1 && this.lastRead2 == 0) {
            return -1;
        }
        return this.lastRead2;
    }

    public int read() throws IOException {
        this.lastRead2 = this.in.read();
        this.increase(this.lastRead2);
        return this.lastRead2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void increase(int num) {
        if (num == -1) {
            return;
        }
        this.transferedCounter += (long)num;
        if (this.limitCurrent != 0L) {
            this.limitCounter += (long)num;
            if (this.limitCounter > this.limitCurrent) {
                long pause;
                if (this.lastLimitReached == 0L) {
                    this.lastLimitReached = System.currentTimeMillis();
                }
                if ((pause = 1000L - (System.currentTimeMillis() - this.lastLimitReached)) >= 0L) {
                    if (pause == 0L) {
                        pause = 1000L;
                    }
                    ThrottledInputStream throttledInputStream = this;
                    synchronized (throttledInputStream) {
                        try {
                            this.wait(pause);
                        }
                        catch (InterruptedException e) {
                            Log.exception((Throwable)e);
                        }
                    }
                    this.checkStep = this.limitCurrent >= 524288L ? 524289 : (this.limitCurrent <= 1024L ? 1024 : (int)this.limitCurrent + 1);
                }
                this.lastLimitReached = System.currentTimeMillis();
                this.limitCounter = 0L;
            }
        } else {
            this.checkStep = 524288;
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public synchronized long transferedSinceLastCall() {
        this.ret = this.transferedCounter - this.transferedCounter2;
        this.transferedCounter2 = this.transferedCounter;
        return this.ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.manager != null) {
            this.manager.removeManagedThrottledInputStream(this);
            this.manager = null;
        }
        ThrottledInputStream throttledInputStream = this;
        synchronized (throttledInputStream) {
            this.notify();
        }
        this.in.close();
    }

    public void setManager(ThrottledConnectionManager manager) {
        if (this.manager != null && this.manager != manager) {
            this.manager.removeManagedThrottledInputStream(this);
        }
        this.manager = manager;
        if (this.manager != null) {
            this.manager.addManagedThrottledInputStream(this);
        }
    }

    public void setManagedLimit(long kpsLimit) {
        if (kpsLimit == this.limitManaged) {
            return;
        }
        if (kpsLimit <= 0L) {
            this.limitManaged = 0L;
            if (this.limitCustom == 0L) {
                this.changeCurrentLimit(0L);
            }
        } else {
            this.limitManaged = kpsLimit;
            if (this.limitCustom == 0L) {
                this.changeCurrentLimit(kpsLimit);
            }
        }
    }

    public void setCustomLimit(long kpsLimit) {
        if (this.limitCustom == kpsLimit) {
            return;
        }
        if (kpsLimit < 0L) {
            this.limitCustom = -1L;
            this.changeCurrentLimit(0L);
        } else if (kpsLimit == 0L) {
            this.limitCustom = 0L;
            this.changeCurrentLimit(this.limitManaged);
        } else {
            this.limitCustom = kpsLimit;
            this.changeCurrentLimit(kpsLimit);
        }
    }

    public long getCustomLimit() {
        return this.limitCustom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCurrentLimit(long kpsLimit) {
        if (kpsLimit == this.limitCurrent) {
            return;
        }
        this.limitCurrent = Math.max(0L, kpsLimit);
        ThrottledInputStream throttledInputStream = this;
        synchronized (throttledInputStream) {
            this.notify();
        }
    }
}

