/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.mime.Mime;
import org.appwork.utils.os.mime.MimeDefault;
import org.appwork.utils.os.mime.MimeLinux;
import org.appwork.utils.os.mime.MimeWindows;

public class CrossSystem {
    public static final byte OS_LINUX_OTHER = 6;
    public static final byte OS_MAC_OTHER = 5;
    public static final byte OS_WINDOWS_OTHER = 4;
    public static final byte OS_WINDOWS_NT = 3;
    public static final byte OS_WINDOWS_2000 = 2;
    public static final byte OS_WINDOWS_XP = 0;
    public static final byte OS_WINDOWS_2003 = 7;
    public static final byte OS_WINDOWS_VISTA = 1;
    public static final byte OS_WINDOWS_7 = 8;
    private static final String OS_STRING = System.getProperty("os.name");
    private static final byte OS_ID;
    private static final Mime MIME;

    static {
        String OS = OS_STRING.toLowerCase();
        OS_ID = OS.contains("windows 7") ? (byte)8 : (OS.contains("windows xp") ? (byte)0 : (OS.contains("windows vista") ? (byte)1 : (OS.contains("windows 2000") ? (byte)2 : (OS.contains("windows 2003") ? (byte)7 : (OS.contains("nt") ? (byte)3 : (OS.contains("windows") ? (byte)4 : (OS.contains("mac") ? (byte)5 : (byte)6)))))));
        MIME = CrossSystem.isWindows() ? new MimeWindows() : (CrossSystem.isLinux() ? new MimeLinux() : new MimeDefault());
    }

    public static byte getID() {
        return OS_ID;
    }

    public static Mime getMime() {
        return MIME;
    }

    public static String getOSString() {
        return OS_STRING;
    }

    public static boolean isLinux() {
        return OS_ID == 6;
    }

    public static boolean isMac() {
        return OS_ID == 5;
    }

    public static boolean isOpenBrowserSupported() {
        if (CrossSystem.isWindows()) {
            return true;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            return desktop.isSupported(Desktop.Action.BROWSE);
        }
        catch (Throwable e) {
            Log.exception((Level)Level.WARNING, (Throwable)e);
            return false;
        }
    }

    public static boolean isOpenFileSupported() {
        if (CrossSystem.isWindows()) {
            return true;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            return desktop.isSupported(Desktop.Action.OPEN);
        }
        catch (Throwable e) {
            Log.exception((Level)Level.WARNING, (Throwable)e);
            return true;
        }
    }

    public static boolean isWindows() {
        switch (OS_ID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void openFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (CrossSystem.isWindows()) {
            try {
                Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", file.getAbsolutePath()});
                return;
            }
            catch (IOException e) {
                Log.exception((Level)Level.WARNING, (Throwable)e);
            }
        }
        if (!Desktop.isDesktopSupported()) {
            Log.L.warning("Desktop is not supported (fatal)");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            Log.L.severe("Desktop doesn't support the OPEN action (fatal)");
            return;
        }
        try {
            URI uri = file.getCanonicalFile().toURI();
            desktop.open(new File(uri));
        }
        catch (Exception e) {
            try {
                Log.L.warning(file.getCanonicalFile().toURI().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.exception((Level)Level.WARNING, (Throwable)e);
        }
    }

    public static void openURL(URL url) {
        if (url == null) {
            return;
        }
        if (CrossSystem.isWindows()) {
            try {
                Runtime.getRuntime().exec(new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url.toString()});
                return;
            }
            catch (IOException e) {
                Log.exception((Level)Level.WARNING, (Throwable)e);
            }
        }
        if (!Desktop.isDesktopSupported()) {
            Log.L.severe("Desktop is not supported (fatal)");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            Log.L.warning("Desktop doesn't support the browse action (fatal)");
            return;
        }
        try {
            desktop.browse(url.toURI());
        }
        catch (Exception e) {
            try {
                Log.L.warning(url.toURI().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.exception((Level)Level.WARNING, (Throwable)e);
        }
    }
}

