/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser.test;

import java.util.ArrayList;
import org.appwork.utils.parser.HTMLParser;
import org.junit.Assert;
import org.junit.Test;

public class HTMLParserTest {
    @Test
    public void test() {
        TestEntry[] testStrings;
        TestEntry[] testEntryArray = testStrings = new TestEntry[]{new TestEntry("http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip ", "http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip"), new TestEntry(" http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip ", "http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip"), new TestEntry(" http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip ", "http://www.rapidshare.com/files/410828702/jetty-distribution-8.0.0.M0.zip"), new TestEntry("http://www.rapidshare.com/files/410828702/jetty-dis tribution-8.0.0.M0.zip", "http://www.rapidshare.com/files/410828702/jetty-dis"), new TestEntry("http://www.rapidshare.com/files/410828702/jetty-dis%20tribution-8.0.0.M0.zip", "http://www.rapidshare.com/files/410828702/jetty-dis%20tribution-8.0.0.M0.zip"), new TestEntry("http://www.google.comkkkk&url1=www://yahoo.com:1182/s/Homelll", "http://www.google.comkkkk&url1=www://yahoo.com:1182/s/Homelll"), new TestEntry(3, "http://www.google.de http://google.de ftp://bla www.google.de google.de"), new TestEntry("http://user@www.google.de http://user:pass@google.de ", "http://user@www.google.de", "http://user:pass@google.de"), new TestEntry("http://www.google.de:999/dds.html", "http://www.google.de:999/dds.html"), new TestEntry("http://www.google.de:999/dds.html#a \r\nhttp://www.google.de:999/dds.html?abc=3&jd=6#b", "http://www.google.de:999/dds.html#a", "http://www.google.de:999/dds.html?abc=3&jd=6#b")};
        int n = testStrings.length;
        int n2 = 0;
        while (n2 < n) {
            TestEntry e = testEntryArray[n2];
            ArrayList<String> found = HTMLParser.findUrls(e.getString());
            Assert.assertTrue((found.size() == e.getUrlsCount() ? 1 : 0) != 0);
            if (e.getFinds() != null) {
                int i = 0;
                while (i < e.getFinds().length) {
                    boolean equals = found.get(i).equalsIgnoreCase(e.getFinds()[i]);
                    Assert.assertTrue((boolean)equals);
                    ++i;
                }
            }
            ++n2;
        }
    }

    public static class TestEntry {
        private String[] finds = null;
        private final String string;
        private final int urlsCount;

        public TestEntry(int i, String string) {
            this(i, string, new String[]{null});
        }

        public TestEntry(int i, String string, String ... finds) {
            this.urlsCount = i;
            this.string = string;
            this.finds = finds;
        }

        public TestEntry(String string, String ... finds) {
            this(finds.length, string, finds);
        }

        public String[] getFinds() {
            return this.finds;
        }

        public String getString() {
            return this.string;
        }

        public int getUrlsCount() {
            return this.urlsCount;
        }
    }
}

