/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.gui.swing.Factory;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.BrowseFile;
import jd.gui.swing.dialog.AbstractDialog;
import jd.gui.swing.dialog.ContainerDialog;
import jd.nutils.JDFlags;
import jd.nutils.JDImage;
import jd.nutils.OSDetector;
import jd.nutils.nativeintegration.LocalBrowser;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import jd.utils.locale.JDLocale;
import net.miginfocom.swing.MigLayout;

public class Installer {
    private static final long serialVersionUID = 8764525546298642601L;
    private boolean aborted = false;
    private String countryCode = JDL.getCountryCodeByIP();
    private File dlFolder = null;
    private BrowseFile br;
    private String languageCode;

    public Installer() {
        if (this.countryCode != null) {
            this.languageCode = this.countryCode.toLowerCase();
        }
        SubConfiguration.getConfig("LOCALE").setProperty("LOCALE4", null);
        this.showConfig();
        if (JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY") == null) {
            JDLogger.getLogger().severe("downloaddir not set");
            this.aborted = true;
            return;
        }
        AbstractDialog.setDefaultDimension((Dimension)new Dimension(550, 400));
        Installer.askInstallFlashgot();
        JDUtilities.getConfiguration().save();
        AbstractDialog.setDefaultDimension(null);
    }

    public static void askInstallFlashgot() {
        final SubConfiguration subConfiguration = SubConfiguration.getConfig("FLASHGOT");
        if (subConfiguration.getBooleanProperty("ASKED_TO_INSTALL_FLASHGOT", false).booleanValue()) {
            return;
        }
        int n = (Integer)new GuiRunnable<Integer>(){

            public Integer runSave() {
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 10,wrap 1", "[grow,fill]", "[][][grow,fill]"));
                JLabel jLabel = new JLabel(JDL.L("installer.gui.message", "After Installation, JDownloader will update to the latest version."));
                jPanel.add((Component)jLabel, "pushx,growx,split 2");
                Font font = jLabel.getFont();
                font = font.deriveFont(font.getStyle() ^ 1);
                jLabel.setFont(font);
                jPanel.add((Component)new JLabel(JDImage.getScaledImageIcon((BufferedImage)JDImage.getImage((String)"logo/jd_logo_54_54"), (int)32, (int)32)), "alignx right");
                jPanel.add((Component)new JSeparator(), "pushx,growx,gapbottom 5");
                jLabel = new JLabel(JDL.L("installer.firefox.message", "Do you want to integrate JDownloader to Firefox?"));
                jPanel.add((Component)jLabel, "growy,pushy");
                jLabel = new JLabel(JDImage.getImageIcon((String)"flashgot_logo"));
                jPanel.add((Component)jLabel, "growy,pushy");
                jLabel = new JLabel(JDL.L("installer.firefox.message.flashgot", "This installs the famous FlashGot Extension (flashgot.net)."));
                jPanel.add((Component)jLabel, "growy,pushy");
                jLabel.setVerticalAlignment(1);
                jLabel.setHorizontalAlignment(2);
                return new ContainerDialog(4, JDL.L("installer.firefox.title", "Install firefox integration?"), jPanel, null, null, null){
                    private static final long serialVersionUID = -7983868276841947499L;

                    protected void packed() {
                        this.setSize(550, 400);
                    }

                    protected void setReturnValue(boolean bl) {
                        subConfiguration.setProperty("ASKED_TO_INSTALL_FLASHGOT", true);
                        subConfiguration.save();
                    }
                }.getReturnValue();
            }
        }.getReturnValue();
        if (JDFlags.hasAllFlags((int)n, (int[])new int[]{2})) {
            Installer.installFirefoxAddon();
        }
    }

    private void showConfig() {
        new GuiRunnable<Object>(){
            private ContainerDialog dialog;

            public Object runSave() {
                JDLocale jDLocale2;
                String string = null;
                if (Installer.this.languageCode != null) {
                    for (JDLocale jDLocale2 : JDL.getLocaleIDs()) {
                        if (jDLocale2.getCountryCode() == null || !jDLocale2.getCountryCode().equalsIgnoreCase(Installer.this.languageCode)) continue;
                        string = Installer.this.languageCode;
                        break;
                    }
                    if (string == null) {
                        for (JDLocale jDLocale2 : JDL.getLocaleIDs()) {
                            if (!jDLocale2.getLanguageCode().equalsIgnoreCase(Installer.this.languageCode)) continue;
                            string = Installer.this.languageCode;
                            break;
                        }
                    }
                }
                if (string == null) {
                    string = "en";
                }
                jDLocale2 = SubConfiguration.getConfig("LOCALE").getGenericProperty("LOCALE4", JDL.getInstance(string));
                JDL.setLocale(jDLocale2);
                JPanel jPanel = Installer.this.getInstallerPanel();
                JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]"));
                jPanel.add(jPanel2);
                jPanel2.add((Component)Factory.createHeader((String)JDL.L("gui.config.gui.language", "Language"), (ImageIcon)JDTheme.II("gui.splash.languages", 24, 24)), "growx,pushx");
                final JList jList = new JList(new AbstractListModel(){
                    private static final long serialVersionUID = -7645376943352687975L;
                    private ArrayList<JDLocale> ids;

                    private ArrayList<JDLocale> getIds() {
                        if (this.ids == null) {
                            this.ids = JDL.getLocaleIDs();
                        }
                        return this.ids;
                    }

                    @Override
                    public Object getElementAt(int n) {
                        return this.getIds().get(n);
                    }

                    @Override
                    public int getSize() {
                        return this.getIds().size();
                    }
                });
                jPanel2.add((Component)new JScrollPane(jList), "growx,pushx,gapleft 40,gapright 10");
                jList.setSelectionMode(0);
                jList.setSelectedValue(jDLocale2, true);
                jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        JDL.setConfigLocale((JDLocale)jList.getSelectedValue());
                        JDL.setLocale(JDL.getConfigLocale());
                        SubConfiguration.getConfig("LOCALE").save();
                        Installer.this.dlFolder = Installer.this.br.getCurrentPath();
                        dialog.dispose();
                        Installer.this.showConfig();
                    }
                });
                jPanel2.add((Component)Factory.createHeader((String)JDL.L("gui.config.general.downloaddirectory", "Download directory"), (ImageIcon)JDTheme.II("gui.images.taskpanes.download", 24, 24)), " growx,pushx,gaptop 10");
                BrowseFile browseFile = new BrowseFile();
                Installer.this.br = browseFile;
                jPanel2.add((Component)browseFile, "growx,pushx,gapleft 40,gapright 10");
                Installer.this.br.setFileSelectionMode(1);
                jPanel2.add((Component)new JSeparator(), "growx,pushx,gaptop 5");
                if (Installer.this.dlFolder != null) {
                    Installer.this.br.setCurrentPath(Installer.this.dlFolder);
                } else if (OSDetector.isMac()) {
                    Installer.this.br.setCurrentPath(new File(String.valueOf(System.getProperty("user.home")) + "/Downloads"));
                } else if (OSDetector.isWindows() && new File(String.valueOf(System.getProperty("user.home")) + "/Downloads").exists()) {
                    Installer.this.br.setCurrentPath(new File(String.valueOf(System.getProperty("user.home")) + "/Downloads"));
                } else if (OSDetector.isWindows() && new File(String.valueOf(System.getProperty("user.home")) + "/Download").exists()) {
                    Installer.this.br.setCurrentPath(new File(String.valueOf(System.getProperty("user.home")) + "/Download"));
                } else {
                    Installer.this.br.setCurrentPath(JDUtilities.getResourceFile("downloads"));
                }
                new ContainerDialog(4, JDL.L("installer.gui.title", "JDownloader Installation"), jPanel, JDImage.getImage((String)"logo/jd_logo_54_54"), null, null){
                    private static final long serialVersionUID = 4685519683324833575L;

                    protected void packed() {
                        dialog = this;
                        this.setSize(550, 400);
                        this.setAlwaysOnTop(true);
                    }

                    protected void setReturnValue(boolean bl) {
                        super.setReturnValue(bl);
                        if (bl) {
                            JDUtilities.getConfiguration().setProperty("DOWNLOAD_DIRECTORY", Installer.this.br.getCurrentPath());
                        } else {
                            JDUtilities.getConfiguration().setProperty("DOWNLOAD_DIRECTORY", null);
                        }
                    }
                };
                return null;
            }
        }.waitForEDT();
    }

    public static void installFirefoxAddon() {
        File file = JDUtilities.getResourceFile("tools/flashgot.xpi");
        LocalBrowser.openinFirefox((String)file.getAbsolutePath());
    }

    public JPanel getInstallerPanel() {
        Object object;
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 10,wrap 1", "[grow,fill]", "[][grow,fill]"));
        JLabel jLabel = new JLabel(JDL.L("installer.gui.message", "After Installation, JDownloader will update to the latest version."));
        if (OSDetector.getOSID() == 1 || OSDetector.getOSID() == 8) {
            object = JDUtilities.getResourceFile("downloads").getParent().substring(3).toLowerCase();
            if (!JDUtilities.getResourceFile("uninstall.exe").exists() && (((String)object).startsWith("programme\\") || ((String)object).startsWith("program files\\"))) {
                jLabel.setText(JDL.LF("installer.vistaDir.warning", "Warning! JD is installed in %s. This causes errors.", JDUtilities.getResourceFile("downloads")));
                jLabel.setForeground(Color.RED);
                jLabel.setBackground(Color.RED);
            }
            if (!JDUtilities.getResourceFile("tools/tinyupdate.jar").canWrite()) {
                jLabel.setText(JDL.LF("installer.nowriteDir.warning", "Warning! JD cannot write to %s. Check rights!", JDUtilities.getResourceFile("downloads")));
                jLabel.setForeground(Color.RED);
                jLabel.setBackground(Color.RED);
            }
        }
        jPanel.add((Component)jLabel, "pushx,growx,split 2");
        object = jLabel.getFont();
        object = ((Font)object).deriveFont(((Font)object).getStyle() ^ 1);
        jLabel.setFont((Font)object);
        try {
            jPanel.add((Component)new JLabel(JDImage.getScaledImageIcon((BufferedImage)JDImage.getImage((String)"logo/jd_logo_54_54"), (int)32, (int)32)), "alignx right");
        }
        catch (Exception exception) {
            System.err.println("DEVELOPER WARNING! Please copy trunk/ressourcen/jd  to home/.jd_home/jd");
        }
        return jPanel;
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

