/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import jd.Main;
import jd.controlling.JDController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.laf.LookAndFeelController;
import jd.nutils.nativeintegration.ScreenDevices;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;

public class SplashScreen
implements ControlListener {
    public static final int SPLASH_FINISH = 0;
    public static final int SPLASH_PROGRESS = 1;
    private ImageIcon image;
    private JLabel label;
    private JWindow window;
    private int x;
    private int y;
    private JProgressBar progress;
    private String curString = "";
    private GraphicsDevice gd = null;

    public SplashScreen(JDController jDController) throws IOException, AWTException {
        Object object;
        LookAndFeelController.setUIManager();
        this.image = new ImageIcon(JDTheme.I("gui.splash"));
        try {
            object = GUIUtils.getConfig().getProperty("LOCATION_OF_MAINFRAME");
            if (object != null && object instanceof Point) {
                Point point = (Point)object;
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                this.gd = ScreenDevices.getGraphicsDeviceforPoint((Point)point);
            } else {
                this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
        }
        catch (Exception exception) {
            this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        object = this.gd.getDefaultConfiguration().getBounds();
        int n = (int)((Rectangle)object).getWidth();
        int n2 = (int)((Rectangle)object).getHeight();
        this.x = n / 2 - this.image.getIconWidth() / 2;
        this.y = n2 / 2 - this.image.getIconHeight() / 2;
        this.initGui();
        jDController.addControlListener(this);
    }

    private void initGui() {
        GraphicsConfiguration graphicsConfiguration = this.gd.getDefaultConfiguration();
        this.label = new JLabel();
        this.label.setIcon(this.image);
        this.window = new JWindow(graphicsConfiguration);
        this.window.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[grow,fill]0[]"));
        this.window.setAlwaysOnTop(true);
        this.window.setSize(this.image.getIconWidth(), this.image.getIconHeight());
        this.label.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.window.add(this.label);
        this.progress = new JProgressBar();
        this.window.add((Component)this.progress, "hidemode 3,height 20!");
        this.progress.setVisible(true);
        this.progress.setIndeterminate(true);
        this.window.pack();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        this.window.setLocation(rectangle.x + this.x, rectangle.y + this.y);
        this.window.setVisible(true);
    }

    private void finish() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                SplashScreen.this.window.dispose();
                return null;
            }
        }.start();
    }

    private void incProgress() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                SplashScreen.this.progress.setStringPainted(true);
                SplashScreen.this.progress.setString(SplashScreen.this.curString);
                return null;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.getID() == 1) {
            if (controlEvent.getParameter() != null && controlEvent.getParameter() instanceof String) {
                String string = this.curString;
                synchronized (string) {
                    this.curString = (String)controlEvent.getParameter();
                }
            }
            this.incProgress();
        } else if (controlEvent.getID() == 30 && controlEvent.getSource() instanceof Main) {
            JDUtilities.getController().removeControlListener(this);
            this.finish();
        } else if (controlEvent.getID() == 0) {
            JDUtilities.getController().removeControlListener(this);
            this.finish();
        }
    }
}

