/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnector
implements Serializable {
    private static final long serialVersionUID = 8074213660382482620L;
    private static Logger logger = JDLogger.getLogger();
    private static String configpath = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/config/";
    private HashMap<String, Object> dbdata = new HashMap();
    public static final Object LOCK = new Object();
    private static boolean dbshutdown = false;
    private static Connection con = null;

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver").newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public static boolean isDatabaseShutdown() {
        return dbshutdown;
    }

    public DatabaseConnector() throws SQLException {
        if (con != null) {
            return;
        }
        logger.finer("Loading database");
        if (new File(String.valueOf(configpath) + "database.script").exists() && !this.checkDatabaseHeader()) {
            throw new SQLException("Database broken!");
        }
        con = DriverManager.getConnection("jdbc:hsqldb:file:" + configpath + "database;shutdown=true", "sa", "");
        con.setAutoCommit(true);
        con.createStatement().executeUpdate("SET LOGSIZE 1");
        if (!new File(String.valueOf(configpath) + "database.script").exists()) {
            logger.finer("No CONFIGURATION database found. Creating new one.");
            con.createStatement().executeUpdate("CREATE TABLE config (name VARCHAR(256), obj OTHER)");
            con.createStatement().executeUpdate("CREATE TABLE links (name VARCHAR(256), obj OTHER)");
            PreparedStatement preparedStatement = con.prepareStatement("INSERT INTO config VALUES (?,?)");
            logger.finer("Starting database wrapper");
            String[] stringArray = new File(configpath).list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                try {
                    if (string.endsWith(".cfg")) {
                        logger.finest("Wrapping " + string);
                        Object object = JDIO.loadObject(null, (File)JDUtilities.getResourceFile("config/" + string), (boolean)false);
                        if (object != null) {
                            preparedStatement.setString(1, string.split(".cfg")[0]);
                            preparedStatement.setObject(2, object);
                            preparedStatement.execute();
                        }
                    }
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
                ++n2;
            }
        }
    }

    private boolean checkDatabaseHeader() {
        logger.finer("Checking database");
        File file = new File(String.valueOf(configpath) + "database.script");
        if (!file.exists()) {
            return true;
        }
        boolean bl = true;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                String string = "";
                int n = 0;
                while (n < 7) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        bl = false;
                        break;
                    }
                    switch (n) {
                        case 0: {
                            if (string.equals("CREATE SCHEMA PUBLIC AUTHORIZATION DBA")) break;
                            bl = false;
                            break;
                        }
                        case 1: {
                            if (string.equals("CREATE MEMORY TABLE CONFIG(NAME VARCHAR(256),OBJ OBJECT)")) break;
                            bl = false;
                            break;
                        }
                        case 2: {
                            if (string.equals("CREATE MEMORY TABLE LINKS(NAME VARCHAR(256),OBJ OBJECT)")) break;
                            bl = false;
                            break;
                        }
                        case 3: {
                            if (string.equals("CREATE USER SA PASSWORD \"\"")) break;
                            bl = false;
                            break;
                        }
                        case 4: {
                            if (string.equals("GRANT DBA TO SA")) break;
                            bl = false;
                            break;
                        }
                        case 5: {
                            if (string.equals("SET WRITE_DELAY 10")) break;
                            bl = false;
                            break;
                        }
                        case 6: {
                            if (string.equals("SET SCHEMA PUBLIC")) break;
                            bl = false;
                        }
                    }
                    ++n;
                }
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.matches("INSERT INTO .*? VALUES\\('.*?','.*?'\\)")) continue;
                    bl = false;
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = false;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                bl = false;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException3) {}
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getData(String string) {
        Object object = LOCK;
        synchronized (object) {
            block7: {
                if (!DatabaseConnector.isDatabaseShutdown()) break block7;
                return null;
            }
            Object object2 = null;
            object2 = this.dbdata.get(string);
            try {
                ResultSet resultSet;
                if (object2 == null && (resultSet = con.createStatement().executeQuery("SELECT * FROM config WHERE name = '" + string + "'")).next()) {
                    object2 = resultSet.getObject(2);
                    this.dbdata.put(resultSet.getString(1), object2);
                }
            }
            catch (Exception exception) {
                JDLogger.getLogger().warning("Database not available. Create new one: " + string);
                JDLogger.exception(Level.FINEST, exception);
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SubConfiguration> getSubConfigurationKeys() {
        Object object = LOCK;
        synchronized (object) {
            block9: {
                if (!DatabaseConnector.isDatabaseShutdown()) break block9;
                return null;
            }
            ArrayList<SubConfiguration> arrayList = new ArrayList<SubConfiguration>();
            try {
                ResultSet resultSet = con.createStatement().executeQuery("SELECT * FROM config");
                while (resultSet.next()) {
                    try {
                        SubConfiguration subConfiguration = SubConfiguration.getConfig((String)resultSet.getObject(1));
                        if (subConfiguration.getProperties().size() <= 0) continue;
                        arrayList.add(subConfiguration);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(String string, Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            if (DatabaseConnector.isDatabaseShutdown()) {
                return;
            }
            this.dbdata.put(string, object);
            try {
                ResultSet resultSet = con.createStatement().executeQuery("SELECT COUNT(name) FROM config WHERE name = '" + string + "'");
                resultSet.next();
                if (resultSet.getInt(1) > 0) {
                    PreparedStatement preparedStatement = con.prepareStatement("UPDATE config SET obj = ? WHERE name = '" + string + "'");
                    preparedStatement.setObject(1, object);
                    preparedStatement.execute();
                } else {
                    PreparedStatement preparedStatement = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                    preparedStatement.setString(1, string);
                    preparedStatement.setObject(2, object);
                    preparedStatement.execute();
                }
            }
            catch (Exception exception) {
                try {
                    System.out.println("First save " + string);
                    PreparedStatement preparedStatement = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                    preparedStatement.setString(1, string);
                    preparedStatement.setObject(2, object);
                    preparedStatement.execute();
                }
                catch (Exception exception2) {
                    JDLogger.getLogger().warning("Database save error: " + string);
                    JDLogger.exception(Level.FINEST, exception2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDatabase() {
        Object object = LOCK;
        synchronized (object) {
            if (DatabaseConnector.isDatabaseShutdown()) {
                return;
            }
            try {
                dbshutdown = true;
                con.close();
            }
            catch (SQLException sQLException) {
                JDLogger.exception(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLinks() {
        Object object = LOCK;
        synchronized (object) {
            block6: {
                if (!DatabaseConnector.isDatabaseShutdown()) break block6;
                return null;
            }
            try {
                ResultSet resultSet = con.createStatement().executeQuery("SELECT * FROM links");
                resultSet.next();
                return resultSet.getObject(2);
            }
            catch (Exception exception) {
                JDLogger.exception(Level.FINEST, exception);
                JDLogger.getLogger().warning("Database not available. Create new one: links");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLinks(Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            if (DatabaseConnector.isDatabaseShutdown()) {
                return;
            }
            try {
                if (this.getLinks() == null) {
                    PreparedStatement preparedStatement = con.prepareStatement("INSERT INTO links VALUES (?,?)");
                    preparedStatement.setString(1, "links");
                    preparedStatement.setObject(2, object);
                    preparedStatement.execute();
                } else {
                    PreparedStatement preparedStatement = con.prepareStatement("UPDATE links SET obj=? WHERE name='links'");
                    preparedStatement.setObject(1, object);
                    preparedStatement.execute();
                }
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
    }

    public Connection getDatabaseConnection() {
        return con;
    }
}

