/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import jd.captcha.JACMethod;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import jd.utils.JDUtilities;

public class CaptchaController {
    private String methodname;
    private File captchafile;
    private String explain;
    private String suggest;
    private String host;

    public CaptchaController(String string, String string2, File file, String string3, String string4) {
        this.host = string;
        this.methodname = string2;
        this.captchafile = file;
        this.explain = string4;
        this.suggest = string3;
    }

    private boolean isMethodEnabled() {
        return JDUtilities.getConfiguration() != null && SubConfiguration.getConfig("JAC").getBooleanProperty("CAPTCHA_JAC_DISBALE", false) == false && JACMethod.hasMethod((String)this.methodname);
    }

    public String getCode(int n) {
        if ((n & 1) > 0) {
            return UserIO.getInstance().requestCaptchaDialog(n, this.host, this.methodname, this.captchafile, this.suggest, this.explain);
        }
        if (!this.isMethodEnabled()) {
            if ((n & 2) > 0) {
                return null;
            }
            return UserIO.getInstance().requestCaptchaDialog(n | 1, this.host, this.methodname, this.captchafile, this.suggest, this.explain);
        }
        JAntiCaptcha jAntiCaptcha = new JAntiCaptcha(this.methodname);
        try {
            BufferedImage bufferedImage = ImageIO.read(this.captchafile);
            Captcha captcha = jAntiCaptcha.createCaptcha((Image)bufferedImage);
            String string = jAntiCaptcha.checkCaptcha(this.captchafile, captcha);
            if (jAntiCaptcha.isExtern()) {
                if ((n & 2) == 0 && string == null || string.trim().length() == 0) {
                    string = UserIO.getInstance().requestCaptchaDialog(n | 1, this.host, this.methodname, this.captchafile, this.suggest, this.explain);
                }
                return string;
            }
            LetterComperator[] letterComperatorArray = captcha.getLetterComperators();
            double d = 0.0;
            if (letterComperatorArray == null) {
                d = 100.0;
            } else {
                LetterComperator[] letterComperatorArray2 = letterComperatorArray;
                int n2 = letterComperatorArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    LetterComperator letterComperator = letterComperatorArray2[n3];
                    if (letterComperator == null) {
                        d = 100.0;
                        break;
                    }
                    d = Math.max(d, letterComperator.getValityPercent());
                    ++n3;
                }
            }
            if (d > (double)SubConfiguration.getConfig("JAC").getIntegerProperty("AUTOTRAIN_ERROR_LEVEL", 95)) {
                if ((n & 2) > 0) {
                    return string;
                }
                return UserIO.getInstance().requestCaptchaDialog(n | 1, this.host, this.methodname, this.captchafile, string, this.explain);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

