/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jd.DecryptPluginWrapper;
import jd.HostPluginWrapper;
import jd.config.Property;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.ProgressController;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.JDFlags;
import jd.nutils.encoding.Encoding;
import jd.nutils.encoding.HTMLEntities;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.parser.Regex;
import jd.parser.html.HTMLParser;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributeData
extends Thread {
    private static Logger logger = JDLogger.getLogger();
    private boolean disableDeepEmergencyScan = false;
    private String data;
    private boolean hideGrabber;
    private ArrayList<DownloadLink> linkData;
    private String orgData;
    private boolean filterNormalHTTP = false;
    private ArrayList<String> foundPasswords;
    private boolean autostart = false;

    public DistributeData(String string) {
        super("JD-DistributeData");
        this.data = new String(string);
        this.disableDeepEmergencyScan = true;
        this.foundPasswords = new ArrayList();
    }

    public DistributeData setDisableDeepEmergencyScan(boolean bl) {
        this.disableDeepEmergencyScan = bl;
        return this;
    }

    public DistributeData setHideGrabber(boolean bl) {
        this.hideGrabber = bl;
        return this;
    }

    public DistributeData setAutostart(boolean bl) {
        this.autostart = bl;
        return this;
    }

    public DistributeData(String string, boolean bl) {
        this(string);
        this.hideGrabber = bl;
        this.disableDeepEmergencyScan = true;
    }

    public DistributeData setFilterNormalHTTP(boolean bl) {
        this.filterNormalHTTP = bl;
        return this;
    }

    public static boolean hasPluginFor(String string, boolean bl) {
        String string2 = string;
        if (DecryptPluginWrapper.getDecryptWrapper() == null) {
            return false;
        }
        string2 = string2.replaceAll("jd://", "http://");
        for (DecryptPluginWrapper pluginWrapper : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!pluginWrapper.isEnabled() || !pluginWrapper.canHandle(string2)) continue;
            return true;
        }
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.isEnabled() || !hostPluginWrapper.canHandle(string2)) continue;
            return true;
        }
        string2 = Encoding.urlDecode((String)string2, (boolean)true);
        for (DecryptPluginWrapper decryptPluginWrapper : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!decryptPluginWrapper.isEnabled() || !decryptPluginWrapper.canHandle(string2)) continue;
            return true;
        }
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.isEnabled() || !hostPluginWrapper.canHandle(string2)) continue;
            return true;
        }
        if (!bl) {
            string2 = string2.replaceAll("http://", "httpviajd://");
            string2 = string2.replaceAll("https://", "httpsviajd://");
            for (DecryptPluginWrapper decryptPluginWrapper : DecryptPluginWrapper.getDecryptWrapper()) {
                if (!decryptPluginWrapper.isEnabled() || !decryptPluginWrapper.canHandle(string2)) continue;
                return true;
            }
            for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
                if (!hostPluginWrapper.isEnabled() || !hostPluginWrapper.canHandle(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean deepDecrypt(ArrayList<DownloadLink> arrayList) {
        if (arrayList.isEmpty()) {
            return false;
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        Jobber jobber = new Jobber(4);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            class DThread
            extends Thread
            implements JDRunnable {
                private DownloadLink link = null;
                private final /* synthetic */ ArrayList val$newdecryptedLinks;
                private final /* synthetic */ ArrayList val$notdecryptedLinks;

                public DThread(DownloadLink downloadLink, ArrayList arrayList, ArrayList arrayList2) {
                    this.val$newdecryptedLinks = arrayList;
                    this.val$notdecryptedLinks = arrayList2;
                    this.link = downloadLink;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = this.link.getDownloadURL();
                    if (string != null) {
                        string = HTMLParser.getHttpLinkList(string);
                        try {
                            string = URLDecoder.decode(string, "UTF-8");
                        }
                        catch (Exception exception) {
                            logger.warning("text not url decodeable");
                        }
                    }
                    boolean bl = false;
                    for (DecryptPluginWrapper object : DecryptPluginWrapper.getDecryptWrapper()) {
                        if (!object.isEnabled() || !object.canHandle(string)) continue;
                        try {
                            Serializable serializable;
                            PluginForDecrypt pluginForDecrypt = (PluginForDecrypt)object.getNewPluginInstance();
                            CryptedLink[] cryptedLinkArray = pluginForDecrypt.getDecryptableLinks(string);
                            string = pluginForDecrypt.cutMatches(string);
                            CryptedLink[] cryptedLinkArray2 = cryptedLinkArray;
                            int iterator = cryptedLinkArray.length;
                            int downloadLink = 0;
                            while (downloadLink < iterator) {
                                serializable = cryptedLinkArray2[downloadLink];
                                ((CryptedLink)serializable).setDecrypterPassword(this.link.getDecrypterPassword());
                                ++downloadLink;
                            }
                            cryptedLinkArray2 = cryptedLinkArray;
                            iterator = cryptedLinkArray.length;
                            downloadLink = 0;
                            while (downloadLink < iterator) {
                                serializable = cryptedLinkArray2[downloadLink];
                                ((Property)serializable).setProperties(this.link.getProperties());
                                ++downloadLink;
                            }
                            serializable = pluginForDecrypt.decryptLinks(cryptedLinkArray);
                            bl = true;
                            if (serializable == null || ((ArrayList)serializable).size() <= 0) break;
                            Iterator iterator2 = ((ArrayList)serializable).iterator();
                            while (iterator2.hasNext()) {
                                DownloadLink arrayList = (DownloadLink)iterator2.next();
                                arrayList.addSourcePluginPasswordList(this.link.getSourcePluginPasswordList());
                            }
                            ArrayList arrayList = this.val$newdecryptedLinks;
                            synchronized (arrayList) {
                                this.val$newdecryptedLinks.addAll(serializable);
                                break;
                            }
                        }
                        catch (Exception pluginForDecrypt) {
                            JDLogger.exception(pluginForDecrypt);
                        }
                    }
                    if (!bl) {
                        ArrayList arrayList = this.val$notdecryptedLinks;
                        synchronized (arrayList) {
                            this.val$notdecryptedLinks.add(this.link);
                        }
                    }
                }

                public void go() throws Exception {
                    this.run();
                }
            }
            DThread dThread = new DThread(arrayList.get(n), arrayList2, arrayList3);
            jobber.add((JDRunnable)dThread);
            --n;
        }
        n = jobber.getJobsAdded();
        jobber.start();
        while (jobber.getJobsFinished() != n) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jobber.stop();
        arrayList.clear();
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        return arrayList2.size() > 0;
    }

    public ArrayList<DownloadLink> findLinks() {
        ArrayList<DownloadLink> arrayList = this.quickHosterCheck(this.data);
        this.foundPasswords.addAll(HTMLParser.findPasswords(this.data));
        if (arrayList != null && arrayList.size() == 1) {
            if (!arrayList.get(0).getPlugin().getWrapper().isEnabled() || LinkGrabberController.isFiltered(arrayList.get(0))) {
                arrayList.clear();
            } else {
                arrayList.get(0).addSourcePluginPasswordList(this.foundPasswords);
                return arrayList;
            }
        }
        this.data = HTMLEntities.unhtmlentities((String)this.data);
        this.data = this.data.replaceAll("jd://", "http://");
        arrayList = this.findLinksIntern();
        this.data = Encoding.urlDecode((String)this.data, (boolean)true);
        arrayList.addAll(this.findLinksIntern());
        if (!this.filterNormalHTTP) {
            this.data = this.data.replaceAll("--CUT--", "\n");
            this.data = this.data.replaceAll("http://", "httpviajd://");
            this.data = this.data.replaceAll("https://", "httpsviajd://");
            arrayList.addAll(this.findLinksIntern());
            this.data = this.data.replaceAll("httpviajd://", "http://");
            this.data = this.data.replaceAll("httpsviajd://", "https://");
        }
        for (DownloadLink downloadLink : arrayList) {
            downloadLink.addSourcePluginPasswordList(this.foundPasswords);
        }
        return arrayList;
    }

    private ArrayList<DownloadLink> quickHosterCheck(String string) {
        String string2 = string.toLowerCase();
        if (new Regex(string, " http").count() > 1) {
            return null;
        }
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            String string3;
            Pattern pattern = hostPluginWrapper.getPattern();
            if (!string2.contains(hostPluginWrapper.getHost().toLowerCase()) || (string3 = new Regex(string, pattern).getMatch(-1)) == null || !string3.equals(string) && (string3.length() <= 10 + hostPluginWrapper.getHost().length() || !string.startsWith(string3) || string3.length() * 2 <= string.length())) continue;
            DownloadLink downloadLink = new DownloadLink((PluginForHost)hostPluginWrapper.getNewPluginInstance(), null, hostPluginWrapper.getHost(), Encoding.urlDecode((String)string3, (boolean)true), true);
            ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
            arrayList.add(downloadLink);
            return arrayList;
        }
        return null;
    }

    private ArrayList<DownloadLink> findLinksIntern() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<HostPluginWrapper> arrayList2 = HostPluginWrapper.getHostWrapper();
        if (arrayList2.size() == 0) {
            return new ArrayList<DownloadLink>();
        }
        this.orgData = this.data;
        this.reformDataString();
        ArrayList<DownloadLink> arrayList3 = this.handleDecryptPlugins();
        for (DownloadLink downloadLink : arrayList3) {
            if (this.checkdecrypted(arrayList2, arrayList, downloadLink) || downloadLink.getDownloadURL() == null || this.filterNormalHTTP) continue;
            downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceAll("http://", "httpviajd://"));
            downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceAll("https://", "httpsviajd://"));
            this.checkdecrypted(arrayList2, arrayList, downloadLink);
        }
        this.useHoster(arrayList);
        return arrayList;
    }

    private boolean checkdecrypted(ArrayList<HostPluginWrapper> arrayList, ArrayList<DownloadLink> arrayList2, DownloadLink downloadLink) {
        if (downloadLink.getDownloadURL() == null) {
            return true;
        }
        if (LinkGrabberController.isFiltered(downloadLink)) {
            return true;
        }
        boolean bl = false;
        for (HostPluginWrapper hostPluginWrapper : arrayList) {
            try {
                if (!hostPluginWrapper.canHandle(downloadLink.getDownloadURL())) continue;
                ArrayList<DownloadLink> arrayList3 = hostPluginWrapper.getPlugin().getDownloadLinks(downloadLink.getDownloadURL(), downloadLink.getFilePackage() != FilePackage.getDefaultFilePackage() ? downloadLink.getFilePackage() : null);
                bl = true;
                if (!hostPluginWrapper.isEnabled()) break;
                int n = 0;
                while (n < arrayList3.size()) {
                    arrayList3.get(n).addSourcePluginPasswordList(downloadLink.getSourcePluginPasswordList());
                    arrayList3.get(n).setSourcePluginComment(downloadLink.getSourcePluginComment());
                    arrayList3.get(n).setName(downloadLink.getName());
                    arrayList3.get(n).setFinalFileName(downloadLink.getFinalFileName());
                    arrayList3.get(n).setBrowserUrl(downloadLink.getBrowserUrl());
                    if (downloadLink.isAvailabilityStatusChecked()) {
                        arrayList3.get(n).setAvailable(downloadLink.isAvailable());
                    }
                    arrayList3.get(n).setProperties(downloadLink.getProperties());
                    arrayList3.get(n).getLinkStatus().setStatusText(downloadLink.getLinkStatus().getStatusString());
                    arrayList3.get(n).setDownloadSize(downloadLink.getDownloadSize());
                    arrayList3.get(n).setSubdirectory(downloadLink);
                    ++n;
                }
                arrayList2.addAll(arrayList3);
                break;
            }
            catch (Exception exception) {
                logger.severe("Decrypter/Search Fehler: " + exception.getMessage());
                JDLogger.exception(exception);
            }
        }
        return bl;
    }

    private void useHoster(ArrayList<DownloadLink> arrayList) {
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.canHandle(hostPluginWrapper.isAcceptOnlyURIs() ? this.data : this.orgData)) continue;
            ArrayList<DownloadLink> arrayList2 = hostPluginWrapper.getPlugin().getDownloadLinks(hostPluginWrapper.isAcceptOnlyURIs() ? this.data : this.orgData, null);
            if (hostPluginWrapper.isAcceptOnlyURIs()) {
                this.data = hostPluginWrapper.getPlugin().cutMatches(this.data);
            } else {
                this.orgData = hostPluginWrapper.getPlugin().cutMatches(this.orgData);
            }
            if (!hostPluginWrapper.isEnabled()) continue;
            for (DownloadLink downloadLink : arrayList2) {
                if (LinkGrabberController.isFiltered(downloadLink)) continue;
                arrayList.add(downloadLink);
            }
        }
    }

    public ArrayList<DownloadLink> getLinkData() {
        return this.linkData;
    }

    private ArrayList<DownloadLink> handleDecryptPlugins() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        if (DecryptPluginWrapper.getDecryptWrapper() == null) {
            return arrayList;
        }
        Jobber jobber = new Jobber(4);
        for (DecryptPluginWrapper decryptPluginWrapper : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!decryptPluginWrapper.isEnabled() || !decryptPluginWrapper.canHandle(decryptPluginWrapper.isAcceptOnlyURIs() ? this.data : this.orgData)) continue;
            try {
                PluginForDecrypt pluginForDecrypt = (PluginForDecrypt)decryptPluginWrapper.getNewPluginInstance();
                CryptedLink[] cryptedLinkArray = pluginForDecrypt.getDecryptableLinks(pluginForDecrypt.isAcceptOnlyURIs() ? this.data : this.orgData);
                if (pluginForDecrypt.isAcceptOnlyURIs()) {
                    this.data = pluginForDecrypt.cutMatches(this.data);
                } else {
                    this.orgData = pluginForDecrypt.cutMatches(this.orgData);
                }
                class DThread
                extends Thread
                implements JDRunnable {
                    private CryptedLink[] decryptableLinks = null;
                    private PluginForDecrypt plg = null;
                    private final /* synthetic */ ArrayList val$decryptedLinks;

                    public DThread(PluginForDecrypt pluginForDecrypt, CryptedLink[] cryptedLinkArray, ArrayList arrayList) {
                        this.val$decryptedLinks = arrayList;
                        this.decryptableLinks = cryptedLinkArray;
                        this.plg = pluginForDecrypt;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ArrayList<DownloadLink> arrayList = this.plg.decryptLinks(this.decryptableLinks);
                        ArrayList arrayList2 = this.val$decryptedLinks;
                        synchronized (arrayList2) {
                            this.val$decryptedLinks.addAll(arrayList);
                        }
                    }

                    public void go() throws Exception {
                        this.run();
                    }
                }
                DThread dThread = new DThread(pluginForDecrypt, cryptedLinkArray, arrayList);
                jobber.add((JDRunnable)dThread);
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
        int n = jobber.getJobsAdded();
        jobber.start();
        while (jobber.getJobsFinished() != n) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jobber.stop();
        int n2 = 1;
        while (this.deepDecrypt(arrayList)) {
            logger.info("Deepdecrypt depths: " + ++n2);
        }
        return arrayList;
    }

    private void reformDataString() {
        String string;
        if (this.data != null && (string = HTMLParser.getHttpLinkList(this.data)).length() != 0) {
            this.data = string;
        }
    }

    @Override
    public void run() {
        String[] stringArray;
        if (this.data == null || this.data.length() == 0 || !new Regex(this.data, "://.*?\\.").matches()) {
            return;
        }
        ArrayList<DownloadLink> arrayList = this.findLinks();
        if (arrayList.size() == 0 && !this.disableDeepEmergencyScan && (stringArray = HTMLParser.getHttpLinks(this.data, null)).length > 0) {
            String string;
            String string2 = "\r\n";
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray2[n2];
                string2 = String.valueOf(string2) + string + "\r\n";
                ++n2;
            }
            logger.warning("No supported links found -> search for links in source code of all urls");
            string = JDL.L("gui.dialog.deepdecrypt.title", "Deep decryption?");
            String string3 = JDL.LF("gui.dialog.deepdecrypt.message", "JDownloader has not found anything on %s\r\n-------------------------------\r\nJD now loads this page to look for further links.", String.valueOf(string2));
            n = UserIO.getInstance().requestConfirmDialog(0, string, string3, JDTheme.II("gui.images.search", 32, 32), JDL.L("gui.btn_continue", "Continue"), null);
            if (JDFlags.hasAllFlags((int)n, (int[])new int[]{2})) {
                this.data = DistributeData.getLoadLinkString(this.data);
                arrayList = this.findLinks();
            }
        }
        Collections.sort(arrayList);
        LinkGrabberController.getInstance().addLinks(arrayList, this.hideGrabber, this.autostart);
    }

    public void setLinkData(ArrayList<DownloadLink> arrayList) {
        this.linkData = arrayList;
    }

    public String getRestData() {
        return this.data;
    }

    public static void loadAndParse(String string) {
        JDController.getInstance().distributeLinks(DistributeData.getLoadLinkString(string));
    }

    private static String getLoadLinkString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = HTMLParser.getHttpLinks(string, null);
        ProgressController progressController = new ProgressController(JDL.LF("gui.addurls.progress", "Parse %s URL(s)", stringArray.length), stringArray.length);
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            Browser browser = new Browser();
            try {
                String[] stringArray3;
                new URL(string2);
                progressController.setStatusText(JDL.LF("gui.addurls.progress.get", "Parse %s URL(s). Get %s links", stringArray.length, string2));
                browser.getPage(string2);
                String[] stringArray4 = stringArray3 = HTMLParser.getHttpLinks("" + browser, string2);
                int n4 = stringArray3.length;
                int n5 = 0;
                while (n5 < n4) {
                    String string3 = stringArray4[n5];
                    ++n;
                    stringBuffer.append("\r\n" + string3);
                    ++n5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            progressController.setStatusText(JDL.LF("gui.addurls.progress.found", "Parse %s URL(s). Found %s links", stringArray.length, n));
            progressController.increase(1L);
            ++n3;
        }
        JDLogger.getLogger().info("Found Links" + stringBuffer);
        progressController.doFinalize(2000L);
        return stringBuffer.toString();
    }
}

