/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.SingleDownloadController;
import jd.controlling.reconnect.Reconnecter;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadWatchDog
implements ControlListener,
DownloadControllerListener {
    private static final String JDL_PREFIX = "jd.controlling.DownloadWatchDog.";
    private boolean aborted = false;
    private boolean aborting;
    private HashMap<DownloadLink, SingleDownloadController> DownloadControllers = new HashMap();
    private ArrayList<DownloadLink> stopMarkTracker = new ArrayList();
    private HashMap<String, Long> HOST_IPBLOCK = new HashMap();
    private HashMap<String, Long> HOST_TEMP_UNAVAIL = new HashMap();
    private static final Object nostopMark = new Object();
    private static final Object hiddenstopMark = new Object();
    private Object stopMark = nostopMark;
    private HashMap<String, Integer> activeHosts = new HashMap();
    private Logger logger = JDLogger.getLogger();
    private boolean paused = false;
    private int totalSpeed = 0;
    private Thread watchDogThread = null;
    private DownloadController dlc = null;
    private int activeDownloads = 0;
    private int downloadssincelastStart = 0;
    private static final Object StartStopSync = new Object();
    private static final Object CountLOCK = new Object();
    private static final Object DownloadLOCK = new Object();
    private STATE downloadStatus = STATE.NOT_RUNNING;
    private static DownloadWatchDog INSTANCE;

    public static synchronized DownloadWatchDog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadWatchDog();
        }
        return INSTANCE;
    }

    public int getActiveDownloads() {
        return this.activeDownloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIPBlockWaittime(String string, long l) {
        HashMap<String, Long> hashMap = this.HOST_IPBLOCK;
        synchronized (hashMap) {
            if (l <= 0L) {
                this.HOST_IPBLOCK.remove(string);
            } else {
                this.HOST_IPBLOCK.put(string, System.currentTimeMillis() + l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTempUnavailWaittime(String string, long l) {
        HashMap<String, Long> hashMap = this.HOST_TEMP_UNAVAIL;
        synchronized (hashMap) {
            if (l <= 0L) {
                this.HOST_TEMP_UNAVAIL.remove(string);
            } else {
                this.HOST_TEMP_UNAVAIL.put(string, System.currentTimeMillis() + l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetIPBlockWaittime(String string) {
        HashMap<String, Long> hashMap = this.HOST_IPBLOCK;
        synchronized (hashMap) {
            if (string != null) {
                this.HOST_IPBLOCK.remove(string);
            } else {
                this.HOST_IPBLOCK.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTempUnavailWaittime(String string) {
        HashMap<String, Long> hashMap = this.HOST_TEMP_UNAVAIL;
        synchronized (hashMap) {
            if (string != null) {
                this.HOST_TEMP_UNAVAIL.remove(string);
            } else {
                this.HOST_TEMP_UNAVAIL.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingTempUnavailWaittime(String string) {
        HashMap<String, Long> hashMap = this.HOST_TEMP_UNAVAIL;
        synchronized (hashMap) {
            block4: {
                if (this.HOST_TEMP_UNAVAIL.containsKey(string)) break block4;
                return 0L;
            }
            return Math.max(0L, this.HOST_TEMP_UNAVAIL.get(string) - System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingIPBlockWaittime(String string) {
        HashMap<String, Long> hashMap = this.HOST_IPBLOCK;
        synchronized (hashMap) {
            block4: {
                if (this.HOST_IPBLOCK.containsKey(string)) break block4;
                return 0L;
            }
            return Math.max(0L, this.HOST_IPBLOCK.get(string) - System.currentTimeMillis());
        }
    }

    private DownloadWatchDog() {
        this.dlc = DownloadController.getInstance();
        this.dlc.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopMark(Object object) {
        Object object2 = this.stopMark;
        synchronized (object2) {
            if (object == null) {
                object = nostopMark;
            }
            if (this.stopMark instanceof DownloadLink) {
                DownloadController.getInstance().fireDownloadLinkUpdate(this.stopMark);
            } else if (this.stopMark instanceof FilePackage) {
                DownloadController.getInstance().fireDownloadLinkUpdate(((FilePackage)this.stopMark).get(0));
            }
            this.stopMark = object;
            if (object instanceof DownloadLink) {
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setSelected(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setEnabled(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setIcon("gui.images.stopmark.enabled");
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setToolTipText(JDL.LF("jd.controlling.DownloadWatchDog.stopmark.downloadlink", "Stopmark is set on Downloadlink: %s", ((DownloadLink)object).getName()));
                DownloadController.getInstance().fireDownloadLinkUpdate(object);
            } else if (object instanceof FilePackage) {
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setSelected(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setEnabled(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setIcon("gui.images.stopmark.enabled");
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setToolTipText(JDL.LF("jd.controlling.DownloadWatchDog.stopmark.filepackage", "Stopmark is set on Filepackage: %s", ((FilePackage)object).getName()));
                DownloadController.getInstance().fireDownloadLinkUpdate(((FilePackage)object).get(0));
            } else if (object == hiddenstopMark) {
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setSelected(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setEnabled(true);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setIcon("gui.images.stopmark.enabled");
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setToolTipText(JDL.L("jd.controlling.DownloadWatchDog.stopmark.set", "Stopmark is still set!"));
            } else if (object == nostopMark) {
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setSelected(false);
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setIcon("gui.images.stopmark.disabled");
                ActionController.getToolBarAction((String)"toolbar.control.stopmark").setToolTipText(JDL.L("jd.gui.swing.jdgui.actions.actioncontroller.toolbar.control.stopmark.tooltip", "Stop after current Downloads"));
            }
        }
    }

    public boolean isStopMarkSet() {
        return this.stopMark != nostopMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleStopMark(Object object) {
        Object object2 = this.stopMark;
        synchronized (object2) {
            if (object == null || object == this.stopMark) {
                this.setStopMark(nostopMark);
                return;
            }
            this.setStopMark(object);
        }
    }

    public Object getStopMark() {
        return this.stopMark;
    }

    public boolean isStopMark(Object object) {
        return this.stopMark == object;
    }

    public STATE getDownloadStatus() {
        return this.downloadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDownloads() {
        if (this.downloadStatus == STATE.STOPPING || this.downloadStatus == STATE.RUNNING) {
            return false;
        }
        Object object = StartStopSync;
        synchronized (object) {
            block7: {
                if (this.downloadStatus != STATE.NOT_RUNNING) break block7;
                this.downloadStatus = STATE.RUNNING;
                this.stopMarkTracker.clear();
                if (this.reachedStopMark()) {
                    this.setStopMark(nostopMark);
                }
                if (SubConfiguration.getConfig("DOWNLOAD").getProperty("MAXSPEEDBEFOREPAUSE", null) != null) {
                    this.logger.info("Restoring old speedlimit");
                    SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("MAXSPEEDBEFOREPAUSE", 0));
                    SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", null);
                    SubConfiguration.getConfig("DOWNLOAD").save();
                }
                this.logger.info("DownloadWatchDog: start");
                JDController.getInstance().fireControlEvent(new ControlEvent(this, 13, this));
                this.downloadssincelastStart = 0;
                this.startWatchDogThread();
                return true;
            }
            return false;
        }
    }

    public void toggleStartStop() {
        if (!this.startDownloads()) {
            this.stopDownloads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopDownloads() {
        if (this.downloadStatus == STATE.STOPPING || this.downloadStatus == STATE.NOT_RUNNING) {
            return false;
        }
        Object object = StartStopSync;
        synchronized (object) {
            block7: {
                if (this.downloadStatus != STATE.RUNNING) break block7;
                this.downloadStatus = STATE.STOPPING;
                this.aborted = true;
                if (this.getActiveDownloads() > 0) {
                    this.abort();
                }
                this.clearDownloadListStatus();
                this.pauseDownloads(false);
                if (this.reachedStopMark()) {
                    this.setStopMark(nostopMark);
                }
                this.logger.info("DownloadWatchDog: stop");
                this.downloadStatus = STATE.NOT_RUNNING;
                JDController.getInstance().fireControlEvent(new ControlEvent(this, 6, this));
                return true;
            }
            return false;
        }
    }

    void abort() {
        this.aborting = true;
        this.logger.finer("Abort all active Downloads");
        ProgressController progressController = new ProgressController("Termination", this.activeDownloads);
        progressController.setStatusText("Stopping all downloads " + this.activeDownloads);
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<SingleDownloadController> arrayList2 = new ArrayList<SingleDownloadController>(this.DownloadControllers.values());
        for (SingleDownloadController singleDownloadController : arrayList2) {
            arrayList.add(singleDownloadController.abortDownload().getDownloadLink());
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(arrayList);
        boolean bl = true;
        block3: while (true) {
            Object object;
            progressController.setStatusText("Stopping all downloads " + this.activeDownloads);
            bl = true;
            ArrayList<DownloadLink> arrayList3 = new ArrayList<DownloadLink>(this.DownloadControllers.keySet());
            Iterator<Object> iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                object = (DownloadLink)iterator.next();
                if (!((DownloadLink)object).getLinkStatus().isPluginActive()) continue;
                bl = false;
                break;
            }
            if (bl) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            arrayList2 = new ArrayList<SingleDownloadController>(this.DownloadControllers.values());
            iterator = arrayList2.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                object = (SingleDownloadController)iterator.next();
                arrayList.add(((SingleDownloadController)object).abortDownload().getDownloadLink());
            }
            break;
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(arrayList);
        progressController.doFinalize();
        this.aborting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDownloadListStatus() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>(this.DownloadControllers.keySet());
        for (DownloadLink serializable2 : arrayList) {
            this.deactivateDownload(serializable2);
        }
        this.resetIPBlockWaittime(null);
        this.resetTempUnavailWaittime(null);
        ArrayList<FilePackage> arrayList2 = this.dlc.getPackages();
        ArrayList<FilePackage> serializable3 = arrayList2;
        synchronized (serializable3) {
            for (FilePackage filePackage : arrayList2) {
                arrayList = filePackage.getDownloadLinkList();
                int n = 0;
                while (n < arrayList.size()) {
                    DownloadLink downloadLink = arrayList.get(n);
                    downloadLink.setAborted(false);
                    downloadLink.getLinkStatus().resetStatus(0x422000, 32, 2);
                    ++n;
                }
            }
        }
        DownloadController.getInstance().fireGlobalUpdate();
    }

    public ArrayList<DownloadLink> getRunningDownloads() {
        return new ArrayList<DownloadLink>(this.DownloadControllers.keySet());
    }

    @Override
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.getID() == 4 && controlEvent.getSource() instanceof PluginForHost) {
            this.deactivateDownload(((SingleDownloadController)controlEvent.getParameter()).getDownloadLink());
        }
    }

    public int activeDownloadControllers() {
        return this.DownloadControllers.keySet().size();
    }

    public int getDownloadssincelastStart() {
        return this.downloadssincelastStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int activeDownloadsbyHosts(PluginForHost pluginForHost) {
        HashMap<String, Integer> hashMap = this.activeHosts;
        synchronized (hashMap) {
            if (this.activeHosts.containsKey(pluginForHost.getHost())) {
                return this.activeHosts.get(pluginForHost.getHost());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDownload(DownloadLink downloadLink, SingleDownloadController singleDownloadController) {
        HashMap<String, Integer> hashMap;
        Object object = this.DownloadControllers;
        synchronized (object) {
            if (this.DownloadControllers.containsKey(downloadLink)) {
                return;
            }
            this.DownloadControllers.put(downloadLink, singleDownloadController);
            hashMap = CountLOCK;
            synchronized (hashMap) {
                ++this.activeDownloads;
                ++this.downloadssincelastStart;
            }
        }
        object = downloadLink.getHost();
        hashMap = this.activeHosts;
        synchronized (hashMap) {
            if (this.activeHosts.containsKey(object)) {
                int n = this.activeHosts.get(object);
                this.activeHosts.put((String)object, n + 1);
            } else {
                this.activeHosts.put((String)object, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDownload(DownloadLink downloadLink) {
        HashMap<String, Integer> hashMap;
        Object object = this.DownloadControllers;
        synchronized (object) {
            if (!this.DownloadControllers.containsKey(downloadLink)) {
                this.logger.severe("Link not in ControllerList!");
                return;
            }
            this.DownloadControllers.remove(downloadLink);
            hashMap = CountLOCK;
            synchronized (hashMap) {
                --this.activeDownloads;
            }
        }
        object = downloadLink.getHost();
        hashMap = this.activeHosts;
        synchronized (hashMap) {
            if (this.activeHosts.containsKey(object)) {
                int n = this.activeHosts.get(object);
                if (n - 1 < 0) {
                    this.logger.severe("WatchDog Counter MissMatch!!");
                    this.activeHosts.remove(object);
                } else {
                    this.activeHosts.put((String)object, n - 1);
                }
            } else {
                this.logger.severe("WatchDog Counter MissMatch!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink getNextDownloadLink() {
        Object object = DownloadLOCK;
        synchronized (object) {
            block9: {
                if (!this.reachedStopMark()) break block9;
                return null;
            }
            DownloadLink downloadLink3 = null;
            DownloadLink downloadLink2 = null;
            try {
                for (FilePackage filePackage : this.dlc.getPackages()) {
                    for (DownloadLink downloadLink3 : filePackage.getDownloadLinkList()) {
                        if (!downloadLink3.isEnabled() || downloadLink3.getLinkStatus().hasStatus(2048) || !downloadLink3.getPlugin().isPremiumDownload() && (this.getRemainingIPBlockWaittime(downloadLink3.getHost()) > 0L || this.getRemainingTempUnavailWaittime(downloadLink3.getHost()) > 0L) || this.isDownloadLinkActive(downloadLink3) || downloadLink3.getLinkStatus().isPluginActive() || !downloadLink3.getLinkStatus().isStatus(1)) continue;
                        int n = this.getSimultanDownloadNumPerHost();
                        if (this.activeDownloadsbyHosts(downloadLink3.getPlugin()) >= downloadLink3.getPlugin().getMaxSimultanDownloadNum() || this.activeDownloadsbyHosts(downloadLink3.getPlugin()) >= n || !downloadLink3.getPlugin().getWrapper().isEnabled()) continue;
                        if (downloadLink2 == null) {
                            downloadLink2 = downloadLink3;
                            continue;
                        }
                        if (downloadLink3.getPriority() <= downloadLink2.getPriority()) continue;
                        downloadLink2 = downloadLink3;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return downloadLink2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ArrayList<DownloadLink> arrayList) {
        Object object = StartStopSync;
        synchronized (object) {
            if (this.downloadStatus != STATE.RUNNING) {
                return;
            }
        }
        object = DownloadLOCK;
        synchronized (object) {
            for (DownloadLink downloadLink : arrayList) {
                int n;
                if (downloadLink.getLinkStatus().hasStatus(2048) || !downloadLink.getPlugin().isPremiumDownload() && (this.getRemainingIPBlockWaittime(downloadLink.getHost()) > 0L || this.getRemainingTempUnavailWaittime(downloadLink.getHost()) > 0L) || this.isDownloadLinkActive(downloadLink) || downloadLink.getLinkStatus().isPluginActive() || !downloadLink.getLinkStatus().isStatus(1) || (n = this.activeDownloadsbyHosts(downloadLink.getPlugin())) >= downloadLink.getPlugin().getMaxSimultanDownloadNum() || !downloadLink.getPlugin().getWrapper().isEnabled()) continue;
                if (!downloadLink.isEnabled()) {
                    downloadLink.setEnabled(true);
                }
                this.startDownloadThread(downloadLink);
            }
        }
    }

    public int getSimultanDownloadNum() {
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2);
    }

    public int getSimultanDownloadNumPerHost() {
        if (SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN_PER_HOST", 0) == 0) {
            return Integer.MAX_VALUE;
        }
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN_PER_HOST", 0);
    }

    public int getTotalSpeed() {
        if (this.downloadStatus == STATE.NOT_RUNNING) {
            return 0;
        }
        return this.totalSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDownloadLinkActive(DownloadLink downloadLink) {
        HashMap<DownloadLink, SingleDownloadController> hashMap = this.DownloadControllers;
        synchronized (hashMap) {
            return this.DownloadControllers.containsKey(downloadLink);
        }
    }

    public void pauseDownloads(boolean bl) {
        if (this.paused == bl) {
            return;
        }
        this.paused = bl;
        if (bl) {
            ActionController.getToolBarAction((String)"toolbar.control.pause").setSelected(true);
            SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0));
            SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10));
            this.logger.info("Pause enabled: Reducing downloadspeed to " + SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10) + " kb/s");
        } else {
            SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("MAXSPEEDBEFOREPAUSE", 0));
            SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", null);
            this.logger.info("Pause disabled: Switch back to old downloadspeed");
            ActionController.getToolBarAction((String)"toolbar.control.pause").setSelected(false);
        }
        SubConfiguration.getConfig("DOWNLOAD").save();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean newDLStartAllowed() {
        return !this.paused && !Reconnecter.isReconnecting() && !this.aborting && !this.aborted && !Reconnecter.isReconnectPrefered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startWatchDogThread() {
        if (this.watchDogThread == null || !this.watchDogThread.isAlive()) {
            Object object = CountLOCK;
            synchronized (object) {
                this.activeDownloads = 0;
            }
            this.watchDogThread = new Thread(){

                public void run() {
                    JDUtilities.getController().addControlListener(INSTANCE);
                    this.setName("DownloadWatchDog");
                    ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
                    DownloadWatchDog.this.aborted = false;
                    DownloadWatchDog.this.aborting = false;
                    int n = 5;
                    int n2 = 0;
                    int n3 = 0;
                    while (!DownloadWatchDog.this.aborted) {
                        Reconnecter.setReconnectRequested(false);
                        boolean bl = false;
                        boolean bl2 = false;
                        ArrayList<FilePackage> arrayList2 = DownloadWatchDog.this.dlc.getPackages();
                        n2 = 0;
                        n3 = 0;
                        arrayList.clear();
                        try {
                            for (FilePackage filePackage : arrayList2) {
                                ArrayList<DownloadLink> arrayList3 = filePackage.getDownloadLinkList();
                                int n4 = 0;
                                while (n4 < arrayList3.size()) {
                                    DownloadLink downloadLink = arrayList3.get(n4);
                                    if (downloadLink.getPlugin() != null) {
                                        LinkStatus linkStatus = downloadLink.getLinkStatus();
                                        if (!linkStatus.hasStatus(262144) && downloadLink.isEnabled()) {
                                            if (linkStatus.hasStatus(2048) || linkStatus.hasStatus(4096)) {
                                                if (linkStatus.getRemainingWaittime() == 0L) {
                                                    linkStatus.reset();
                                                } else if (linkStatus.getRemainingWaittime() > 0L) {
                                                    bl2 = true;
                                                    arrayList.add(downloadLink);
                                                }
                                            } else if (linkStatus.hasStatus(16)) {
                                                if (linkStatus.getRemainingWaittime() == 0L) {
                                                    linkStatus.reset();
                                                } else if (linkStatus.getRemainingWaittime() > 0L) {
                                                    Reconnecter.setReconnectRequested(true);
                                                    arrayList.add(downloadLink);
                                                }
                                            } else if (DownloadWatchDog.this.getRemainingTempUnavailWaittime(downloadLink.getHost()) > 0L && !downloadLink.getLinkStatus().isFinished()) {
                                                bl2 = true;
                                                arrayList.add(downloadLink);
                                            } else if (DownloadWatchDog.this.getRemainingIPBlockWaittime(downloadLink.getHost()) > 0L && !downloadLink.getLinkStatus().isFinished()) {
                                                Reconnecter.setReconnectRequested(true);
                                                arrayList.add(downloadLink);
                                            }
                                        } else if (downloadLink.isEnabled()) {
                                            if (linkStatus.isPluginActive()) {
                                                bl = true;
                                            }
                                            if (linkStatus.hasStatus(1024)) {
                                                ++n3;
                                                n2 += downloadLink.getDownloadSpeed();
                                            }
                                        }
                                    }
                                    ++n4;
                                }
                            }
                            Reconnecter.doReconnectIfRequested(false);
                            if (n3 > 0) {
                                arrayList2 = DownloadWatchDog.this.dlc.getPackages();
                                for (FilePackage filePackage : arrayList2) {
                                    Iterator<DownloadLink> iterator = filePackage.getDownloadLinkList().iterator();
                                    int n5 = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0) * 1024;
                                    if (n5 == 0) {
                                        n5 = Integer.MAX_VALUE;
                                    }
                                    int n6 = n5 - n2;
                                    DownloadWatchDog.this.totalSpeed = n2;
                                    while (iterator.hasNext()) {
                                        DownloadLink downloadLink = iterator.next();
                                        if (!downloadLink.getLinkStatus().hasStatus(1024)) continue;
                                        downloadLink.setSpeedLimit(downloadLink.getDownloadSpeed() + n6 / n3);
                                    }
                                }
                            } else {
                                DownloadWatchDog.this.totalSpeed = 0;
                            }
                            if (arrayList.size() > 0) {
                                DownloadController.getInstance().fireDownloadLinkUpdate(arrayList);
                            }
                            int n7 = 0;
                            if (DownloadWatchDog.this.activeDownloads < DownloadWatchDog.this.getSimultanDownloadNum() && !DownloadWatchDog.this.reachedStopMark()) {
                                n7 = DownloadWatchDog.this.setDownloadActive();
                            }
                            if (n7 == 0) {
                                if (!(bl2 || bl || Reconnecter.isReconnectRequested() || DownloadWatchDog.this.getNextDownloadLink() != null || DownloadWatchDog.this.activeDownloads != 0)) {
                                    if (DownloadWatchDog.this.newDLStartAllowed()) {
                                        DownloadWatchDog.this.logger.info(String.valueOf(--n) + "rounds left to start new downloads");
                                    }
                                    if (n == 0) {
                                        DownloadWatchDog.this.totalSpeed = 0;
                                        break;
                                    }
                                }
                            } else {
                                n = 5;
                            }
                        }
                        catch (Exception exception) {
                            JDLogger.exception(exception);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DownloadWatchDog.this.aborted = true;
                    while (DownloadWatchDog.this.aborting) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, this));
                    JDUtilities.getController().removeControlListener(INSTANCE);
                    DownloadWatchDog.getInstance().stopDownloads();
                }
            };
            this.watchDogThread.start();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int setDownloadActive() {
        var2_1 = 0;
        if (this.newDLStartAllowed()) ** GOTO lbl9
        return var2_1;
        while ((var1_2 = this.getNextDownloadLink()) != null && var1_2 == this.getNextDownloadLink()) {
            if (this.reachedStopMark()) {
                return var2_1;
            }
            this.startDownloadThread(var1_2);
            ++var2_1;
lbl9:
            // 2 sources

            if (this.activeDownloads < this.getSimultanDownloadNum()) continue;
        }
        return var2_1;
    }

    public void setTotalSpeed(int n) {
        this.totalSpeed = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reachedStopMark() {
        Object object = this.stopMark;
        synchronized (object) {
            DownloadLink downloadLink;
            if (this.stopMark == hiddenstopMark) {
                return true;
            }
            if (this.stopMark instanceof DownloadLink) {
                if (this.stopMarkTracker.contains(this.stopMark)) {
                    return true;
                }
                DownloadLink downloadLink2 = (DownloadLink)this.stopMark;
                if (!downloadLink2.isEnabled()) {
                    return true;
                }
                return downloadLink2.getLinkStatus().isFinished();
                {
                }
            }
            if (!(this.stopMark instanceof FilePackage)) {
                return false;
            }
            Iterator<DownloadLink> iterator = ((FilePackage)this.stopMark).getDownloadLinkList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.stopMarkTracker.contains(downloadLink = iterator.next()) || downloadLink.isEnabled() && downloadLink.getLinkStatus().isFinished());
            return false;
        }
    }

    private void startDownloadThread(DownloadLink downloadLink) {
        downloadLink.getLinkStatus().setActive(true);
        SingleDownloadController singleDownloadController = new SingleDownloadController(downloadLink);
        this.logger.info("Start new Download: " + downloadLink.getHost());
        this.activateDownload(downloadLink, singleDownloadController);
        if (!this.stopMarkTracker.contains(downloadLink)) {
            this.stopMarkTracker.add(downloadLink);
        }
        singleDownloadController.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent downloadControllerEvent) {
        switch (downloadControllerEvent.getID()) {
            case 3: 
            case 5: {
                Object object = this.stopMark;
                synchronized (object) {
                    if (this.stopMark == downloadControllerEvent.getParameter()) {
                        this.setStopMark(hiddenstopMark);
                    }
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        RUNNING,
        NOT_RUNNING,
        STOPPING;

    }
}

