/*
 * Decompiled with CFR 0.152.
 */
package jd.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private Matcher matcher;

    public Regex(Matcher matcher) {
        if (matcher == null) {
            return;
        }
        this.matcher = matcher;
    }

    public Regex(Object object, Pattern pattern) {
        this(object.toString(), pattern);
    }

    public Regex(Object object, String string) {
        this(object.toString(), string);
    }

    public Regex(Object object, String string, int n) {
        this(object.toString(), string, n);
    }

    public Regex(String string, Pattern pattern) {
        if (string == null || pattern == null) {
            return;
        }
        this.matcher = pattern.matcher(string);
    }

    public Regex(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.matcher = Pattern.compile(string2, 34).matcher(string);
    }

    public Regex(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return;
        }
        this.matcher = Pattern.compile(string2, n).matcher(string);
    }

    public int count() {
        if (this.matcher == null) {
            return 0;
        }
        this.matcher.reset();
        int n = 0;
        Matcher matcher = this.matcher;
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public String getMatch(int n) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        this.matcher.reset();
        if (matcher.find()) {
            return matcher.group(n + 1);
        }
        return null;
    }

    public Matcher getMatcher() {
        if (this.matcher == null) {
            return null;
        }
        this.matcher.reset();
        return this.matcher;
    }

    public String[][] getMatches() {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        this.matcher.reset();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (matcher.find()) {
            String[] stringArray;
            int n = matcher.groupCount();
            int n2 = 1;
            if (n == 0) {
                stringArray = new String[n + 1];
                n2 = 0;
            } else {
                stringArray = new String[n];
            }
            int n3 = n2;
            while (n3 <= n) {
                stringArray[n3 - n2] = matcher.group(n3);
                ++n3;
            }
            arrayList.add(stringArray);
        }
        if (arrayList.size() == 0) {
            return new String[0][];
        }
        return (String[][])arrayList.toArray((T[])new String[0][]);
    }

    public String[] getColumn(int n) {
        if (this.matcher == null) {
            return null;
        }
        ++n;
        Matcher matcher = this.matcher;
        this.matcher.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean matches() {
        if (this.matcher == null) {
            return false;
        }
        this.matcher.reset();
        return this.matcher.find();
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[][] stringArray = this.getMatches();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                stringBuilder.append("match[");
                stringBuilder.append(n);
                stringBuilder.append("][");
                stringBuilder.append(n2);
                stringBuilder.append("] = ");
                stringBuilder.append(stringArray[n][n2]);
                stringBuilder.append(System.getProperty("line.separator"));
                ++n2;
            }
            ++n;
        }
        this.matcher.reset();
        return stringBuilder.toString();
    }

    public static long getMilliSeconds(String string) {
        String[][] stringArray = new Regex(string, "([\\d]+) ?[\\.|\\,|\\:] ?([\\d]+)").getMatches();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new Regex(string, Pattern.compile("([\\d]+)")).getMatches();
        }
        if (stringArray == null || stringArray.length == 0) {
            return -1L;
        }
        double d = 0.0;
        if (stringArray[0].length == 1) {
            d = Double.parseDouble(stringArray[0][0]);
        }
        if (stringArray[0].length == 2) {
            d = Double.parseDouble(String.valueOf(stringArray[0][0]) + "." + stringArray[0][1]);
        }
        d = Regex.matches((Object)string, Pattern.compile("(h|st)", 2)) ? (d *= 3600000.0) : (Regex.matches((Object)string, Pattern.compile("(m)", 2)) ? (d *= 60000.0) : (d *= 1000.0));
        return Math.round(d);
    }

    public static long getMilliSeconds(String string, String string2, Locale locale) {
        SimpleDateFormat simpleDateFormat = locale != null ? new SimpleDateFormat(string2, locale) : new SimpleDateFormat(string2);
        if (string == null) {
            return -1L;
        }
        try {
            Date date = simpleDateFormat.parse(string);
            return date.getTime();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return -1L;
        }
    }

    public String getMatch(int n, int n2) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        this.matcher.reset();
        ++n;
        int n3 = 0;
        while (matcher.find()) {
            if (n3 == n2) {
                return matcher.group(n);
            }
            ++n3;
        }
        return null;
    }

    public String[] getRow(int n) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        this.matcher.reset();
        int n2 = 0;
        while (matcher.find()) {
            if (n2 == n) {
                int n3 = matcher.groupCount();
                String[] stringArray = new String[n3];
                int n4 = 1;
                while (n4 <= n3) {
                    stringArray[n4 - 1] = matcher.group(n4);
                    ++n4;
                }
                return stringArray;
            }
            ++n2;
        }
        return null;
    }

    public static int getMilliSeconds2(String string) {
        String string2 = new Regex(string, "(\\d*?)[ ]*m").getMatch(0);
        String string3 = new Regex(string, "(\\d*?)[ ]*(h|st)").getMatch(0);
        String string4 = new Regex(string, "(\\d*?)[ ]*se").getMatch(0);
        if (string2 == null) {
            string2 = "0";
        }
        if (string3 == null) {
            string3 = "0";
        }
        if (string4 == null) {
            string4 = "0";
        }
        return Integer.parseInt(string3) * 60 * 60 * 1000 + Integer.parseInt(string2) * 60 * 1000 + Integer.parseInt(string4) * 1000;
    }

    public static String escape(String string) {
        char[] cArray = new char[]{'(', '[', '{', '\\', '^', '-', '$', '|', ']', '}', ')', '?', '*', '+', '.'};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            char[] cArray2 = cArray;
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c2 = cArray2[n3];
                if (c == c2) {
                    stringBuilder.append('\\');
                    break;
                }
                ++n3;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString().trim();
    }

    public static String[] getLines(String string) {
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split("[\r\n]{1,2}");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].trim();
            ++n;
        }
        return stringArray2;
    }

    public static long getSize(String string) {
        String[][] stringArray = new Regex(string, Pattern.compile("([\\d]+)[\\.|\\,|\\:]([\\d]+)", 2)).getMatches();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new Regex(string, Pattern.compile("([\\d]+)", 2)).getMatches();
        }
        if (stringArray == null || stringArray.length == 0) {
            return -1L;
        }
        double d = 0.0;
        if (stringArray[0].length == 1) {
            d = Double.parseDouble(stringArray[0][0]);
        }
        if (stringArray[0].length == 2) {
            d = Double.parseDouble(String.valueOf(stringArray[0][0]) + "." + stringArray[0][1]);
        }
        if (Regex.matches((Object)string, Pattern.compile("(gb|gbyte|gig)", 2))) {
            d *= 1.073741824E9;
        } else if (Regex.matches((Object)string, Pattern.compile("(mb|mbyte|megabyte)", 2))) {
            d *= 1048576.0;
        } else if (Regex.matches((Object)string, Pattern.compile("(kb|kbyte|kilobyte)", 2))) {
            d *= 1024.0;
        }
        return Math.round(d);
    }

    public static boolean matches(Object object, Pattern pattern) {
        return new Regex(object, pattern).matches();
    }

    public static boolean matches(Object object, String string) {
        return new Regex(object, string).matches();
    }
}

