/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jd.controlling.JDLogger;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.SimpleXmlSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath {
    HtmlCleaner cleaner;
    private Document doc;
    private String query;
    private String source;
    private javax.xml.xpath.XPath xpath;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public XPath(String string, String string2) {
        this(string, string2, true);
    }

    public XPath(String string) {
        this(string, null, true);
    }

    public XPath(String string, String string2, boolean bl) {
        Object object;
        try {
            if (bl) {
                this.cleaner = new HtmlCleaner();
                object = this.cleaner.getProperties();
                object.setNamespacesAware(true);
                this.doc = new DomSerializer((CleanerProperties)object, true).createDOM(this.cleaner.clean(string));
            } else {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(false);
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                this.doc = documentBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes())));
            }
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        catch (SAXException sAXException) {
            JDLogger.exception(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            JDLogger.exception(parserConfigurationException);
        }
        object = XPathFactory.newInstance();
        this.xpath = ((XPathFactory)object).newXPath();
        this.source = string;
        this.query = string2;
    }

    public String getAttributeMatch(String string, int n) {
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(this.query).evaluate(this.doc, XPathConstants.NODESET);
            int n2 = 0;
            int n3 = 0;
            while (n3 < nodeList.item(0).getAttributes().getLength()) {
                if (nodeList.item(0).getAttributes().item(n3).getNodeValue().equals(string)) {
                    n2 = n3;
                }
                ++n3;
            }
            return nodeList.item(n).getAttributes().item(n2).getNodeValue();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public ArrayList<String> getAttributeMatches(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(this.query).evaluate(this.doc, XPathConstants.NODESET);
            int n = 0;
            int n2 = 0;
            while (n2 < nodeList.item(0).getAttributes().getLength()) {
                if (nodeList.item(0).getAttributes().item(n2).getNodeValue().equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < nodeList.getLength()) {
                arrayList.add(nodeList.item(n2).getAttributes().item(n).getNodeValue());
                ++n2;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return arrayList;
    }

    public int getCount() {
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(this.query).evaluate(this.doc, XPathConstants.NODESET);
            return nodeList.getLength();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return 0;
        }
    }

    public String getFirstAttributeMatch(String string) {
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(this.query).evaluate(this.doc, XPathConstants.NODESET);
            int n = 0;
            int n2 = 0;
            while (n2 < nodeList.item(0).getAttributes().getLength()) {
                if (nodeList.item(0).getAttributes().item(n2).getNodeValue().equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            return nodeList.item(0).getAttributes().item(n).getNodeValue();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public String getFirstMatch() {
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(String.valueOf(this.query) + "/text()").evaluate(this.doc, XPathConstants.NODESET);
            return nodeList.item(0).getNodeValue();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public String getFirstMatch(int n) {
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(String.valueOf(this.query) + "/text()").evaluate(this.doc, XPathConstants.NODESET);
            return nodeList.item(n).getNodeValue();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public ArrayList<String> getMatches() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            NodeList nodeList = (NodeList)this.xpath.compile(String.valueOf(this.query) + "/text()").evaluate(this.doc, XPathConstants.NODESET);
            int n = 0;
            while (n < nodeList.getLength()) {
                arrayList.add(nodeList.item(n).getNodeValue());
                ++n;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return arrayList;
    }

    public String showTransformation() {
        try {
            this.cleaner = new HtmlCleaner();
            CleanerProperties cleanerProperties = this.cleaner.getProperties();
            return new SimpleXmlSerializer(cleanerProperties).getXmlAsString(this.cleaner.clean(this.source));
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
            return null;
        }
    }
}

