/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.plugins.AccountInfo;

public class Account
extends Property {
    private static final long serialVersionUID = -7578649066389032068L;
    private String user;
    private String pass;
    private boolean enabled = true;
    private boolean valid = true;
    private transient long tmpDisabledIntervalv3 = 600000L;
    private transient boolean tempDisabled = false;
    private transient long tmpDisabledTime = 0L;
    private transient String hoster = null;
    private AccountInfo accinfo = null;
    private long updatetime = 0L;

    public Account(String string, String string2) {
        this.user = string;
        this.pass = string2;
        this.hoster = null;
        this.setTmpDisabledIntervalv3(600000L);
        if (this.user != null) {
            this.user = this.user.trim();
        }
        if (this.pass != null) {
            this.pass = this.pass.trim();
        }
        this.valid = true;
    }

    public String getPass() {
        if (this.pass != null) {
            return this.pass.trim();
        }
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public long lastUpdateTime() {
        return this.updatetime;
    }

    public void setUpdateTime(long l) {
        this.updatetime = l;
    }

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String string) {
        this.hoster = string;
    }

    public AccountInfo getAccountInfo() {
        return this.accinfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accinfo = accountInfo;
    }

    public String getUser() {
        if (this.user != null) {
            return this.user.trim();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.tmpDisabledIntervalv3 = 600000L;
        this.tempDisabled = false;
        this.hoster = null;
        this.tmpDisabledTime = 0L;
    }

    public boolean isTempDisabled() {
        if (this.tempDisabled && System.currentTimeMillis() - this.tmpDisabledTime > this.getTmpDisabledIntervalv3()) {
            this.tempDisabled = false;
        }
        return this.tempDisabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        if (bl && !this.isValid()) {
            this.setUpdateTime(0L);
        }
        AccountInfo accountInfo = this.accinfo;
        if (bl && accountInfo != null && accountInfo.isExpired()) {
            this.setUpdateTime(0L);
        }
        AccountController.getInstance().throwUpdateEvent(null, this);
    }

    public void setPass(String string) {
        if (this.pass == string) {
            return;
        }
        if (string != null) {
            string = string.trim();
        }
        if (this.pass != null && this.pass.equals(string)) {
            return;
        }
        this.pass = string;
        this.accinfo = null;
        this.setUpdateTime(0L);
        AccountController.getInstance().throwUpdateEvent(null, this);
    }

    public void setTempDisabled(boolean bl) {
        if (this.tempDisabled == bl) {
            return;
        }
        this.tmpDisabledTime = System.currentTimeMillis();
        this.tempDisabled = bl;
        AccountController.getInstance().throwUpdateEvent(null, this);
    }

    public void setUser(String string) {
        if (this.user == string) {
            return;
        }
        if (string != null) {
            string = string.trim();
        }
        if (this.user != null && this.user.equals(string)) {
            return;
        }
        this.user = string;
        this.accinfo = null;
        this.setUpdateTime(0L);
        AccountController.getInstance().throwUpdateEvent(null, this);
    }

    public String toString() {
        return String.valueOf(this.user) + ":" + this.pass + " " + this.enabled + " " + super.toString();
    }

    public long getTmpDisabledIntervalv3() {
        return this.tmpDisabledIntervalv3;
    }

    public void setTmpDisabledIntervalv3(long l) {
        this.tmpDisabledIntervalv3 = l;
    }

    public boolean equals(Account account) {
        if (account == this) {
            return true;
        }
        if (this.user == null) {
            if (account.user != null) {
                return false;
            }
        } else {
            if (account.user == null) {
                return false;
            }
            if (!this.user.trim().equalsIgnoreCase(account.user.trim())) {
                return false;
            }
        }
        if (this.pass == null) {
            if (account.pass != null) {
                return false;
            }
        } else {
            if (account.pass == null) {
                return false;
            }
            if (!this.pass.trim().equalsIgnoreCase(account.pass.trim())) {
                return false;
            }
        }
        return true;
    }
}

