/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.Serializable;
import java.lang.reflect.Field;
import javax.swing.ImageIcon;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;
import jd.nutils.JDFlags;
import jd.plugins.DownloadLink;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class LinkStatus
implements Serializable {
    public static final int TODO = 1;
    public static final int FINISHED = 2;
    public static final int ERROR_RETRY = 4;
    public static final int ERROR_CAPTCHA = 8;
    public static final int ERROR_IP_BLOCKED = 16;
    public static final int ERROR_FILE_NOT_FOUND = 32;
    public static final int ERROR_PREMIUM = 256;
    public static final int ERROR_DOWNLOAD_INCOMPLETE = 512;
    public static final int DOWNLOADINTERFACE_IN_PROGRESS = 1024;
    public static final int ERROR_TEMPORARILY_UNAVAILABLE = 2048;
    public static final int ERROR_HOSTER_TEMPORARILY_UNAVAILABLE = 4096;
    public static final int ERROR_ALREADYEXISTS = 8192;
    public static final int ERROR_DOWNLOAD_FAILED = 16384;
    public static final int ERROR_NO_CONNECTION = 32768;
    public static final int ERROR_AGB_NOT_SIGNED = 65536;
    public static final int ERROR_FATAL = 131072;
    public static final int PLUGIN_IN_PROGRESS = 262144;
    public static final int ERROR_LINK_IN_PROGRESS = 524288;
    public static final int ERROR_TIMEOUT_REACHED = 0x100000;
    public static final int ERROR_LOCAL_IO = 0x200000;
    public static final int ERROR_PLUGIN_DEFECT = 0x400000;
    public static final int WAITING_USERIO = 0x800000;
    public static final int ERROR_POST_PROCESS = 0x1000000;
    public static final int VALUE_FAILED_CHUNK = 0x4000000;
    public static final int VALUE_FAILED_HASH = 0x8000000;
    public static final int PLUGIN_ACTIVE = 0x20000000;
    public static final int ERROR_PLUGIN_NEEDED = 0x40000000;
    private static final long serialVersionUID = 3885661829491436448L;
    private DownloadLink downloadLink;
    private String errorMessage;
    private int lastestStatus = 1;
    private int status = 1;
    private String statusText = null;
    private long totalWaitTime = 0L;
    private long value = 0L;
    private long waitUntil = 0L;
    private int retryCount = 0;
    private ImageIcon statusIcon;

    public LinkStatus(DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void addStatus(int n) {
        this.status |= n;
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{2}) && this.downloadLink.getFinishedDate() == -1L) {
            this.downloadLink.setFinishedDate(System.currentTimeMillis());
        }
        this.lastestStatus = n;
    }

    public void exceptionToErrorMessage(Exception exception) {
        this.setErrorMessage(JDUtilities.convertExceptionReadable(exception));
    }

    private String getDefaultErrorMessage() {
        switch (this.lastestStatus) {
            case 4: {
                return JDL.L("downloadlink.status.error.retry", "Unknown error, retrying");
            }
            case 0x400000: {
                return JDL.L("downloadlink.status.error.defect", "Plugin outdated");
            }
            case 0x40000000: {
                return JDL.L("downloadlink.status.error.no_plugin_available", "No plugin available");
            }
            case 512: {
                return JDL.L("downloadlink.status.incomplete", "Incomplete");
            }
            case 65536: {
                return JDL.L("downloadlink.status.error.agb_not_signed", "TOCs not signed");
            }
            case 8192: {
                return JDL.L("downloadlink.status.error.file_exists", "File exists");
            }
            case 8: {
                return JDL.L("downloadlink.status.error.captcha_wrong", "Captcha wrong");
            }
            case 16384: {
                return JDL.L("downloadlink.status.error.downloadfailed", "Download failed");
            }
            case 16: {
                return JDL.L("downloadlink.status.error.download_limit", "Download Limit reached");
            }
            case 32: {
                return JDL.L("downloadlink.status.error.file_not_found", "File not found");
            }
            case 0x1000000: {
                return JDL.L("downloadlink.status.error.post_process", "Processing error");
            }
            case 32768: 
            case 0x100000: {
                return JDL.L("downloadlink.status.error.no_connection", "No Connection");
            }
            case 256: {
                return JDL.L("downloadlink.status.error.premium", "Premium Error");
            }
            case 2048: {
                return JDL.L("downloadlink.status.error.temp_unavailable", "Temp. unavailable");
            }
            case 4096: {
                return JDL.L("downloadlink.status.error.hoster_temp_unavailable", "Download from this host is currently not possible");
            }
            case 131072: {
                return JDL.L("downloadlink.status.error.fatal", "Fatal Error");
            }
            case 0x800000: {
                return JDL.L("downloadlink.status.waitinguserio", "Waiting for user input");
            }
        }
        return null;
    }

    public String getLongErrorMessage() {
        String string = this.errorMessage;
        if (string == null) {
            string = this.getDefaultErrorMessage();
        }
        if (string == null) {
            string = JDL.L("downloadlink.status.error_unexpected", "Unexpected Error");
        }
        return string;
    }

    public int getLatestStatus() {
        return this.lastestStatus;
    }

    public void setLatestStatus(int n) {
        this.lastestStatus = n;
    }

    public long getRemainingWaittime() {
        long l = System.currentTimeMillis();
        long l2 = this.waitUntil - l;
        return Math.max(0L, l2);
    }

    public String getStatusString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasStatus(0x1000000)) {
            if (this.getErrorMessage() != null) {
                stringBuilder.append(this.getErrorMessage());
            } else if (this.getStatusText() != null) {
                stringBuilder.append(this.getStatusText());
            } else {
                stringBuilder.append(JDL.L("gui.downloadlink.errorpostprocess3", "[convert failed]"));
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(2)) {
            return this.getStatusText() != null ? " > " + this.getStatusText() : "";
        }
        if (this.hasStatus(32)) {
            return this.getLongErrorMessage();
        }
        if (!this.downloadLink.isEnabled() && !this.hasStatus(2)) {
            if (this.downloadLink.isAborted() && (this.statusText == null || this.statusText.trim().length() == 0)) {
                stringBuilder.append(JDL.L("gui.downloadlink.aborted", "[interrupted]")).append(' ');
            } else if (this.downloadLink.isAborted()) {
                stringBuilder.append(this.statusText);
            }
            if (this.errorMessage != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(new char[]{':', ' '});
                }
                stringBuilder.append(this.errorMessage);
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(16) && DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(this.downloadLink.getHost()) > 0L) {
            stringBuilder.append(JDL.LF("gui.download.waittime_status2", "Wait %s", Formatter.formatSeconds((long)(this.getRemainingWaittime() / 1000L))));
            if (this.errorMessage != null) {
                return String.valueOf(this.errorMessage) + " " + stringBuilder.toString();
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(2048) && this.getRemainingWaittime() > 0L) {
            stringBuilder.append(JDL.LF("gui.download.waittime_status2", "Wait %s", Formatter.formatSeconds((long)(this.getRemainingWaittime() / 1000L))));
            if (this.errorMessage != null) {
                return String.valueOf(this.errorMessage) + " " + stringBuilder.toString();
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(4096) && DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(this.downloadLink.getHost()) > 0L) {
            stringBuilder.append(JDL.LF("gui.download.waittime_status2", "Wait %s", Formatter.formatSeconds((long)(this.getRemainingWaittime() / 1000L))));
            if (this.errorMessage != null) {
                return String.valueOf(this.errorMessage) + " " + stringBuilder.toString();
            }
            return stringBuilder.toString();
        }
        if (this.isFailed()) {
            return this.getLongErrorMessage();
        }
        if (this.downloadLink.getPlugin() != null && DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(this.downloadLink.getHost()) > 0L && !this.downloadLink.getLinkStatus().isPluginActive()) {
            return JDL.L("gui.downloadlink.hosterwaittime", "[wait for new ip]");
        }
        if (this.downloadLink.getPlugin() != null && DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(this.downloadLink.getHost()) > 0L && !this.downloadLink.getLinkStatus().isPluginActive()) {
            return JDL.L("gui.downloadlink.hostertempunavail", "[download currently not possible]");
        }
        if (this.downloadLink.getDownloadInstance() == null && this.hasStatus(1024)) {
            this.removeStatus(1024);
        }
        if (this.hasStatus(1024)) {
            int n = this.downloadLink.getDownloadSpeed();
            String string = "(" + this.downloadLink.getDownloadInstance().getChunksDownloading() + "/" + this.downloadLink.getDownloadInstance().getChunkNum() + ")";
            if (n > 0) {
                if (this.downloadLink.getDownloadSize() < 0L) {
                    return String.valueOf(Formatter.formatReadable((long)n)) + "/s " + JDL.L("gui.download.filesize_unknown", "(Filesize unknown)");
                }
                long l = this.downloadLink.getDownloadSize() - this.downloadLink.getDownloadCurrent();
                long l2 = l / (long)n;
                return "ETA " + Formatter.formatSeconds((long)((int)l2)) + " @ " + Formatter.formatReadable((long)n) + "/s " + string;
            }
            return String.valueOf(JDL.L("gui.download.create_connection", "Connecting...")) + string;
        }
        if (this.downloadLink.isAvailabilityStatusChecked() && !this.downloadLink.isAvailable()) {
            return JDL.L("gui.download.onlinecheckfailed", "[Not available]");
        }
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.statusText != null) {
            return this.statusText;
        }
        return "";
    }

    public long getTotalWaitTime() {
        return this.totalWaitTime;
    }

    public long getValue() {
        return this.value;
    }

    private boolean hasOnlyStatus(int n) {
        return (this.status & ~n) == 0;
    }

    public boolean hasStatus(int n) {
        return (this.status & n) != 0;
    }

    public boolean isFailed() {
        return !this.hasOnlyStatus(545530899);
    }

    public boolean isPluginActive() {
        return this.hasStatus(0x20000000);
    }

    public boolean isPluginInProgress() {
        return this.hasStatus(262144);
    }

    public boolean isStatus(int n) {
        return this.status == n;
    }

    public void removeStatus(int n) {
        int n2 = -1;
        this.status &= (n2 &= ~n);
    }

    public void reset() {
        this.setStatus(1);
        this.setLatestStatus(1);
        this.errorMessage = null;
        this.statusText = null;
        this.retryCount = 0;
        this.value = 0L;
        this.resetWaitTime();
    }

    public void resetWaitTime() {
        this.totalWaitTime = 0L;
        this.waitUntil = 0L;
    }

    public void setErrorMessage(String string) {
        if (this.downloadLink.isAborted() && string != null) {
            return;
        }
        this.errorMessage = string;
    }

    public void setInProgress(boolean bl) {
        if (bl) {
            this.addStatus(262144);
        } else {
            this.removeStatus(262144);
        }
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.addStatus(0x20000000);
        } else {
            this.removeStatus(0x20000000);
        }
    }

    public void setStatus(int n) {
        if (n == 2) {
            this.resetWaitTime();
        }
        this.status = n;
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{2}) && this.downloadLink.getFinishedDate() == -1L) {
            this.downloadLink.setFinishedDate(System.currentTimeMillis());
        }
        this.lastestStatus = n;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setWaitTime(long l) {
        this.waitUntil = System.currentTimeMillis() + l;
        this.totalWaitTime = l;
    }

    public static String toString(int n) {
        Field[] fieldArray;
        Field[] fieldArray2 = fieldArray = LinkStatus.class.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray2[n3];
            if (field.getModifiers() == 25) {
                try {
                    int n4 = field.getInt(null);
                    if (n4 == n) {
                        return field.getName();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JDLogger.exception(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    JDLogger.exception(illegalAccessException);
                }
            }
            ++n3;
        }
        return null;
    }

    public String toString() {
        Object object;
        Field[] fieldArray = this.getClass().getDeclaredFields();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(Formatter.fillString((String)Integer.toBinaryString(this.status), (String)"0", (String)"", (int)32)) + " <Statuscode\r\n");
        String string = "";
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = fieldArray2[n2];
            if (((Field)object).getModifiers() == 25) {
                try {
                    int n3 = ((Field)object).getInt(this);
                    if (this.hasStatus(n3)) {
                        if (n3 == this.lastestStatus) {
                            string = "latest: " + ((Field)object).getName() + "\r\n";
                        }
                        stringBuilder.append(String.valueOf(Formatter.fillString((String)Integer.toBinaryString(n3), (String)"0", (String)"", (int)32)) + " |" + ((Field)object).getName() + "\r\n");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JDLogger.exception(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    JDLogger.exception(illegalAccessException);
                }
            }
            ++n2;
        }
        object = new StringBuilder(string);
        ((StringBuilder)object).append(stringBuilder.toString());
        if (this.statusText != null) {
            ((StringBuilder)object).append("StatusText: ").append(this.statusText).append("\r\n");
        }
        if (this.errorMessage != null) {
            ((StringBuilder)object).append("ErrorMessage: ").append(this.errorMessage).append("\r\n");
        }
        return ((StringBuilder)object).toString();
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatusIcon(ImageIcon imageIcon) {
        this.statusIcon = imageIcon;
    }

    public ImageIcon getStatusIcon() {
        return this.statusIcon;
    }

    public boolean isFinished() {
        return this.hasStatus(8192) || this.hasStatus(2);
    }

    public void resetStatus(int ... nArray) {
        int n;
        if (this.downloadLink == null) {
            return;
        }
        int n2 = 1;
        int n3 = 1;
        String string = null;
        String string2 = null;
        int n4 = 0;
        int[] nArray2 = nArray;
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            n = nArray2[n6];
            n4 |= n;
            ++n6;
        }
        nArray2 = nArray;
        n5 = nArray.length;
        n6 = 0;
        while (n6 < n5) {
            n = nArray2[n6];
            if (this.downloadLink.getLinkStatus().hasStatus(n)) {
                n2 = this.downloadLink.getLinkStatus().getStatus();
                n3 = this.downloadLink.getLinkStatus().getLatestStatus();
                string = this.downloadLink.getLinkStatus().getErrorMessage();
                string2 = this.downloadLink.getLinkStatus().getStatusText();
                break;
            }
            ++n6;
        }
        n2 = JDFlags.filterFlags((int)n2, (int)(n4 | 1));
        n3 = JDFlags.filterFlags((int)n3, (int)(n4 | 1));
        this.downloadLink.getLinkStatus().reset();
        this.downloadLink.getLinkStatus().setStatus(n2);
        this.downloadLink.getLinkStatus().setLatestStatus(n3);
        this.downloadLink.getLinkStatus().setErrorMessage(string);
        this.downloadLink.getLinkStatus().setStatusText(string2);
    }
}

