/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.config.ConfigContainer;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.gui.swing.components.ConvertDialog;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterException;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin
implements ActionListener {
    public static final String ACCEPT_LANGUAGE = "de, en-gb;q=0.9, en;q=0.8";
    private boolean acceptOnlyURIs = true;
    protected static Logger logger = JDLogger.getLogger();
    protected final ConfigContainer config;
    protected final PluginWrapper wrapper;
    protected Browser br = new Browser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConvertDialog.ConversionMode showDisplayDialog(ArrayList<ConvertDialog.ConversionMode> arrayList, String string, CryptedLink cryptedLink) throws DecrypterException {
        cryptedLink.getProgressController().setStatusText(JDL.L("gui.linkgrabber.waitinguserio", "Waiting for user input"));
        Object object = JDUtilities.USERIO_LOCK;
        synchronized (object) {
            ConvertDialog.ConversionMode conversionMode = ConvertDialog.displayDialog(arrayList, (String)string);
            cryptedLink.getProgressController().setStatusText(null);
            if (conversionMode == null) {
                throw new DecrypterException(JDL.L("jd.plugins.Plugin.aborted", "Decryption aborted!"));
            }
            return conversionMode;
        }
    }

    public static String getUserInput(String string, CryptedLink cryptedLink) throws DecrypterException {
        String string2 = JDUtilities.getUserInput(string, cryptedLink);
        if (string2 == null) {
            throw new DecrypterException(DecrypterException.PASSWORD);
        }
        return string2;
    }

    public static String getUserInput(String string, DownloadLink downloadLink) throws PluginException {
        String string2 = JDUtilities.getUserInput(string, downloadLink);
        if (string2 == null) {
            throw new PluginException(131072, JDL.L("plugins.errors.wrongpassword", "Password wrong"));
        }
        return string2;
    }

    public static String getUserInput(String string, String string2, CryptedLink cryptedLink) throws DecrypterException {
        String string3 = JDUtilities.getUserInput(string, string2, cryptedLink);
        if (string3 == null) {
            throw new DecrypterException(DecrypterException.PASSWORD);
        }
        return string3;
    }

    protected File getLocalCaptchaFile() {
        return this.getLocalCaptchaFile(".jpg");
    }

    protected File getLocalCaptchaFile(String string) {
        if (string == null) {
            string = ".jpg";
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = String.valueOf(String.format("%1$td.%1$tm.%1$tY_%1$tH.%1$tM.%1$tS.", calendar)) + new Random().nextInt(999);
        File file = JDUtilities.getResourceFile("captchas/" + this.getHost() + "_" + string2 + string, true);
        file.deleteOnExit();
        return file;
    }

    public Plugin(PluginWrapper pluginWrapper) {
        this.wrapper = pluginWrapper;
        this.config = new ConfigContainer(this.getHost());
    }

    public PluginWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public synchronized boolean canHandle(String string) {
        Matcher matcher;
        if (string == null) {
            return false;
        }
        Pattern pattern = this.getSupportedLinks();
        return pattern != null && (matcher = pattern.matcher(string)).find();
    }

    public void clean() {
        this.br = new Browser();
    }

    public abstract ArrayList<MenuAction> createMenuitems();

    public String cutMatches(String string) {
        return string.replaceAll(this.getSupportedLinks().pattern(), "--CUT--");
    }

    public void fireControlEvent(int n, Object object) {
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, n, object));
    }

    public String getCoder() {
        return "JD-Team";
    }

    public ConfigContainer getConfig() {
        return this.config;
    }

    public static String getFileNameFromHeader(URLConnectionAdapter uRLConnectionAdapter) {
        if (uRLConnectionAdapter.getHeaderField("content-disposition") == null || uRLConnectionAdapter.getHeaderField("content-disposition").indexOf("filename") < 0) {
            return Plugin.getFileNameFromURL(uRLConnectionAdapter.getURL());
        }
        return Plugin.getFileNameFromDispositionHeader(uRLConnectionAdapter.getHeaderField("content-disposition"));
    }

    public static String getFileNameFromDispositionHeader(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = string;
        String string4 = null;
        int n = 0;
        while (n < 2) {
            String[][] stringArray;
            if (string3.contains("filename*")) {
                stringArray = new Regex(string3 = string3.replaceAll("filename\\*", "filename"), ".*?=[ \"']*(.+)''").getMatch(0);
                if (stringArray == null) {
                    logger.severe("Content-Disposition: invalid format: " + string);
                    string4 = null;
                    return string4;
                }
                string4 = new Regex(string3 = string3.replaceAll(String.valueOf(stringArray) + "''", ""), "filename.*?=[ ]*\"(.+)\"").getMatch(0);
                if (string4 == null) {
                    string4 = new Regex(string3, "filename.*?=[ ]*'(.+)'").getMatch(0);
                }
                if (string4 == null) {
                    string = String.valueOf(string.replaceAll("=", "=\"")) + "\"";
                    string3 = string = string.replaceAll(";\"", "\"");
                } else {
                    try {
                        string4 = URLDecoder.decode(string4, (String)stringArray);
                    }
                    catch (Exception exception) {
                        logger.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else if (new Regex(string3, "=\\?.*?\\?.*?\\?.*?\\?=").matches()) {
                stringArray = new Regex(string3, "=\\?(.*?)\\?(.*?)\\?(.*?)\\?=").getMatches();
                if (stringArray.length == 1 && stringArray[0].length == 3 && stringArray[0][1].trim().equalsIgnoreCase("B")) {
                    try {
                        string4 = URLDecoder.decode(Encoding.Base64Decode((String)stringArray[0][2].trim()), stringArray[0][0].trim());
                    }
                    catch (Exception exception) {
                        logger.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else if (new Regex(string3, "=\\?.*?\\?.*?\\?=").matches()) {
                stringArray = new Regex(string3, "=\\?(.*?)\\?(.*?)\\?=").getMatches();
                if (stringArray.length == 1 && stringArray[0].length == 2) {
                    try {
                        string3 = new String(stringArray[0][1].trim().getBytes("ISO-8859-1"), stringArray[0][0].trim());
                    }
                    catch (Exception exception) {
                        logger.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else {
                string4 = new Regex(string3, "filename.*?=[ ]*\"(.+)\"").getMatch(0);
                if (string4 == null) {
                    string4 = new Regex(string3, "filename.*?=[ ]*'(.+)'").getMatch(0);
                }
                if (string4 == null) {
                    string = String.valueOf(string.replaceAll("=", "=\"")) + "\"";
                    string3 = string = string.replaceAll(";\"", "\"");
                }
            }
            if (string4 != null) break;
            ++n;
        }
        if (string4 != null && (string4 = string4.trim()).startsWith("\"")) {
            logger.info("Using Workaround for broken filename header!");
            string4 = string4.substring(1);
        }
        if (string4 == null) {
            logger.severe("Content-Disposition: could not parse header: " + string2);
        }
        return string4;
    }

    public static String getFileNameFromURL(URL uRL) {
        return Plugin.extractFileNameFromURL(uRL.toExternalForm());
    }

    public static String extractFileNameFromURL(String string) {
        int n = string.indexOf("?");
        if (n > 0) {
            string = string.substring(0, n);
        }
        n = Math.max(string.lastIndexOf("/"), string.lastIndexOf("\\"));
        string = string.substring(n + 1);
        return Encoding.htmlDecode((String)string);
    }

    public String getHost() {
        return this.wrapper.getHost();
    }

    public String getPluginID() {
        return String.valueOf(this.getHost()) + "-" + this.getVersion();
    }

    public SubConfiguration getPluginConfig() {
        return SubConfiguration.getConfig(this.wrapper.getConfigName());
    }

    public Pattern getSupportedLinks() {
        return this.wrapper.getPattern();
    }

    public abstract String getVersion();

    protected String getVersion(String string) {
        return Formatter.getRevision((String)string);
    }

    public void init() {
    }

    public boolean isAcceptOnlyURIs() {
        return this.acceptOnlyURIs;
    }

    public void setAcceptOnlyURIs(boolean bl) {
        this.acceptOnlyURIs = bl;
    }
}

