/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.ByteBufferEntry;
import jd.controlling.JDLogger;
import jd.controlling.SpeedMeter;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DownloadInterface {
    public static final int ERROR_REDIRECTED = -1;
    public static Logger logger = JDLogger.getLogger();
    protected int chunkNum = 1;
    private Vector<Chunk> chunks = new Vector();
    private int chunksDownloading = 0;
    private int chunksInProgress = 0;
    protected URLConnectionAdapter connection;
    protected DownloadLink downloadLink;
    private Vector<Integer> errors = new Vector();
    private Vector<Exception> exceptions = null;
    protected long fileSize = -1L;
    protected LinkStatus linkStatus;
    protected PluginForHost plugin;
    private int readTimeout = 100000;
    private int requestTimeout = 100000;
    private boolean resume = false;
    private boolean fixWrongContentDispositionHeader = false;
    private boolean allowFilenameFromURL = false;
    protected boolean speedDebug = false;
    protected long totaleLinkBytesLoaded = 0L;
    private boolean waitFlag = true;
    private boolean fatalErrorOccured = false;
    private boolean doFileSizeCheck = true;
    public boolean userInterrupt = false;
    private boolean fakeContentRangeHeader_flag = false;
    private Request request = null;
    private boolean fileSizeVerified = false;
    private boolean connected;
    private boolean firstChunkRangeless;
    private int chunksStarted = 0;
    private Browser browser;

    public void setFilenameFix(boolean bl) {
        this.fixWrongContentDispositionHeader = bl;
    }

    public synchronized void addChunksStarted(int n) {
        this.chunksStarted += n;
    }

    public synchronized int getChunksStarted() {
        return this.chunksStarted;
    }

    public boolean fixFilename() {
        return this.fixWrongContentDispositionHeader;
    }

    public boolean FilenameFromURLAllowed() {
        return this.allowFilenameFromURL;
    }

    public void setAllowFilenameFromURL(boolean bl) {
        this.allowFilenameFromURL = bl;
    }

    private DownloadInterface(PluginForHost pluginForHost, DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
        this.linkStatus = downloadLink.getLinkStatus();
        this.linkStatus.setStatusText(JDL.L("download.connection.normal", "Download"));
        this.browser = pluginForHost.getBrowser().cloneBrowser();
        downloadLink.setDownloadInstance(this);
        this.plugin = pluginForHost;
        this.requestTimeout = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_CONNECT_TIMEOUT_V3", 100000);
        this.readTimeout = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_READ_TIMEOUT_V3", 100000);
    }

    public DownloadInterface(PluginForHost pluginForHost, DownloadLink downloadLink, Request request) throws IOException, PluginException {
        this(pluginForHost, downloadLink);
        this.request = request;
        this.browser = pluginForHost.getBrowser().cloneBrowser();
        this.requestTimeout = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_CONNECT_TIMEOUT_V3", 100000);
        this.readTimeout = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_READ_TIMEOUT_V3", 100000);
    }

    public long head() throws IOException, PluginException {
        Request request = this.request.toHeadRequest();
        request.load();
        if (this.plugin.getBrowser().isDebug()) {
            logger.finest(request.printHeaders());
        }
        if (request.getContentLength() > 1024L) {
            logger.finer("Got filesze from Headrequest: " + request.getContentLength() + " bytes");
            this.fileSize = request.getContentLength();
            this.downloadLink.setDownloadSize(this.fileSize);
            String string = Plugin.getFileNameFromDispositionHeader(request.getHttpConnection().getHeaderField("content-disposition"));
            if (string != null) {
                this.downloadLink.setName(string);
            }
            this.setFileSizeVerified(true);
        }
        return this.fileSize;
    }

    public long headFake(String string) throws IOException, PluginException {
        String string2;
        String string3;
        this.request.getHeaders().put("Range", string == null ? "bytes=" : string);
        this.browser.openRequestConnection(this.request);
        if (this.plugin.getBrowser().isDebug()) {
            logger.finest(this.request.printHeaders());
        }
        this.request.getHttpConnection().disconnect();
        if (this.downloadLink.getFinalFileName() == null && (this.request.getHttpConnection() != null && this.request.getHttpConnection().isContentDisposition() || this.allowFilenameFromURL)) {
            string3 = Plugin.getFileNameFromHeader(this.request.getHttpConnection());
            this.downloadLink.setFinalFileName(string3);
            if (this.fixWrongContentDispositionHeader) {
                this.downloadLink.setFinalFileName(Encoding.htmlDecode((String)string3));
            }
        }
        if ((string2 = new Regex(string3 = this.request.getHttpConnection().getHeaderField("Content-Range"), ".*?\\/(\\d+)").getMatch(0)) != null) {
            long l;
            this.fileSize = l = Long.parseLong(string2);
            this.downloadLink.setDownloadSize(this.fileSize);
            this.setFileSizeVerified(true);
        }
        return this.fileSize;
    }

    public boolean isFileSizeVerified() {
        return this.fileSizeVerified;
    }

    public boolean fakeContentRangeHeader() {
        return this.fakeContentRangeHeader_flag;
    }

    public void fakeContentRangeHeader(boolean bl) {
        this.fakeContentRangeHeader_flag = bl;
    }

    public void setFileSizeVerified(boolean bl) throws PluginException {
        this.fileSizeVerified = bl;
        if (this.fileSize <= 0L && bl) {
            logger.severe("Downloadsize==0");
            throw new PluginException(2048, 1200000L);
        }
    }

    protected boolean checkResumabled() {
        if (this.downloadLink.getChunksProgress() == null || this.downloadLink.getChunksProgress().length == 0) {
            return false;
        }
        long l = 0L;
        long l2 = this.getFileSize();
        int n = this.downloadLink.getChunksProgress().length;
        long l3 = l2 / (long)n;
        long l4 = -1L;
        int n2 = 0;
        while (n2 < n) {
            long l5 = this.downloadLink.getChunksProgress()[n2] - (long)n2 * l3;
            if (l5 < 0L) {
                return false;
            }
            if (this.downloadLink.getChunksProgress()[n2] <= l4) {
                return false;
            }
            l4 = this.downloadLink.getChunksProgress()[n2];
            l += l5;
            ++n2;
        }
        if (n > 0) {
            this.setChunkNum(n);
            return true;
        }
        return false;
    }

    public URLConnectionAdapter connect(Browser browser) throws Exception {
        browser.setRequest(this.request);
        URLConnectionAdapter uRLConnectionAdapter = this.connect();
        browser.updateCookies(this.request);
        return uRLConnectionAdapter;
    }

    public URLConnectionAdapter connect() throws Exception {
        logger.finer("Connect...");
        if (this.request == null) {
            throw new IllegalStateException("Wrong Mode. Instance is in direct Connection mode");
        }
        this.connected = true;
        if (this.isResume() && this.checkResumabled()) {
            this.connectResumable();
        } else {
            if (this.isFileSizeVerified()) {
                int n = Math.min(Math.max(1, (int)(this.downloadLink.getDownloadSize() / 0x100000L)), this.getChunkNum());
                if ((n = Math.min(n, this.plugin.getFreeConnections())) != this.getChunkNum()) {
                    logger.finer("Corrected Chunknum: " + this.getChunkNum() + " -->" + n);
                    this.setChunkNum(n);
                }
            }
            if (this.isFileSizeVerified() && this.downloadLink.getDownloadSize() > 0L && this.getChunkNum() > 1 && !this.isFirstChunkRangeless()) {
                this.connectFirstRange();
            } else {
                this.request.getHeaders().remove("Range");
                this.browser.connect(this.request);
            }
        }
        if (this.plugin.getBrowser().isDebug()) {
            logger.finest(this.request.printHeaders());
        }
        this.connection = this.request.getHttpConnection();
        if (this.request.getLocation() != null) {
            throw new PluginException(16384, -1L);
        }
        if (this.connection.getRange() != null) {
            if (this.connection.getRange()[2] > 0L) {
                this.setFilesizeCheck(true);
                this.downloadLink.setDownloadSize(this.connection.getRange()[2]);
            }
        } else if (this.connection.getLongContentLength() > 0L) {
            this.setFilesizeCheck(true);
            this.downloadLink.setDownloadSize(this.connection.getLongContentLength());
        }
        this.fileSize = this.downloadLink.getDownloadSize();
        return this.connection;
    }

    private void connectFirstRange() throws IOException {
        long l = this.downloadLink.getDownloadSize() / (long)this.getChunkNum();
        this.request.getHeaders().put("Range", "bytes=0-" + (l - 1L));
        this.browser.connect(this.request);
        if (this.request.getHttpConnection().getResponseCode() == 416) {
            logger.warning("HTTP/1.1 416 Requested Range Not Satisfiable");
            if (this.plugin.getBrowser().isDebug()) {
                logger.finest(this.request.printHeaders());
            }
            throw new IllegalStateException("HTTP/1.1 416 Requested Range Not Satisfiable");
        }
        if (this.request.getHttpConnection().getRange() == null) {
            logger.warning("No Chunkload");
            this.setChunkNum(1);
        } else {
            if (this.request.getHttpConnection().getRange()[0] != 0L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + ". Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
            if (this.request.getHttpConnection().getRange()[1] < l - 2L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
            if (this.request.getHttpConnection().getRange()[1] == this.request.getHttpConnection().getRange()[2] - 1L && this.getChunkNum() > 1) {
                logger.warning(" Chunkload Protection.. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            } else if (this.request.getHttpConnection().getRange()[1] > l - 1L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
        }
    }

    private void connectResumable() throws IOException {
        long[] lArray = this.downloadLink.getChunksProgress();
        String string = "";
        String string2 = "";
        if (this.isFileSizeVerified()) {
            string2 = lArray[0] == 0L ? "0" : String.valueOf(lArray[0] + 1L);
            string = String.valueOf(this.fileSize / (long)lArray.length);
        } else {
            string2 = lArray[0] == 0L ? "0" : String.valueOf(lArray[0] + 1L);
            String string3 = string = lArray.length > 1 ? String.valueOf(lArray[1] + 1L) : "";
        }
        if (this.isFirstChunkRangeless() && string2.equals("0")) {
            this.request.getHeaders().remove("Range");
        } else {
            this.request.getHeaders().put("Range", "bytes=" + string2 + "-" + string);
        }
        this.browser.connect(this.request);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    protected void addChunk(Chunk chunk) {
        this.chunks.add(chunk);
        chunk.startChunk();
    }

    public synchronized void addChunksDownloading(long l) {
        this.chunksDownloading = (int)((long)this.chunksDownloading + l);
    }

    protected void addException(Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new Vector();
        }
        this.exceptions.add(exception);
    }

    public synchronized void addToChunksInProgress(long l) {
        this.chunksInProgress = (int)((long)this.chunksInProgress + l);
    }

    protected synchronized void addToTotalLinkBytesLoaded(long l) {
        this.totaleLinkBytesLoaded += l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignChunkSpeeds() {
        int n = 10240;
        int n2 = this.downloadLink.getSpeedLimit();
        int n3 = (int)((double)(n2 / this.chunkNum) * 0.4);
        int n4 = 0;
        Vector<Chunk> vector = this.chunks;
        synchronized (vector) {
            for (Chunk chunk : this.chunks) {
                if (!chunk.isAlive()) continue;
                n4 = (int)((long)n4 + chunk.bytesPerSecond);
            }
            int n5 = n2 - n4;
            if (Math.abs(n5) < n) {
                for (Chunk chunk : this.chunks) {
                    if (!chunk.isAlive()) continue;
                    chunk.checkTimeout(180000L);
                }
                return;
            }
            for (Chunk chunk : this.chunks) {
                if (!chunk.isAlive()) continue;
                chunk.checkTimeout(180000L);
                chunk.setMaximalSpeed(Math.max(n3, (int)chunk.bytesPerSecond + n5 / Math.max(1, this.getRunningChunks())));
            }
        }
    }

    protected void error(int n, String string) {
        logger.severe("Error occured: " + LinkStatus.toString(n));
        if (this.errors.indexOf(n) < 0) {
            this.errors.add(n);
        }
        if (this.fatalErrorOccured) {
            return;
        }
        this.linkStatus.addStatus(n);
        this.linkStatus.setErrorMessage(string);
        switch (n) {
            case 4: 
            case 32: 
            case 2048: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 131072: 
            case 524288: 
            case 0x100000: 
            case 0x200000: {
                this.fatalErrorOccured = true;
                this.terminate();
            }
        }
    }

    public int getChunkNum() {
        return this.chunkNum;
    }

    public Vector<Chunk> getChunks() {
        return this.chunks;
    }

    public int getChunksDownloading() {
        return this.chunksDownloading;
    }

    public Vector<Integer> getErrors() {
        return this.errors;
    }

    public Vector<Exception> getExceptions() {
        return this.exceptions;
    }

    public File getFile() {
        return new File(this.downloadLink.getFileOutput());
    }

    protected long getFileSize() {
        if (this.fileSize > 0L) {
            return this.fileSize;
        }
        if (this.connection != null && this.connection.getLongContentLength() > 0L) {
            return this.connection.getLongContentLength();
        }
        if (this.downloadLink.getDownloadSize() > 0L) {
            return this.downloadLink.getDownloadSize();
        }
        return -1L;
    }

    public int getReadTimeout() {
        return Math.max(10000, this.readTimeout);
    }

    public int getRequestTimeout() {
        return Math.max(10000, this.requestTimeout);
    }

    public int getRunningChunks() {
        return this.chunksInProgress;
    }

    public boolean handleErrors() {
        if (this.userInterrupt) {
            logger.info("Download interrupted by user input");
            return false;
        }
        if (this.doFileSizeCheck && (this.totaleLinkBytesLoaded <= 0L || this.totaleLinkBytesLoaded != this.fileSize && this.fileSize > 0L)) {
            if (this.totaleLinkBytesLoaded > this.fileSize) {
                logger.severe("loaded more than requested. filesize: " + this.fileSize + " loaded: " + this.totaleLinkBytesLoaded + ". This might be  a logic chunk setup error!");
                if (!this.linkStatus.isFailed()) {
                    this.linkStatus.setStatus(2);
                }
                return true;
            }
            logger.severe("DOWNLOAD INCOMPLETE DUE TO FILESIZECHECK");
            this.error(512, JDL.L("download.error.message.incomplete", "Download unvollst\u00e4ndig"));
            return false;
        }
        if (this.getExceptions() != null && this.getExceptions().size() > 0) {
            this.error(4, JDL.L("download.error.message.incomplete", "Download unvollst\u00e4ndig"));
            return false;
        }
        if (!this.linkStatus.isFailed()) {
            this.linkStatus.setStatus(2);
        }
        return true;
    }

    public boolean isResume() {
        return this.resume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunkFinished() {
        DownloadInterface downloadInterface = this;
        synchronized (downloadInterface) {
            if (this.waitFlag) {
                this.waitFlag = false;
                this.notify();
            }
        }
    }

    protected abstract void onChunksReady();

    public void setChunkNum(int n) {
        if (n <= 0) {
            logger.severe("Chunks value must be >=1");
            return;
        }
        this.chunkNum = n;
    }

    public void setFilesize(long l) {
        this.fileSize = l;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setRequestTimeout(int n) {
        this.requestTimeout = n;
    }

    public void setResume(boolean bl) {
        this.downloadLink.getTransferStatus().setResumeSupport(bl);
        if (this.checkResumabled()) {
            this.resume = bl;
        } else {
            logger.warning("Resumepoint not valid");
        }
    }

    protected abstract void setupChunks() throws Exception;

    public static boolean preDownloadCheckFailed(DownloadLink downloadLink) {
        DownloadLink downloadLink2 = downloadLink;
        DownloadLink downloadLink3 = JDUtilities.getDownloadController().getFirstLinkThatBlocks(downloadLink2);
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (downloadLink3 != null) {
            logger.severe("File already is in progress. " + downloadLink2.getFileOutput());
            linkStatus.addStatus(8192);
            linkStatus.setStatusText(JDL.LF("system.download.errors.linkisBlocked", "Mirror %s is loading", downloadLink3.getPlugin().getHost()));
            return true;
        }
        File file = new File(downloadLink2.getFileOutput());
        if (file.getParentFile() == null) {
            linkStatus.addStatus(131072);
            linkStatus.setErrorMessage(JDL.L("system.download.errors.invalidoutputfile", "Invalid Outputfile"));
            return true;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            if (SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("FILE_EXISTS", 1) == 0) {
                if (!new File(downloadLink2.getFileOutput()).delete()) {
                    linkStatus.addStatus(131072);
                    linkStatus.setErrorMessage(JDL.L("system.download.errors.couldnotoverwrite", "Could not overwrite existing file"));
                    return true;
                }
            } else {
                linkStatus.addStatus(8192);
                linkStatus.setErrorMessage(JDL.L("downloadlink.status.error.file_exists", "File exists"));
                return true;
            }
        }
        return false;
    }

    public boolean startDownload() throws Exception {
        logger.finer("Start Download");
        if (!this.connected) {
            this.connect();
        }
        if (this.connection != null && this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
            this.setResume(false);
            this.setChunkNum(1);
        }
        if (this.downloadLink.getFinalFileName() == null && (this.connection != null && this.connection.isContentDisposition() || this.allowFilenameFromURL)) {
            String string = Plugin.getFileNameFromHeader(this.connection);
            this.downloadLink.setFinalFileName(string);
            if (this.fixWrongContentDispositionHeader) {
                this.downloadLink.setFinalFileName(Encoding.htmlDecode((String)string));
            }
        }
        this.downloadLink.getLinkStatus().setStatusText(null);
        if (this.connection == null || !this.connection.isOK()) {
            if (this.connection != null) {
                logger.finest(this.connection.toString());
            }
            throw new PluginException(2048, 600000L);
        }
        if (this.connection.getHeaderField("Location") != null) {
            this.error(0x400000, "Sent a redirect to Downloadinterface");
            return false;
        }
        if (DownloadInterface.preDownloadCheckFailed(this.downloadLink)) {
            return false;
        }
        try {
            this.linkStatus.addStatus(1024);
            this.chunksStarted = 0;
            this.setupChunks();
            this.waitForChunks();
            this.onChunksReady();
            this.linkStatus.removeStatus(1024);
            return this.handleErrors();
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                this.error(0x200000, JDL.LF("download.error.message.localio", "Could not write to file: %s", exception.getMessage()));
            } else {
                JDLogger.exception(exception);
            }
            this.handleErrors();
            this.linkStatus.removeStatus(1024);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        logger.severe("A critical Downloaderror occured. Terminate...");
        Vector<Chunk> vector = this.chunks;
        synchronized (vector) {
            Iterator<Chunk> iterator = this.chunks.iterator();
            while (iterator.hasNext()) {
                iterator.next().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void waitForChunks() {
        var1_1 = 0;
        DownloadInterface.logger.finer("Wait for chunks");
        var2_2 = 150;
        while (this.chunksInProgress > 0) {
            var3_3 = this;
            synchronized (var3_3) {
                block8: {
                    if (this.waitFlag) {
                        try {
                            this.wait(var2_2);
                            break block8;
                        }
                        catch (Exception var4_4) {
                            var5_5 = this.chunks.iterator();
                            ** while (var5_5.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var5_5.next().interrupt();
                            continue;
                        }
lbl17:
                        // 1 sources

                        return;
                    }
                }
            }
            this.waitFlag = true;
            this.downloadLink.setDownloadCurrent(this.totaleLinkBytesLoaded);
            this.downloadLink.requestGuiUpdate();
            if (++var1_1 != 1000 / var2_2) continue;
            this.assignChunkSpeeds();
            var1_1 = 0;
        }
    }

    protected synchronized boolean writeBytes(Chunk chunk) {
        return this.writeChunkBytes(chunk);
    }

    protected abstract boolean writeChunkBytes(Chunk var1);

    public void setFilesizeCheck(boolean bl) {
        this.doFileSizeCheck = bl;
    }

    public URLConnectionAdapter getConnection() {
        return this.connection;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setFirstChunkRangeless(boolean bl) {
        this.firstChunkRangeless = bl;
    }

    public boolean isFirstChunkRangeless() {
        return this.firstChunkRangeless;
    }

    public class Chunk
    extends Thread {
        private static final long MIN_BUFFERSIZE = 1024L;
        public static final long MIN_CHUNKSIZE = 0x100000L;
        private static final int TIME_BASE = 2000;
        private long blockStart;
        protected ByteBufferEntry buffer;
        private double bufferTimeFaktor;
        private long bytesPerSecond;
        private long chunkBytesLoaded;
        private URLConnectionAdapter connection;
        private long desiredBps;
        private long endByte;
        private int id;
        private InputStream inputStream;
        private long MAX_BUFFERSIZE;
        private int maxSpeed;
        private ReadableByteChannel source;
        private long startByte;
        private long totalPartBytes;
        private DownloadInterface dl;
        private boolean connectionclosed;
        private boolean addedtoStartedChunks;
        private boolean chunkinprogress;
        private boolean clonedconnection;
        private SpeedMeter speed;

        public Chunk(long l, long l2, URLConnectionAdapter uRLConnectionAdapter, DownloadInterface downloadInterface2) {
            super("DOwnloadchunk " + l + " - " + l2);
            this.blockStart = 0L;
            this.buffer = null;
            this.bufferTimeFaktor = 1.0;
            this.bytesPerSecond = -1L;
            this.chunkBytesLoaded = 0L;
            this.id = -1;
            this.MAX_BUFFERSIZE = 0x400000L;
            this.totalPartBytes = 0L;
            this.connectionclosed = false;
            this.addedtoStartedChunks = false;
            this.chunkinprogress = false;
            this.clonedconnection = false;
            this.speed = new SpeedMeter();
            this.startByte = l;
            this.endByte = l2;
            this.connection = uRLConnectionAdapter;
            this.dl = downloadInterface2;
            this.setPriority(1);
            this.MAX_BUFFERSIZE = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("MAX_BUFFER_SIZE_V3", 1000) * 1024;
        }

        private void addChunkBytesLoaded(long l) {
            this.chunkBytesLoaded += l;
        }

        public boolean inProgress() {
            return this.chunkinprogress;
        }

        public boolean isClonedConnection() {
            return this.clonedconnection;
        }

        public void setInProgress(boolean bl) {
            this.chunkinprogress = bl;
        }

        public SpeedMeter getSpeedMeter() {
            return this.speed;
        }

        private void setChunkStartet() {
            if (this.addedtoStartedChunks) {
                return;
            }
            DownloadInterface.this.addChunksStarted(1);
            this.addedtoStartedChunks = true;
        }

        public int getPercent() {
            return (int)(10000L * this.chunkBytesLoaded / Math.max(1L, Math.max(this.chunkBytesLoaded, this.endByte - this.startByte)));
        }

        private void addPartBytes(long l) {
            this.totalPartBytes += l;
        }

        public void checkTimeout(long l) {
            long l2 = this.blockStart;
            if (Thread.interrupted() || !this.isAlive()) {
                return;
            }
            if (this.isExternalyAborted()) {
                logger.severe("INTERRUPT");
                DownloadInterface.this.error(0x100000, "Timeout reached");
                this.interrupt();
            }
            if (l2 <= 0L) {
                return;
            }
            long l3 = System.currentTimeMillis() - l2;
            if (l3 >= l) {
                logger.severe("Timeout or termination detected: interrupt: " + l + " - " + l3 + " - " + l2);
                this.interrupt();
            } else if (l3 >= 5000L) {
                DownloadInterface.this.downloadLink.getLinkStatus().setStatusText(JDL.L("download.connection.idle", "Idle"));
                DownloadInterface.this.downloadLink.requestGuiUpdate();
            } else {
                DownloadInterface.this.downloadLink.getLinkStatus().setStatusText(null);
            }
        }

        private URLConnectionAdapter copyConnection(URLConnectionAdapter uRLConnectionAdapter) {
            URLConnectionAdapter uRLConnectionAdapter2;
            block14: {
                block13: {
                    try {
                        while (DownloadInterface.this.downloadLink.getPlugin().waitForNextConnectionAllowed()) {
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                    DownloadInterface.this.downloadLink.getPlugin().putLastConnectionTime(System.currentTimeMillis());
                    long l = this.startByte;
                    String string = "" + (this.endByte > 0L ? Long.valueOf(this.endByte + 1L) : "");
                    if (l == 0L) {
                        logger.finer("\u00dcbernehme 0 Verbindung");
                        return uRLConnectionAdapter;
                    }
                    if (uRLConnectionAdapter.getRange() != null && uRLConnectionAdapter.getRange()[0] == l) {
                        logger.finer("\u00dcbernehme Verbindung bei " + uRLConnectionAdapter.getRange()[0]);
                        return uRLConnectionAdapter;
                    }
                    try {
                        Browser browser = DownloadInterface.this.plugin.getBrowser().cloneBrowser();
                        browser.setReadTimeout(DownloadInterface.this.getReadTimeout());
                        browser.setConnectTimeout(DownloadInterface.this.getRequestTimeout());
                        Map map = uRLConnectionAdapter.getRequestProperties();
                        if (map != null) {
                            uRLConnectionAdapter2 = map.entrySet();
                            for (Map.Entry entry : uRLConnectionAdapter2) {
                                String string2 = ((List)entry.getValue()).toString();
                                browser.getHeaders().put((String)entry.getKey(), string2.substring(1, string2.length() - 1));
                            }
                        }
                        browser.getHeaders().put("Range", "bytes=" + l + "-" + string);
                        uRLConnectionAdapter2 = uRLConnectionAdapter.getDoOutput() ? browser.openRequestConnection(uRLConnectionAdapter.getRequest()) : browser.openGetConnection("" + uRLConnectionAdapter.getURL());
                        if (uRLConnectionAdapter2.isOK()) break block13;
                        if (uRLConnectionAdapter2.getResponseCode() != 416) {
                            DownloadInterface.this.error(16384, "Server: " + uRLConnectionAdapter2.getResponseMessage());
                        } else {
                            logger.warning("HTTP 416, maybe finished last chunk?");
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        DownloadInterface.this.addException(exception);
                        DownloadInterface.this.error(4, JDUtilities.convertExceptionReadable(exception));
                        JDLogger.exception(exception);
                        return null;
                    }
                }
                if (uRLConnectionAdapter2.getHeaderField("Location") == null) break block14;
                DownloadInterface.this.error(16384, "Server: Redirect");
                return null;
            }
            this.clonedconnection = true;
            return uRLConnectionAdapter2;
        }

        /*
         * Exception decompiling
         */
        private void download() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 29[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void finalize() {
            if (DownloadInterface.this.speedDebug) {
                logger.finer("Finalized: " + DownloadInterface.this.downloadLink + " : " + this.getID());
            }
        }

        private long getBufferSize(long l) {
            if (DownloadInterface.this.speedDebug) {
                logger.finer("speed " + l);
            }
            if (!DownloadLink.isSpeedLimited()) {
                return (int)this.MAX_BUFFERSIZE;
            }
            long l2 = Math.max(1024L, l *= 2L);
            long l3 = Math.min(this.MAX_BUFFERSIZE, l2);
            this.bufferTimeFaktor = Math.max(0.1, (double)l3 / (double)l);
            if (DownloadInterface.this.speedDebug) {
                logger.finer("Maxspeed= " + l + " buffer=" + l3 + "time: " + this.getTimeInterval());
            }
            return l3;
        }

        public long getBytesLoaded() {
            return this.getCurrentBytesPosition() - this.startByte;
        }

        public long getBytesPerSecond() {
            return this.bytesPerSecond;
        }

        public long getChunkSize() {
            return this.endByte - this.startByte + 1L;
        }

        long getCurrentBytesPosition() {
            return this.startByte + this.chunkBytesLoaded;
        }

        public long getDesiredBps() {
            return this.desiredBps;
        }

        public long getEndByte() {
            return this.endByte;
        }

        public int getID() {
            if (this.id < 0) {
                if (DownloadInterface.this.speedDebug) {
                    logger.finer("INIT " + DownloadInterface.this.chunks.indexOf(this));
                }
                this.id = DownloadInterface.this.chunks.indexOf(this);
            }
            return this.id;
        }

        public int getMaximalSpeed() {
            try {
                this.maxSpeed = DownloadInterface.this.downloadLink.getSpeedLimit() / DownloadInterface.this.getRunningChunks();
                if (DownloadInterface.this.speedDebug) {
                    logger.finer("Def speed: " + DownloadInterface.this.downloadLink.getSpeedLimit() + "/" + DownloadInterface.this.getRunningChunks() + "=" + this.maxSpeed);
                }
                if (DownloadInterface.this.speedDebug) {
                    logger.finer("return speed: min " + this.maxSpeed + " - " + (double)this.desiredBps * 1.5);
                }
                if (this.desiredBps < 1024L) {
                    return this.maxSpeed;
                }
                return Math.min(this.maxSpeed, (int)((double)this.desiredBps * 1.3));
            }
            catch (Exception exception) {
                DownloadInterface.this.addException(exception);
                DownloadInterface.this.error(4, JDUtilities.convertExceptionReadable(exception));
                return 0;
            }
        }

        public long getStartByte() {
            return this.startByte;
        }

        private int getTimeInterval() {
            if (!DownloadLink.isSpeedLimited()) {
                return 2000;
            }
            return Math.min(10000, (int)(2000.0 * this.bufferTimeFaktor));
        }

        public long getTotalPartBytesLoaded() {
            return this.totalPartBytes;
        }

        public long getWritePosition() throws Exception {
            long l = this.getCurrentBytesPosition();
            long l2 = this.buffer.buffer.limit();
            return l - l2;
        }

        private boolean isExternalyAborted() {
            return this.isInterrupted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Vector<Chunk> vector;
            PluginForHost.setCurrentConnections(PluginForHost.getCurrentConnections() + 1);
            this.run0();
            PluginForHost.setCurrentConnections(PluginForHost.getCurrentConnections() - 1);
            DownloadInterface.this.addToChunksInProgress(-1L);
            while (DownloadInterface.this.getChunksStarted() != DownloadInterface.this.chunkNum) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!this.isExternalyAborted()) continue;
            }
            boolean bl = false;
            Vector<Chunk> vector2 = vector = this.dl.getChunks();
            synchronized (vector2) {
                for (Chunk chunk : vector) {
                    if (!chunk.inProgress() || chunk.isClonedConnection()) continue;
                    bl = true;
                    break;
                }
            }
            if (this.isClonedConnection()) {
                if (this.connection != null && this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            } else if (!bl && this.connection != null && this.connection.isConnected()) {
                this.connection.disconnect();
            }
            DownloadInterface.this.onChunkFinished();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run0() {
            try {
                block46: {
                    String[][] stringArray;
                    block47: {
                        logger.finer("Start Chunk " + this.getID() + " : " + this.startByte + " - " + this.endByte);
                        if (this.startByte >= this.endByte) {
                            if (this.endByte > 0L) return;
                        }
                        if (this.startByte >= DownloadInterface.this.getFileSize() && this.endByte > 0L) {
                            return;
                        }
                        if (DownloadInterface.this.chunkNum > 1) {
                            this.connection = this.copyConnection(this.connection);
                            if (this.connection == null) {
                                if (this.startByte >= DownloadInterface.this.fileSize && DownloadInterface.this.fileSize > 0L) {
                                    DownloadInterface.this.downloadLink.getLinkStatus().removeStatus(16384);
                                    logger.finer("Is no error. Last chunk is just already finished");
                                    return;
                                }
                                DownloadInterface.this.error(16384, JDL.L("download.error.message.connectioncopyerror", "Could not clone the connection"));
                                logger.severe("ERROR Chunk (connection copy failed) " + DownloadInterface.this.chunks.indexOf(this));
                                return;
                            }
                        } else if (this.startByte > 0L) {
                            this.connection = this.copyConnection(this.connection);
                            if (this.connection == null) {
                                DownloadInterface.this.error(16384, JDL.L("download.error.message.connectioncopyerror", "Could not clone the connection"));
                                logger.severe("ERROR Chunk (connection copy failed) " + DownloadInterface.this.chunks.indexOf(this));
                                return;
                            }
                            if (this.startByte > 0L && (this.connection.getHeaderField("Content-Range") == null || this.connection.getHeaderField("Content-Range").length() == 0)) {
                                DownloadInterface.this.error(16384, JDL.L("download.error.message.rangeheaders", "Server does not support chunkload"));
                                logger.severe("ERROR Chunk (no range header response)" + DownloadInterface.this.chunks.indexOf(this));
                                return;
                            }
                        }
                        if (this.startByte <= 0L) break block46;
                        stringArray = new Regex(this.connection.getHeaderField("Content-Range"), ".*?(\\d+).*?-.*?(\\d+).*?/.*?(\\d+)").getMatches();
                        if (DownloadInterface.this.speedDebug) {
                            logger.finer("Range Header " + this.connection.getHeaderField("Content-Range"));
                        }
                        if (stringArray != null || DownloadInterface.this.chunkNum <= 1) break block47;
                        if (this.dl.fakeContentRangeHeader()) {
                            logger.severe("Using fakeContentRangeHeader");
                            String[][] stringArray2 = new Regex(this.connection.getRequestProperty("Range"), ".*?(\\d+).*?-.*?(\\d+)?").getMatches();
                            long l = Formatter.filterLong((String)stringArray2[0][0]);
                            long l2 = stringArray2[0][1] == null ? Formatter.filterLong((String)stringArray2[0][0]) + this.connection.getLongContentLength() - 1L : Formatter.filterLong((String)stringArray2[0][1]);
                            if (l != this.startByte) {
                                logger.severe("Range Conflict " + l + " - " + l2 + " wished start: " + 0);
                            }
                            if (this.endByte <= 0L) {
                                this.endByte = l2 - 1L;
                            }
                            if (l2 == this.endByte) {
                                logger.finer("ServerType: RETURN Rangeend-1");
                            } else if (l2 == this.endByte + 1L) {
                                logger.finer("ServerType: RETURN exact rangeend");
                            }
                            if (l2 < this.endByte) {
                                logger.severe("Range Conflict");
                            }
                            if (l2 > this.endByte + 1L) {
                                logger.warning("Possible RangeConflict or Servermisconfiguration. wished endByte: " + this.endByte + " got: " + l2);
                            }
                            if (DownloadInterface.this.chunks.indexOf(this) == DownloadInterface.this.chunkNum - 1) {
                                logger.severe("Use Workaround for wrong last range!");
                                this.endByte = Math.max(this.endByte, l2);
                            } else {
                                this.endByte = Math.min(this.endByte, l2);
                            }
                            if (l == l2) {
                                return;
                            }
                            if (DownloadInterface.this.speedDebug) {
                                logger.finer("Resulting Range" + this.startByte + " - " + this.endByte);
                            }
                            break block46;
                        } else {
                            if (this.connection.getLongContentLength() == this.startByte) {
                                return;
                            }
                            DownloadInterface.this.error(16384, String.valueOf(JDL.L("download.error.message.rangeheaderparseerror", "Unexpected rangeheader format:")) + this.connection.getHeaderField("Content-Range"));
                            logger.severe("ERROR Chunk (range header parse error)" + DownloadInterface.this.chunks.indexOf(this) + this.connection.getHeaderField("Content-Range") + ": " + this.connection.getHeaderField("Content-Range"));
                            return;
                        }
                    }
                    if (stringArray != null) {
                        long l = Formatter.filterLong((String)stringArray[0][0]);
                        long l3 = Formatter.filterLong((String)stringArray[0][1]);
                        long l4 = Formatter.filterLong((String)stringArray[0][2]);
                        if (l != this.startByte) {
                            logger.severe("Range Conflict " + stringArray[0][0] + " - " + stringArray[0][1] + " wished start: " + 0);
                        }
                        if (this.endByte <= 0L) {
                            this.endByte = l4 - 1L;
                        }
                        if (l3 == this.endByte) {
                            logger.finer("ServerType: RETURN Rangeend-1");
                        } else if (l3 == this.endByte + 1L) {
                            logger.finer("ServerType: RETURN exact rangeend");
                        }
                        if (l3 < this.endByte) {
                            logger.severe("Range Conflict " + stringArray[0] + " - " + stringArray[1] + " wishedend: " + this.endByte);
                        }
                        if (l3 > this.endByte + 1L) {
                            logger.warning("Possible RangeConflict or Servermisconfiguration. wished endByte: " + this.endByte + " got: " + l3);
                        }
                        this.endByte = Math.min(this.endByte, l3);
                        if (DownloadInterface.this.speedDebug) {
                            logger.finer("Resulting Range" + this.startByte + " - " + this.endByte);
                        }
                    } else {
                        this.endByte = this.connection.getLongContentLength() - 1L;
                        if (DownloadInterface.this.speedDebug) {
                            logger.finer("Endbyte set to " + this.endByte);
                        }
                    }
                }
                if (this.endByte <= 0L) {
                    this.endByte = this.connection.getLongContentLength() - 1L;
                    if (DownloadInterface.this.speedDebug) {
                        logger.finer("Endbyte set to " + this.endByte);
                    }
                }
                if (this.isInterrupted() || DownloadInterface.this.downloadLink.isAborted()) {
                    DownloadInterface.this.userInterrupt = true;
                }
                DownloadInterface.this.addChunksDownloading(1L);
                this.setChunkStartet();
                this.download();
                this.bytesPerSecond = 0L;
                this.desiredBps = 0L;
                DownloadInterface.this.addChunksDownloading(-1L);
                if (this.isInterrupted() || DownloadInterface.this.downloadLink.isAborted()) {
                    logger.severe("ABBORTED BY USER");
                }
                logger.finer("Chunk finished " + DownloadInterface.this.chunks.indexOf(this) + " " + this.getBytesLoaded() + " bytes");
                return;
            }
            finally {
                this.setChunkStartet();
            }
        }

        public void setLoaded(long l) {
            this.totalPartBytes = l = Math.max(0L, l);
            DownloadInterface.this.addToTotalLinkBytesLoaded(l);
        }

        public void setMaximalSpeed(int n) {
            this.maxSpeed = n;
        }

        public void startChunk() {
            this.start();
        }

        public void closeConnections() {
            this.connectionclosed = true;
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.source.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.connection != null && this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("Closed connection before closing file");
        }
    }
}

