/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import jd.config.SubConfiguration;
import jd.controlling.ByteBufferEntry;
import jd.controlling.JDLogger;
import jd.http.Request;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class RAFDownload
extends DownloadInterface {
    protected FileChannel[] channels;
    protected long hdWritesPerSecond;
    private FileChannel outputChannel;
    private RandomAccessFile outputFile;
    protected File[] partFiles;
    protected long writeCount = 0L;
    protected long writeTimer = System.currentTimeMillis();

    public RAFDownload(PluginForHost pluginForHost, DownloadLink downloadLink, Request request) throws IOException, PluginException {
        super(pluginForHost, downloadLink, request);
    }

    protected void onChunksReady() {
        logger.finer("onCHunksReady");
        logger.info("Close connections if the are not closed yet");
        for (DownloadInterface.Chunk object : this.getChunks()) {
            object.closeConnections();
        }
        logger.info("Close File. Let AV programs run");
        try {
            this.outputChannel.force(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.outputFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.outputChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.handleErrors()) {
            return;
        }
        try {
            String string;
            DownloadLink downloadLink;
            logger.finest("no errors : rename");
            if (!new File(String.valueOf(this.downloadLink.getFileOutput()) + ".part").renameTo(new File(this.downloadLink.getFileOutput()))) {
                logger.severe("Could not rename file " + new File(String.valueOf(this.downloadLink.getFileOutput()) + ".part") + " to " + this.downloadLink.getFileOutput());
                this.error(0x200000, JDL.L("system.download.errors.couldnotrename", "Could not rename partfile"));
            }
            if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("DO_CRC", false).booleanValue() && (downloadLink = this.downloadLink.getFilePackage().getSFV()) != null && downloadLink.getLinkStatus().hasStatus(2)) {
                this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2", "CRC-Check running(%s)", "CRC32"));
                this.downloadLink.requestGuiUpdate();
                long l = JDUtilities.getCRC(new File(this.downloadLink.getFileOutput()));
                string = JDIO.readFileToString((File)new File(downloadLink.getFileOutput()));
                if (string != null && string.toLowerCase().contains(new File(this.downloadLink.getFileOutput()).getName().toLowerCase())) {
                    String[] stringArray = Regex.getLines(string);
                    boolean bl = false;
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray2[n2];
                        if (string2.trim().endsWith(Long.toHexString(l).toUpperCase()) || string2.trim().endsWith(Long.toHexString(l).toLowerCase())) {
                            bl = true;
                            logger.info("CRC CHECK SUCCESS");
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2.success", "CRC-Check OK(%s)", "CRC32"));
                        this.downloadLink.requestGuiUpdate();
                    } else {
                        this.downloadLink.getLinkStatus().removeStatus(2);
                        this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2.failed", "CRC-Check FAILED(%s)", "CRC32"));
                        this.downloadLink.getLinkStatus().setValue(0x8000000L);
                        this.downloadLink.requestGuiUpdate();
                        this.error(16384, JDL.LF("system.download.doCRC2.failed", "CRC-Check FAILED(%s)", "CRC32"));
                    }
                } else {
                    this.downloadLink.getLinkStatus().setStatusText(null);
                    this.downloadLink.requestGuiUpdate();
                }
            }
            if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("DO_CRC", false).booleanValue()) {
                String string3 = null;
                String string4 = null;
                string = null;
                if (this.downloadLink.getMD5Hash() != null) {
                    string4 = JDHash.getMD5((File)new File(this.downloadLink.getFileOutput()));
                    string3 = this.downloadLink.getMD5Hash();
                    string = "MD5";
                }
                if (this.downloadLink.getSha1Hash() != null) {
                    string4 = JDHash.getSHA1((File)new File(this.downloadLink.getFileOutput()));
                    string3 = this.downloadLink.getSha1Hash();
                    string = "SHA1";
                }
                if (string != null) {
                    this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2", "CRC-Check running(%s)", string));
                    this.downloadLink.requestGuiUpdate();
                    if (string4.equalsIgnoreCase(string3)) {
                        this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2.success", "CRC-Check OK(%s)", string));
                        this.downloadLink.requestGuiUpdate();
                    } else {
                        this.downloadLink.getLinkStatus().removeStatus(2);
                        this.downloadLink.getLinkStatus().setStatusText(JDL.LF("system.download.doCRC2.failed", "CRC-Check FAILED(%s)", string));
                        this.downloadLink.getLinkStatus().setValue(0x8000000L);
                        this.downloadLink.requestGuiUpdate();
                        this.error(16384, JDL.LF("system.download.doCRC2.failed", "CRC-Check FAILED(%s)", string));
                    }
                }
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            this.addException(exception);
        }
    }

    protected void setupChunks() throws Exception {
        try {
            if (this.isResume() && this.checkResumabled()) {
                logger.finer("Setup resume");
                this.setupResume();
            } else {
                logger.finer("Setup virgin download");
                this.setupVirginStart();
            }
        }
        catch (Exception exception) {
            try {
                if (this.outputChannel != null) {
                    this.outputChannel.force(false);
                }
                logger.info("CLOSE HD FILE");
                if (this.outputFile != null) {
                    this.outputFile.close();
                }
                if (this.outputChannel != null) {
                    this.outputChannel.close();
                }
            }
            catch (Exception exception2) {
                JDLogger.exception(exception2);
            }
            this.addException(exception);
            throw exception;
        }
    }

    private void setupVirginStart() throws FileNotFoundException {
        DownloadInterface.Chunk chunk;
        this.totaleLinkBytesLoaded = 0L;
        this.downloadLink.setDownloadCurrent(0L);
        long l = this.fileSize / (long)this.getChunkNum();
        if (this.connection.getRange() != null) {
            if (this.connection.getRange()[1] == this.connection.getRange()[2] - 1L) {
                logger.warning("Chunkload protection. this may cause traffic errors");
                l = this.fileSize / (long)this.getChunkNum();
            } else {
                l = (this.fileSize - this.connection.getLongContentLength()) / (long)(this.getChunkNum() - 1);
            }
        }
        if (l <= 0L) {
            logger.warning("Could not get Filesize.... reset chunks to 1");
            this.setChunkNum(1);
        }
        logger.finer("Start Download in " + this.getChunkNum() + " chunks. Chunksize: " + l);
        this.createOutputChannel();
        this.downloadLink.setChunksProgress(new long[this.chunkNum]);
        this.addToChunksInProgress(this.getChunkNum());
        int n = 0;
        long l2 = 0L;
        if (this.connection.getRange() != null && this.connection.getRange()[1] != this.connection.getRange()[2] - 1L) {
            l2 = this.connection.getRange()[1];
            chunk = new DownloadInterface.Chunk(0L, l2, this.connection, this);
            ++l2;
            logger.finer("Setup chunk 0: " + chunk);
            this.addChunk(chunk);
            ++n;
        }
        int n2 = n;
        while (n2 < this.getChunkNum()) {
            if (n2 == this.getChunkNum() - 1) {
                chunk = new DownloadInterface.Chunk(l2, -1L, this.connection, this);
            } else {
                chunk = new DownloadInterface.Chunk(l2, l2 + l - 1L, this.connection, this);
                l2 += l;
            }
            logger.finer("Setup chunk " + n2 + ": " + chunk);
            this.addChunk(chunk);
            ++n2;
        }
    }

    private void createOutputChannel() throws FileNotFoundException {
        if (!new File(this.downloadLink.getFileOutput()).getParentFile().exists()) {
            new File(this.downloadLink.getFileOutput()).getParentFile().mkdirs();
        }
        this.outputFile = new RandomAccessFile(String.valueOf(this.downloadLink.getFileOutput()) + ".part", "rw");
        this.outputChannel = this.outputFile.getChannel();
    }

    private void setupResume() throws FileNotFoundException {
        long l = this.fileSize / (long)this.getChunkNum();
        logger.info("Resume: " + this.fileSize + " partsize: " + l);
        this.createOutputChannel();
        this.addToChunksInProgress(this.getChunkNum());
        int n = 0;
        while (n < this.getChunkNum()) {
            DownloadInterface.Chunk chunk;
            if (n == this.getChunkNum() - 1) {
                chunk = new DownloadInterface.Chunk(this.downloadLink.getChunksProgress()[n] == 0L ? 0L : this.downloadLink.getChunksProgress()[n] + 1L, -1L, this.connection, this);
                chunk.setLoaded(this.downloadLink.getChunksProgress()[n] - (long)n * l + 1L);
            } else {
                chunk = new DownloadInterface.Chunk(this.downloadLink.getChunksProgress()[n] == 0L ? 0L : this.downloadLink.getChunksProgress()[n] + 1L, (long)(n + 1) * l - 1L, this.connection, this);
                chunk.setLoaded(this.downloadLink.getChunksProgress()[n] - (long)n * l + 1L);
            }
            logger.finer("Setup chunk " + n + ": " + chunk);
            this.addChunk(chunk);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeChunkBytes(DownloadInterface.Chunk chunk) {
        FileChannel fileChannel = this.outputChannel;
        synchronized (fileChannel) {
            try {
                this.outputFile.seek(chunk.getWritePosition());
                this.outputChannel.write(chunk.buffer.buffer);
                if (chunk.getID() >= 0) {
                    this.downloadLink.getChunksProgress()[chunk.getID()] = chunk.getCurrentBytesPosition() - 1L;
                }
                return true;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                    this.error(0x200000, JDUtilities.convertExceptionReadable(exception));
                    this.addException(exception);
                    return false;
                }
            }
        }
    }

    public static DownloadInterface download(DownloadLink downloadLink, Request request, boolean bl, int n) throws IOException, PluginException {
        request.getHeaders().put("Accept-Encoding", "");
        RAFDownload rAFDownload = new RAFDownload(downloadLink.getPlugin(), downloadLink, request);
        downloadLink.getPlugin().setDownloadInterface(rAFDownload);
        rAFDownload.setResume(bl);
        if (n == 0) {
            rAFDownload.setChunkNum(SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 2));
        } else {
            rAFDownload.setChunkNum(n < 0 ? Math.min(n * -1, SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 2)) : n);
        }
        return rAFDownload;
    }

    public static DownloadInterface download(DownloadLink downloadLink, Request request) throws Exception {
        return RAFDownload.download(downloadLink, request, false, 1);
    }

    class ChunkBuffer {
        public ByteBufferEntry buffer;
        public int chunkID;
        public long chunkPosition;
        public long position;

        public ChunkBuffer(ByteBufferEntry byteBufferEntry, long l, long l2, int n) {
            this.buffer = byteBufferEntry;
            this.position = l;
            this.chunkPosition = l2;
            this.chunkID = n;
        }
    }
}

