/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.pluginUtils;

import java.io.File;
import java.io.IOException;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.parser.html.Form;
import jd.plugins.PluginException;

public class Recaptcha {
    private Browser br;
    private String challenge;
    private String server;
    private String captchaAddress;
    private String id;
    private Browser rcBr;
    private Form form;

    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String string) {
        this.challenge = string;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public String getCaptchaAddress() {
        return this.captchaAddress;
    }

    public void setCaptchaAddress(String string) {
        this.captchaAddress = string;
    }

    public Recaptcha(Browser browser) {
        this.br = browser;
    }

    public void parse() throws IOException, PluginException {
        Form[] formArray = this.br.getForms();
        this.form = null;
        Form[] formArray2 = formArray;
        int n = formArray.length;
        int n2 = 0;
        while (n2 < n) {
            Form form = formArray2[n2];
            if (form.getInputField("recaptcha_challenge_field") != null) {
                this.form = form;
                break;
            }
            ++n2;
        }
        if (this.form == null) {
            throw new PluginException(0x400000);
        }
        this.id = this.form.getRegex("k=(.*?)\"").getMatch(0);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void load() throws IOException {
        this.rcBr = this.br.cloneBrowser();
        this.rcBr.getPage("http://api.recaptcha.net/challenge?k=" + this.id);
        this.challenge = this.rcBr.getRegex("challenge : '(.*?)',").getMatch(0);
        this.server = this.rcBr.getRegex("server : '(.*?)',").getMatch(0);
        this.captchaAddress = String.valueOf(this.server) + "image?c=" + this.challenge;
    }

    public File downloadCaptcha(File file) throws IOException {
        Browser.download((File)file, (URLConnectionAdapter)this.rcBr.openGetConnection(this.captchaAddress));
        return file;
    }

    public Browser setCode(String string) throws Exception {
        this.form.put("recaptcha_challenge_field", this.challenge);
        this.form.put("recaptcha_response_field", string);
        this.br.submitForm(this.form);
        return this.br;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }
}

