/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import jd.controlling.JDLogger;
import jd.parser.Regex;
import jd.router.SQLRouterData;
import jd.utils.EditDistance;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RInfo
implements Serializable,
Comparable<RInfo> {
    private static final long serialVersionUID = -2119228262137830055L;
    private boolean haveUpnp = false;
    private boolean haveUpnpReconnect = false;
    private int id;
    private int integrety;
    private String pageHeader;
    private String reconnectMethode;
    private String reconnectMethodeClr;
    private String routerErrorPage;
    private String routerHost;
    private String routerIP;
    private String routerMAC = null;
    private String routerName = null;
    private String routerPage;
    private String routerPageLoggedIn;
    public transient boolean setPlaceholder = false;

    public int compare(RInfo rInfo) {
        int n = 0;
        if (this.routerIP != null && !this.routerIP.equals(rInfo.routerIP)) {
            n += 50;
        }
        if (this.routerHost != null && !this.routerHost.equals(rInfo.routerHost)) {
            n += 100;
        }
        if (this.routerMAC != null && !this.routerMAC.equals(rInfo.routerMAC)) {
            n += 100;
        }
        n += EditDistance.getLevenshteinDistance(this.pageHeader, rInfo.pageHeader);
        n += EditDistance.getLevenshteinDistance(this.routerErrorPage, rInfo.routerErrorPage);
        return n += EditDistance.getLevenshteinDistance(this.routerPage, rInfo.routerPage);
    }

    public int countHtmlTags() {
        if (this.routerPage == null) {
            return 0;
        }
        return new Regex(this.routerPage, "<[^>]*>").count();
    }

    public LinkedHashMap<String, String> getHashMap() {
        Class<?> clazz = this.getClass();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!(field.getName().equals("setPlaceholder") || field.getName().equals("serialVersionUID") || field.getName().equals("id"))) {
                try {
                    Object object = field.get(this);
                    String string = null;
                    if (object != null) {
                        if (object instanceof String) {
                            string = (String)object;
                        } else if (object instanceof Boolean) {
                            string = (Boolean)object != false ? "1" : "0";
                        } else {
                            try {
                                string = JDUtilities.objectToXml(object);
                            }
                            catch (IOException iOException) {
                                JDLogger.exception(iOException);
                            }
                        }
                        int n3 = 0;
                        while (field.getName().equals("routerName") && string.startsWith("<?xml version")) {
                            if (n3++ == 10) {
                                string = "";
                                break;
                            }
                            try {
                                String[] stringArray = (String[])JDUtilities.xmlStringToObjekt(string);
                                if (string.length() == 0) {
                                    string = "";
                                    continue;
                                }
                                string = stringArray[0];
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (string == null || string.length() == 0) {
                            string = null;
                        }
                    }
                    if (string != null) {
                        try {
                            linkedHashMap.put(field.getName(), URLEncoder.encode(string, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            JDLogger.exception(unsupportedEncodingException);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JDLogger.exception(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    JDLogger.exception(illegalAccessException);
                }
            }
            ++n2;
        }
        linkedHashMap.put("HTMLTagCount", "" + this.countHtmlTags());
        return linkedHashMap;
    }

    public int getId() {
        return this.id;
    }

    public int getIntegrety() {
        return this.integrety;
    }

    public String getPageHeader() {
        return this.pageHeader;
    }

    public String getReconnectMethode() {
        return this.reconnectMethode;
    }

    public String getReconnectMethodeClr() {
        return this.reconnectMethodeClr;
    }

    public String getRouterErrorPage() {
        return this.routerErrorPage;
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public String getRouterIP() {
        return this.routerIP;
    }

    public String getRouterMAC() {
        return this.routerMAC;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public String getRouterPage() {
        return this.routerPage;
    }

    public String getRouterPageLoggedIn() {
        return this.routerPageLoggedIn;
    }

    public boolean isHaveUpnp() {
        return this.haveUpnp;
    }

    public boolean isHaveUpnpReconnect() {
        return this.haveUpnpReconnect;
    }

    public void sendToServer() {
        try {
            try {
                if (this.reconnectMethode != null && !this.reconnectMethode.contains("%%%pass%%%")) {
                    this.reconnectMethode = SQLRouterData.setPlaceHolder(this.reconnectMethode);
                }
                if (this.routerName != null) {
                    int n = 0;
                    while (this.routerName.startsWith("<?xml version")) {
                        String[] stringArray = (String[])JDUtilities.xmlStringToObjekt(this.routerName);
                        if (stringArray.length == 0) {
                            this.routerName = null;
                            break;
                        }
                        this.routerName = stringArray[0];
                        if (n++ != 10) continue;
                        this.routerName = null;
                        break;
                    }
                }
                if (this.routerName == null || this.routerName.equals("Reconnect Recorder Methode")) {
                    this.routerName = new Regex(this.getRouterPage(), "<title>(.*?)</title>").getMatch(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.reconnectMethode != null) {
                System.out.println(SQLRouterData.br.postPage("http://localhost/router/setIntegrety2.php", this.getHashMap()));
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
    }

    public void setHaveUpnp(boolean bl) {
        this.haveUpnp = bl;
    }

    public void setHaveUpnpReconnect(boolean bl) {
        this.haveUpnpReconnect = bl;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setId(String string) {
        this.id = Integer.parseInt(string);
    }

    public void setIntegrety(int n) {
        this.integrety = n;
    }

    public void setIntegrety(String string) {
        this.integrety = Integer.parseInt(string);
    }

    public void setPageHeader(String string) {
        this.pageHeader = SQLRouterData.replaceTimeStamps(string);
    }

    public void setReconnectMethode(String string) {
        this.reconnectMethode = string;
    }

    public void setReconnectMethodeClr(String string) {
        this.reconnectMethodeClr = string;
    }

    public void setRouterErrorPage(String string) {
        this.routerErrorPage = SQLRouterData.replaceTimeStamps(string);
    }

    public void setRouterHost(String string) {
        this.routerHost = string;
    }

    public void setRouterIP(String string) {
        this.routerIP = string;
    }

    public void setRouterMAC(String string) {
        if (this.routerMAC == null) {
            this.routerMAC = string.replaceAll(" ", "0");
            if (this.routerMAC.length() > 8) {
                this.routerMAC = this.routerMAC.substring(0, 8);
            }
        }
    }

    public void setRouterName(String string) {
        this.routerName = string;
    }

    public void setRouterPage(String string) {
        this.routerPage = SQLRouterData.replaceTimeStamps(string);
    }

    public void setRouterPageLoggedIn(String string) {
        this.routerPageLoggedIn = SQLRouterData.replaceTimeStamps(string);
    }

    public void setUPnPSCPDs(HashMap<String, String> hashMap) {
        if (hashMap != null) {
            this.haveUpnp = true;
            this.haveUpnpReconnect = SQLRouterData.haveUpnpReconnect(hashMap);
            String[] stringArray = SQLRouterData.getNameFormUPnPSCPDs(hashMap);
            String string = null;
            if (stringArray != null) {
                string = stringArray[0];
                if (stringArray[1] != null) {
                    string = String.valueOf(string) + " " + stringArray[1];
                }
            }
            if (string != null) {
                this.setRouterName(string);
            }
            if (this.getRouterMAC() == null || this.getRouterMAC().length() == 0) {
                try {
                    this.routerMAC = stringArray[2].replaceAll(" ", "0");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setUPnPSCPDs(String string) {
        if (string == null) {
            return;
        }
        HashMap hashMap = null;
        try {
            if (string != null && string.length() > 0) {
                hashMap = (HashMap)JDUtilities.xmlStringToObjekt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setUPnPSCPDs(hashMap);
    }

    @Override
    public int compareTo(RInfo rInfo) {
        return Integer.valueOf(this.getIntegrety()).compareTo(rInfo.getIntegrety());
    }
}

