/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import jd.JDInit;
import jd.controlling.JDLogger;
import jd.controlling.reconnect.HTTPLiveHeader;
import jd.http.Browser;
import jd.nrouter.RouterUtils;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import jd.parser.Regex;
import jd.router.GetMacAdress;
import jd.router.RInfo;
import jd.router.SQLRouterData;
import jd.router.UPnPInfo;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class RouterInfoCollector {
    public static final String PROPERTY_SHOW_ROUTERINFO_DIALOG = "PROPERTY_SHOW_ROUTERINFO_DIALOG";
    public static final String RECONNECTTYPE_LIVE_HEADER = JDL.L("modules.reconnect.types.liveheader", "LiveHeader/Curl");
    public static final String RECONNECTTYPE_CLR = JDL.L("modules.reconnect.types.clr", "CLR Script");
    protected static String reconnectMethode = null;
    protected static String reconnectMethodeClr = null;
    public static final int RInfo_UPNP = 2;
    public static final int RInfo_MAC = 4;
    public static final int RInfo_METHODENAME = 8;
    public static final int RInfo_ROUTERPAGE = 16;
    public static final int RInfo_ROUTERERROR = 32;
    public static final int RInfo_HOSTNAME = 64;
    public static final int RInfo_ALL = 126;
    public static final int RInfo_ROUTERSEARCH = 116;

    public static boolean isLiveheader() {
        reconnectMethode = JDUtilities.getConfiguration().getStringProperty("HTTPSEND_REQUESTS", null);
        return JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_TYPE", 0) == 0 && reconnectMethode != null;
    }

    public static boolean isClr() {
        reconnectMethodeClr = JDUtilities.getConfiguration().getStringProperty("HTTPSEND_REQUESTS_CLR", null);
        return JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_TYPE", 0) == 3 && reconnectMethodeClr != null;
    }

    public static InetAddress getRouterIP() {
        String string = JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null);
        if (string == null || string.matches("\\s*")) {
            return RouterUtils.getAddress(false);
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            JDLogger.exception(unknownHostException);
            return null;
        }
    }

    public static void showDialog() {
    }

    public static RInfo getRInfo(final int n) {
        final RInfo rInfo = new RInfo();
        final Browser browser = new Browser();
        final InetAddress inetAddress = RouterInfoCollector.getRouterIP();
        try {
            rInfo.setRouterIP(RouterInfoCollector.getRouterIP().getHostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Threader threader = new Threader();
        if ((n & 2) != 0) {
            threader.add(new JDRunnable(){

                public void go() throws Exception {
                    try {
                        UPnPInfo uPnPInfo = new UPnPInfo(inetAddress);
                        rInfo.setUPnPSCPDs(uPnPInfo.SCPDs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if ((n & 0x40) != 0) {
            threader.add(new JDRunnable(){

                public void go() throws Exception {
                    try {
                        rInfo.setRouterIP(inetAddress.getHostAddress());
                        rInfo.setRouterHost(inetAddress.getHostName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if ((n & 0x20) != 0) {
            threader.add(new JDRunnable(){

                public void go() throws Exception {
                    try {
                        rInfo.setRouterErrorPage(browser.getPage("http://" + inetAddress.getHostName() + "/error404"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        if ((n & 4) != 0) {
            threader.add(new JDRunnable(){

                public void go() throws Exception {
                    try {
                        rInfo.setRouterMAC(new GetMacAdress().getMacAddress(inetAddress));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        threader.add(new JDRunnable(){

            public void go() throws Exception {
                CharSequence charSequence;
                if ((n & 0x10) != 0) {
                    try {
                        rInfo.setRouterPage(browser.getPage("http://" + inetAddress.getHostName()));
                        charSequence = new StringBuilder();
                        String[] stringArray = browser.getHttpConnection().getHeaderFields();
                        for (Map.Entry entry : stringArray.entrySet()) {
                            if (entry.getKey() != null) {
                                ((StringBuilder)charSequence).append((String)entry.getKey());
                                ((StringBuilder)charSequence).append(new char[]{':', ' '});
                            }
                            boolean bl = false;
                            for (String string : (List)entry.getValue()) {
                                if (bl) {
                                    ((StringBuilder)charSequence).append(';');
                                }
                                ((StringBuilder)charSequence).append(string);
                                bl = true;
                            }
                            ((StringBuilder)charSequence).append(new char[]{'\r', '\n'});
                        }
                        rInfo.setPageHeader(((StringBuilder)charSequence).toString().trim());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((n & 8) != 0) {
                    if (RouterInfoCollector.isLiveheader()) {
                        charSequence = JDUtilities.getConfiguration().getStringProperty("PARAM_HTTPSEND_ROUTERNAME", null);
                        if (rInfo.getRouterName() == null) {
                            if (charSequence != null) {
                                if (!((String)charSequence).equals("Reconnect Recorder Methode")) {
                                    rInfo.setRouterName(rInfo.getRouterName());
                                }
                            } else if (!reconnectMethode.matches("\\s")) {
                                for (String[] stringArray : HTTPLiveHeader.getLHScripts()) {
                                    if (!stringArray[2].trim().equals(reconnectMethode.trim()) || rInfo.getRouterName() != null && rInfo.getRouterName().contains(String.valueOf(stringArray[0]) + " - " + stringArray[1])) continue;
                                    rInfo.setRouterName(rInfo.getRouterName() == null ? String.valueOf(stringArray[0]) + " - " + stringArray[1] : String.valueOf(rInfo.getRouterName()) + " | " + stringArray[0] + " - " + stringArray[1]);
                                }
                            }
                        }
                        if (charSequence == null || ((String)charSequence).equals("Reconnect Recorder Methode")) {
                            rInfo.setReconnectMethode(SQLRouterData.setPlaceHolder(reconnectMethode));
                        } else {
                            rInfo.setReconnectMethode(reconnectMethode);
                        }
                    }
                    if (RouterInfoCollector.isClr()) {
                        if (rInfo.getRouterName() == null) {
                            rInfo.setRouterName(new Regex(rInfo.getReconnectMethodeClr(), "<Router name=\"(.*?)\" />").getMatch(0));
                        }
                        rInfo.setReconnectMethodeClr(reconnectMethodeClr);
                    }
                    if (rInfo.getRouterName() == null && rInfo.getRouterPage() != null) {
                        rInfo.setRouterName(new Regex(rInfo.getRouterPage(), "<title>(.*?)</title>").getMatch(0));
                    }
                }
            }
        });
        threader.startAndWait();
        return rInfo;
    }

    public static void main(String[] stringArray) {
        new JDInit().loadConfiguration();
        RouterInfoCollector.showDialog();
    }
}

