/*
 * Decompiled with CFR 0.152.
 */
package jd.router.reconnectrecorder;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import jd.config.Configuration;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.dialog.AbstractDialog;
import jd.nrouter.IPCheck;
import jd.nutils.JDFlags;
import jd.parser.Regex;
import jd.router.reconnectrecorder.ReconnectRecorder;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class Gui
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField routerip;
    private JCheckBox rawmode;
    public boolean saved = false;
    private String ip_before;
    private String ip_after;
    public String ip = null;
    public String methode = null;
    public String user = null;
    public String pass = null;
    private static long check_intervall = 5000L;
    private static long reconnect_duration = 0L;

    public Gui(String string) {
        super(260, JDL.L("gui.config.jdrr.title", "Reconnect Recorder"), null, JDL.L("gui.btn_start", "Start"), JDL.L("gui.btn_cancel", "Abbrechen"));
        this.ip = string;
        this.init();
    }

    public JComponent contentInit() {
        this.routerip = new JTextField(this.ip);
        this.rawmode = new JCheckBox("RawMode?");
        this.rawmode.setSelected(false);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setContentType("text/html");
        jTextPane.addHyperlinkListener(JLink.getHyperlinkListener());
        jTextPane.setText(JDL.L("gui.config.jdrr.infolable", "<span color=\"#4682B4\">\u00dcberpr\u00fcfe die IP-Adresse des Routers und dr\u00fcck auf Start,<br>ein Browserfenster mit der Startseite des Routers \u00f6ffnet sich,<br>nach dem Reconnect dr\u00fcckst du auf Stop und speicherst.<br>Mehr Informationen gibt es </span><a href=\"http://wiki.jdownloader.org/index.php?title=Recorder\">hier</a>"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 1", "[center]"));
        jPanel.add((Component)new JLabel(String.valueOf(JDL.L("gui.fengshuiconfig.routerip", "RouterIP")) + ":"), "split 3");
        jPanel.add((Component)this.routerip, "growx");
        jPanel.add(this.rawmode);
        jPanel.add((Component)jTextPane, "growx");
        return jPanel;
    }

    private void save() {
        int n = UserIO.getInstance().requestConfirmDialog(0, JDL.L("gui.config.jdrr.success", "Success!"), JDL.L("gui.config.jdrr.savereconnect", "Der Reconnect war erfolgreich m\u00f6chten sie jetzt speichern?"), UserIO.getInstance().getIcon(3), JDL.L("gui.btn_yes", "Ja"), JDL.L("gui.btn_no", "Nein"));
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{2, 32})) {
            int n2;
            int n3;
            Configuration configuration = JDUtilities.getConfiguration();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : ReconnectRecorder.steps) {
                stringBuilder.append(String.valueOf(string) + System.getProperty("line.separator"));
            }
            this.methode = stringBuilder.toString().trim();
            if (ReconnectRecorder.auth != null) {
                this.user = new Regex(ReconnectRecorder.auth, "(.+?):").getMatch(0);
                this.pass = new Regex(ReconnectRecorder.auth, ".+?:(.+)").getMatch(0);
                configuration.setProperty("HTTPSEND_USER", this.user);
                configuration.setProperty("HTTPSEND_PASS", this.pass);
            }
            this.btnCancel.setText(JDL.L("gui.btn_close", "Close"));
            configuration.setProperty("HTTPSEND_IP", this.routerip.getText().trim());
            configuration.setProperty("HTTPSEND_REQUESTS", this.methode);
            configuration.setProperty("PARAM_HTTPSEND_ROUTERNAME", "Reconnect Recorder Methode");
            configuration.setProperty("RECONNECT_TYPE", 0);
            if (reconnect_duration <= 2000L) {
                reconnect_duration = 2000L;
            }
            if ((n3 = (int)(reconnect_duration / 1000L * 2L)) < 30) {
                n3 = 30;
            }
            if ((n2 = (int)(reconnect_duration / 1000L / 2L)) < 30) {
                n2 = 5;
            }
            configuration.setProperty("RECONNECT_WAITFORIPCHANGE2", n3);
            configuration.setProperty("RECONNECT_IPCHECKWAITTIME2", n2);
            configuration.save();
            this.saved = true;
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK && !ReconnectRecorder.running && this.routerip.getText() != null && !this.routerip.getText().matches("\\s*")) {
            String string = this.routerip.getText().trim();
            boolean bl = false;
            if (string.contains("https")) {
                bl = true;
            }
            string = string.replaceAll("http://", "").replaceAll("https://", "");
            JDUtilities.getConfiguration().setProperty("HTTPSEND_IP", string);
            this.ip_before = IPCheck.getIPAddress();
            ReconnectRecorder.startServer(string, this.rawmode.isSelected());
            try {
                if (bl) {
                    JLink.openURL((String)("http://localhost:" + (SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + 1)));
                } else {
                    JLink.openURL((String)("http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972)));
                }
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
            new JDRRInfoPopup();
            return;
        }
        this.dispose();
    }

    public class JDRRInfoPopup
    extends AbstractDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private long reconnect_timer;
        private RRStatus statusicon;

        public JDRRInfoPopup() {
            super(268, JDL.L("gui.config.jdrr.status.title", "RRStatus"), null, null, JDL.L("gui.btn_abort", "Abort"));
            this.reconnect_timer = 0L;
            this.init();
        }

        public JComponent contentInit() {
            this.statusicon = new RRStatus();
            return this.statusicon;
        }

        public void packed() {
            this.remove(this.countDownLabel);
            this.pack();
            this.setMinimumSize(null);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.startCheck();
        }

        public void startCheck() {
            new Thread(){

                public void run() {
                    JDRRInfoPopup.this.statusicon.setStatus(0);
                    this.setName(JDL.L("gui.config.jdrr.popup.title", "JDRRPopup"));
                    JDRRInfoPopup.this.reconnect_timer = 0L;
                    while (ReconnectRecorder.running) {
                        try {
                            Thread.sleep(check_intervall);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Gui.this.ip_after = IPCheck.getIPAddress();
                        if (Gui.this.ip_after.contains("na") && JDRRInfoPopup.this.reconnect_timer == 0L) {
                            JDRRInfoPopup.this.reconnect_timer = System.currentTimeMillis();
                        }
                        if (Gui.this.ip_after.contains("na") || Gui.this.ip_after.equalsIgnoreCase(Gui.this.ip_before)) continue;
                        JDRRInfoPopup.this.statusicon.setStatus(1);
                        if (ReconnectRecorder.running) {
                            JDRRInfoPopup.this.closePopup();
                        }
                        return;
                    }
                }
            }.start();
        }

        public void closePopup() {
            ReconnectRecorder.stopServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JDRRInfoPopup.this.btnCancel.setEnabled(false);
                    Gui.this.ip_after = IPCheck.getIPAddress();
                    if (!Gui.this.ip_after.contains("offline") && !Gui.this.ip_after.equalsIgnoreCase(Gui.this.ip_before)) {
                        if (JDRRInfoPopup.this.reconnect_timer == 0L) {
                            reconnect_duration = check_intervall;
                        } else {
                            reconnect_duration = System.currentTimeMillis() - JDRRInfoPopup.this.reconnect_timer;
                        }
                        JDLogger.getLogger().info("dauer: " + reconnect_duration);
                        JDRRInfoPopup.this.statusicon.setStatus(1);
                    } else {
                        JDRRInfoPopup.this.statusicon.setStatus(-1);
                    }
                    if (!Gui.this.ip_after.contains("offline") && !Gui.this.ip_after.equalsIgnoreCase(Gui.this.ip_before)) {
                        Gui.this.save();
                    } else {
                        UserIO.getInstance().requestMessageDialog(JDL.L("gui.config.jdrr.reconnectfaild", "Reconnect failed"));
                    }
                    JDRRInfoPopup.this.dispose();
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.btnCancel) {
                this.closePopup();
            }
        }

        public class RRStatus
        extends JLabel {
            private static final long serialVersionUID = -3280613281656283625L;
            private ImageIcon imageProgress = JDTheme.II("gui.images.reconnect", 32, 32);
            private ImageIcon imageBad = JDTheme.II("gui.images.unselected", 32, 32);
            private ImageIcon imageGood = JDTheme.II("gui.images.selected", 32, 32);
            private String strProgress = JDL.L("jd.router.reconnectrecorder.Gui.icon.progress", "Recording Reconnect ...");
            private String strBad = JDL.L("jd.router.reconnectrecorder.Gui.icon.bad", "Error while recording the Reconnect!");
            private String strGood = JDL.L("jd.router.reconnectrecorder.Gui.icon.good", "Reconnect successfully recorded!");

            public RRStatus() {
                this.setStatus(0);
            }

            public void setStatus(int n) {
                if (n == 0) {
                    this.setIcon(this.imageProgress);
                    this.setText(this.strProgress);
                } else if (n == 1) {
                    this.setIcon(this.imageGood);
                    this.setText(this.strGood);
                } else {
                    this.setIcon(this.imageBad);
                    this.setText(this.strBad);
                }
            }
        }
    }
}

