/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import jd.controlling.JDLogger;
import jd.nutils.OSDetector;
import jd.utils.JDUtilities;

public class GetExplorer {
    private Object[] explorer = (Object[])JDUtilities.getConfiguration().getProperty("PARAM_FILE_BROWSER", null);

    private static Object[] autoGetExplorerCommand() {
        if (OSDetector.isWindows()) {
            return new Object[]{"Explorer", "explorer", new String[]{"%%path%%"}};
        }
        if (OSDetector.isMac()) {
            return new Object[]{"Open", "/usr/bin/open", new String[]{"%%path%%"}};
        }
        Object[][] objectArrayArray = new Object[][]{{"dolphin", new String[]{"%%path%%"}}, {"konqueror", new String[]{"%%path%%"}}, {"thunar", new String[]{"%%path%%"}}, {"rox", new String[]{"%%path%%"}}, {"pcmanfm", new String[]{"%%path%%"}}, {"nautilus", new String[]{"--browser", "--no-desktop", "%%path%%"}}};
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = System.getenv("PATH").split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                Object[][] objectArrayArray2 = objectArrayArray;
                int n3 = objectArrayArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object[] objectArray = objectArrayArray2[n4];
                    File file = new File(string, (String)objectArray[0]);
                    if (file.isFile()) {
                        return new Object[]{(String)objectArray[0], file.getAbsolutePath(), objectArray[1]};
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Object[] getExplorerCommand() {
        if (this.explorer != null) {
            if (!new File((String)this.explorer[1]).exists()) {
                this.explorer = null;
            }
            JDUtilities.getConfiguration().setProperty("PARAM_FILE_BROWSER", null);
        }
        if (this.explorer == null) {
            this.explorer = GetExplorer.autoGetExplorerCommand();
            if (this.explorer == null) {
                JDLogger.getLogger().severe("Can't find explorer command");
            } else {
                JDUtilities.getConfiguration().setProperty("PARAM_FILE_BROWSER", this.explorer);
            }
        }
        return this.explorer;
    }

    public boolean openExplorer(File file) {
        if (file == null) {
            return false;
        }
        this.getExplorerCommand();
        while (file != null && !file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file != null && this.explorer != null) {
            String string = file.getAbsolutePath();
            String[] stringArray = (String[])this.explorer[2];
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n].replace("%%path%%", string);
                ++n;
            }
            JDUtilities.runCommand((String)this.explorer[1], stringArray2, null, 0);
            return true;
        }
        return false;
    }
}

