/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.controlling.JDLogger;
import jd.nutils.JDImage;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDFileFilter;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTheme {
    private static HashMap<String, String> data = new HashMap();
    private static HashMap<String, String> defaultData;
    private static Logger logger;
    public static String THEME_DIR;
    private static String currentTheme;

    static {
        logger = JDLogger.getLogger();
        THEME_DIR = "jd/themes/";
    }

    public static ArrayList<String> getThemeIDs() {
        File file = JDUtilities.getResourceFile(THEME_DIR);
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles((FileFilter)new JDFileFilter(null, ".icl", false));
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            arrayList.add(file2.getName().split("\\.")[0]);
            ++n2;
        }
        return arrayList;
    }

    public static String getThemeValue(String string, String string2) {
        if (data == null || defaultData == null) {
            logger.severe("Use setTheme() first!");
            JDTheme.setTheme("default");
        }
        if (data.containsKey(string)) {
            return Encoding.UTF8Decode((String)data.get(string));
        }
        logger.warning("Key not found: " + string + " (" + string2 + ")");
        if (defaultData.containsKey(string)) {
            string2 = Encoding.UTF8Decode((String)defaultData.get(string));
            logger.finest("Use default Value: " + string2);
        }
        if (string2 == null) {
            string2 = string;
        }
        data.put(string, string2);
        return string2;
    }

    public static Color C(String string, String string2) {
        return new Color(Integer.parseInt(JDTheme.V(string, string2), 16));
    }

    public static Color C(String string, String string2, int n) {
        String string3 = JDTheme.V(string, string2);
        return new Color(Integer.parseInt(string3.substring(0, 2), 16), Integer.parseInt(string3.substring(2, 4), 16), Integer.parseInt(string3.substring(4), 16), n);
    }

    public static Image I(String string) {
        return JDImage.getImage((String)JDTheme.V(string));
    }

    public static Image I(String string, int n, int n2) {
        return JDImage.getImage((String)JDTheme.V(string)).getScaledInstance(n, n2, 4);
    }

    public static ImageIcon II(String string) {
        return JDTheme.II(string, 32, 32);
    }

    public static ImageIcon II(String string, int n, int n2) {
        try {
            return new ImageIcon(JDTheme.getImage(JDTheme.V(string), n, n2));
        }
        catch (Exception exception) {
            logger.severe("image not found: " + string + "(" + JDTheme.V(string) + "_" + n + "_" + n2);
            JDLogger.exception(exception);
            return null;
        }
    }

    public static Image getImage(String string, int n, int n2) {
        BufferedImage bufferedImage = JDImage.getImage((String)(String.valueOf(string) + "_" + n + "_" + n2));
        if (bufferedImage != null) {
            return bufferedImage;
        }
        try {
            return JDImage.getScaledImage((BufferedImage)JDImage.getImage((String)string), (int)n, (int)n2);
        }
        catch (Exception exception) {
            logger.severe("Could not find image: " + string);
            return null;
        }
    }

    public static String getTheme() {
        if (currentTheme == null) {
            return "default";
        }
        return currentTheme;
    }

    public static void setTheme(String string) {
        String string2;
        String string3;
        int n;
        String string4;
        String[] stringArray;
        File file = JDUtilities.getResourceFile(String.valueOf(THEME_DIR) + string + ".icl");
        if (!file.exists()) {
            logger.severe("Theme " + string + " not installed, switch to default theme");
            string = "default";
        }
        currentTheme = string;
        data = new HashMap();
        String string5 = JDIO.readFileToString((File)file);
        String[] stringArray2 = stringArray = Regex.getLines(string5);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            string4 = stringArray2[n3];
            n = string4.indexOf("=");
            if (n > 0 && !string4.startsWith("#")) {
                string3 = string4.substring(0, n).trim();
                string2 = string4.substring(n + 1).trim();
                if (data.containsKey(string3)) {
                    logger.severe("Dupe found: " + string3);
                } else {
                    data.put(string3, string2);
                }
            }
            ++n3;
        }
        if (string.equals("default")) {
            defaultData = data;
        }
        if (defaultData == null) {
            defaultData = new HashMap();
            file = JDUtilities.getResourceFile(String.valueOf(THEME_DIR) + "default.icl");
            if (!file.exists()) {
                logger.severe("Theme default not installed");
                return;
            }
            data = new HashMap();
            string5 = JDIO.readFileToString((File)file);
            stringArray2 = stringArray = Regex.getLines(string5);
            n2 = stringArray.length;
            n3 = 0;
            while (n3 < n2) {
                string4 = stringArray2[n3];
                n = string4.indexOf("=");
                if (n > 0 && !string4.startsWith("#")) {
                    string3 = string4.substring(0, n).trim();
                    string2 = string4.substring(n + 1).trim();
                    if (data.containsKey(string3)) {
                        logger.finer("Dupe found: " + string3);
                    } else {
                        data.put(string3, string2);
                    }
                }
                ++n3;
            }
        }
    }

    public static String V(String string) {
        return JDTheme.getThemeValue(string, null);
    }

    public static String V(String string, String string2) {
        return JDTheme.getThemeValue(string, string2);
    }
}

