/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.nutils.DiffMatchPatch;
import jd.nutils.JDFlags;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import tests.utils.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceInFiles {
    public static void main(String[] stringArray) {
        TestUtils.mainInit();
        TestUtils.initDecrypter();
        TestUtils.initContainer();
        TestUtils.initHosts();
        TestUtils.finishInit();
        new GuiRunnable<Object>(){

            public Object runSave() {
                File file;
                JDFileChooser jDFileChooser = new JDFileChooser();
                UserIO.setInstance((UserIO)UserIOGui.getInstance());
                jDFileChooser.setFileSelectionMode(1);
                if (jDFileChooser.showOpenDialog(null) == 0 && (file = jDFileChooser.getSelectedFile()) != null) {
                    String string = UserIO.getInstance().requestInputDialog("Define filepattern");
                    String string2 = UserIO.getInstance().requestInputDialog("Find pattern");
                    String string3 = UserIO.getInstance().requestInputDialog("Replace with pattern");
                    ReplaceInFiles.replaceInFiles(ReplaceInFiles.scanDir(file, string), string2, string3);
                }
                return null;
            }
        }.waitForEDT();
    }

    private static void replaceInFiles(ArrayList<File> arrayList, String string, String string2) {
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (File file : arrayList) {
            String string3 = JDIO.readFileToString((File)file);
            String string4 = Pattern.compile(string, 34).matcher(string3).replaceAll(string2);
            DiffMatchPatch diffMatchPatch = new DiffMatchPatch();
            LinkedList linkedList = diffMatchPatch.diffMain(string3, string4, true);
            String string5 = ReplaceInFiles.diffPrettyHtml(linkedList);
            if (!bl) {
                int n = UserIO.getInstance().requestConfirmDialog(224, "Diffs found in  " + l, string5, null, null, null);
                if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{4})) {
                    return;
                }
                if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{8, 2})) {
                    bl = true;
                }
            }
            System.out.println(string5);
            JDIO.writeLocalFile((File)file, (String)string4);
        }
    }

    public static String diffPrettyHtml(LinkedList<DiffMatchPatch.Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (DiffMatchPatch.Diff diff : linkedList) {
            String string = diff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>");
            switch (diff.operation) {
                case INSERT: {
                    stringBuilder.append("<span STYLE=\"color:#000000;background:#00FF00;border=1\" TITLE=\"i=").append(n).append("\">").append(string).append("</span>");
                    break;
                }
                case DELETE: {
                    stringBuilder.append("<span STYLE=\"color:#000000;background:#FF0000;border=1\" TITLE=\"i=").append(n).append("\">").append(string).append("</span>");
                    break;
                }
                case EQUAL: {
                    String[] stringArray = diff.text.split("[\r\n]{1,2}");
                    if (stringArray.length > 2) {
                        stringBuilder.append("<SPAN TITLE=\"i=").append(n).append("\">").append(stringArray[0].replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>")).append("</SPAN>");
                        stringBuilder.append("<br>[.....]<br>");
                        stringBuilder.append("<SPAN TITLE=\"i=").append(n).append("\">").append(stringArray[stringArray.length - 1].replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<BR>")).append("</SPAN>");
                        break;
                    }
                    stringBuilder.append("<SPAN TITLE=\"i=").append(n).append("\">").append(string).append("</SPAN>");
                }
            }
            if (diff.operation == DiffMatchPatch.Operation.DELETE) continue;
            n += diff.text.length();
        }
        return stringBuilder.toString();
    }

    private static ArrayList<File> scanDir(File file, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                arrayList.addAll(ReplaceInFiles.scanDir(file2, string));
            } else if (!file2.getAbsolutePath().contains(".svn") && new Regex(file2.getAbsolutePath(), string).matches()) {
                System.out.println("Find in file: " + file2);
                arrayList.add(file2);
            }
            ++n2;
        }
        return arrayList;
    }
}

